/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.gpf;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.CrsGeoCoding;
import org.esa.beam.framework.datamodel.GcpDescriptor;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.MapGeoCoding;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Placemark;
import org.esa.beam.framework.datamodel.PlacemarkDescriptor;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.ProductNodeGroup;
import org.esa.beam.framework.datamodel.TiePointGeoCoding;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.framework.dataop.maptransf.Datum;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.util.ProductUtils;
import org.esa.beam.util.StringUtils;
import org.esa.beam.util.math.MathUtils;
import org.esa.snap.datamodel.AbstractMetadata;
import org.esa.snap.gpf.ReaderUtils;
import org.esa.snap.util.ExceptionLog;

public final class OperatorUtils {
    public static final String TPG_SLANT_RANGE_TIME = "slant_range_time";
    public static final String TPG_INCIDENT_ANGLE = "incident_angle";
    public static final String TPG_ELEVATION_ANGLE = "elevation_angle";
    public static final String TPG_LATITUDE = "latitude";
    public static final String TPG_LONGITUDE = "longitude";

    public static TiePointGrid getIncidenceAngle(Product sourceProduct) {
        return sourceProduct.getTiePointGrid(TPG_INCIDENT_ANGLE);
    }

    public static TiePointGrid getSlantRangeTime(Product sourceProduct) {
        return sourceProduct.getTiePointGrid(TPG_SLANT_RANGE_TIME);
    }

    public static TiePointGrid getLatitude(Product sourceProduct) {
        return sourceProduct.getTiePointGrid(TPG_LATITUDE);
    }

    public static TiePointGrid getLongitude(Product sourceProduct) {
        return sourceProduct.getTiePointGrid(TPG_LONGITUDE);
    }

    public static String getBandPolarization(String bandName, MetadataElement absRoot) {
        String pol = OperatorUtils.getPolarizationFromBandName(bandName);
        if (pol != null) {
            return pol;
        }
        String[] mdsPolar = OperatorUtils.getProductPolarization(absRoot);
        return mdsPolar[0];
    }

    public static String getPolarizationFromBandName(String bandName) {
        String pol = "";
        String bandNameLower = bandName.toLowerCase();
        if (bandNameLower.contains("_hh")) {
            pol = pol + "hh";
        }
        if (bandNameLower.contains("_vv")) {
            pol = pol + "vv";
        }
        if (bandNameLower.contains("_hv")) {
            pol = pol + "hv";
        }
        if (bandNameLower.contains("_vh")) {
            pol = pol + "vh";
        }
        if (pol.length() == 2) {
            return pol;
        }
        if (pol.length() > 2) {
            throw new OperatorException("Band name contains multiple polarziations: " + pol);
        }
        return null;
    }

    public static String[] getProductPolarization(MetadataElement absRoot) {
        String[] mdsPolar = new String[4];
        for (int i = 0; i < mdsPolar.length; ++i) {
            String polarName = absRoot.getAttributeString(AbstractMetadata.polarTags[i], "").toLowerCase();
            mdsPolar[i] = "";
            if (!polarName.contains("hh") && !polarName.contains("hv") && !polarName.contains("vh") && !polarName.contains("vv")) continue;
            mdsPolar[i] = polarName;
        }
        return mdsPolar;
    }

    public static String getPrefixFromBandName(String bandName) {
        int idx1 = bandName.indexOf(95);
        if (idx1 != -1) {
            return bandName.substring(0, idx1);
        }
        int idx2 = bandName.indexOf(45);
        if (idx2 != -1) {
            return bandName.substring(0, idx2);
        }
        int idx3 = bandName.indexOf(46);
        if (idx3 != -1) {
            return bandName.substring(0, idx3);
        }
        return null;
    }

    public static String getSuffixFromBandName(String bandName) {
        int idx1 = bandName.indexOf(95);
        if (idx1 != -1) {
            return bandName.substring(idx1 + 1);
        }
        int idx2 = bandName.indexOf(45);
        if (idx2 != -1) {
            return bandName.substring(idx2 + 1);
        }
        int idx3 = bandName.indexOf(46);
        if (idx3 != -1) {
            return bandName.substring(idx3 + 1);
        }
        return null;
    }

    public static void copyVirtualBand(Product product, VirtualBand srcBand, String name) {
        VirtualBand virtBand = new VirtualBand(name, srcBand.getDataType(), srcBand.getSceneRasterWidth(), srcBand.getSceneRasterHeight(), srcBand.getExpression());
        virtBand.setUnit(srcBand.getUnit());
        virtBand.setDescription(srcBand.getDescription());
        virtBand.setNoDataValue(srcBand.getNoDataValue());
        virtBand.setNoDataValueUsed(srcBand.isNoDataValueUsed());
        product.addBand((Band)virtBand);
    }

    public static boolean isDIMAP(Product prod) {
        return StringUtils.contains((String[])prod.getProductReader().getReaderPlugIn().getFormatNames(), (String)"BEAM-DIMAP");
    }

    public static boolean isMapProjected(Product product) {
        if (product.getGeoCoding() instanceof MapGeoCoding || product.getGeoCoding() instanceof CrsGeoCoding) {
            return true;
        }
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata(product);
        return absRoot != null && !absRoot.getAttributeString("map_projection", "").trim().isEmpty();
    }

    public static boolean isComplex(Product product) {
        String sampleType;
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata(product);
        return absRoot != null && (sampleType = absRoot.getAttributeString("SAMPLE_TYPE", "").trim()).equalsIgnoreCase("complex");
    }

    public static boolean isQuadPol(Product product) {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata(product);
        if (absRoot != null) {
            String pol1 = absRoot.getAttributeString("mds1_tx_rx_polar", "").trim();
            String pol2 = absRoot.getAttributeString("mds2_tx_rx_polar", "").trim();
            String pol3 = absRoot.getAttributeString("mds3_tx_rx_polar", "").trim();
            String pol4 = absRoot.getAttributeString("mds4_tx_rx_polar", "").trim();
            if (!(pol1.isEmpty() || pol2.isEmpty() || pol3.isEmpty() || pol4.isEmpty())) {
                return true;
            }
        }
        return false;
    }

    public static void copyGCPsToTarget(ProductNodeGroup<Placemark> group, ProductNodeGroup<Placemark> targetGCPGroup, GeoCoding targetGeoCoding) {
        targetGCPGroup.removeAll();
        for (int i = 0; i < group.getNodeCount(); ++i) {
            Placemark sPin = (Placemark)group.get(i);
            Placemark tPin = Placemark.createPointPlacemark((PlacemarkDescriptor)GcpDescriptor.getInstance(), (String)sPin.getName(), (String)sPin.getLabel(), (String)sPin.getDescription(), (PixelPos)sPin.getPixelPos(), (GeoPos)sPin.getGeoPos(), (GeoCoding)targetGeoCoding);
            targetGCPGroup.add((ProductNode)tPin);
        }
    }

    public static Product createDummyTargetProduct(Product[] sourceProducts) {
        Product targetProduct = new Product(sourceProducts[0].getName(), sourceProducts[0].getProductType(), sourceProducts[0].getSceneRasterWidth(), sourceProducts[0].getSceneRasterHeight());
        ProductUtils.copyProductNodes((Product)sourceProducts[0], (Product)targetProduct);
        for (Product prod : sourceProducts) {
            for (Band band : prod.getBands()) {
                ProductUtils.copyBand((String)band.getName(), (Product)prod, (String)band.getName(), (Product)targetProduct, (boolean)false);
            }
        }
        return targetProduct;
    }

    public static String getAcquisitionDate(MetadataElement root) {
        String dateString;
        try {
            ProductData.UTC date = root.getAttributeUTC("first_line_time");
            DateFormat dateFormat = ProductData.UTC.createDateFormat((String)"ddMMMyyyy");
            dateString = dateFormat.format(date.getAsDate());
        }
        catch (Exception e) {
            dateString = "";
        }
        return dateString;
    }

    public static void createNewTiePointGridsAndGeoCoding(Product sourceProduct, Product targetProduct, int gridWidth, int gridHeight, float subSamplingX, float subSamplingY, PixelPos[] newTiePointPos) {
        TiePointGrid latGrid = null;
        TiePointGrid lonGrid = null;
        for (TiePointGrid srcTPG : sourceProduct.getTiePointGrids()) {
            float[] tiePoints = new float[gridWidth * gridHeight];
            for (int k = 0; k < newTiePointPos.length; ++k) {
                tiePoints[k] = srcTPG.getPixelFloat(newTiePointPos[k].x, newTiePointPos[k].y);
            }
            int discontinuity = TiePointGrid.DISCONT_NONE;
            if (srcTPG.getName().equals(TPG_LONGITUDE)) {
                discontinuity = TiePointGrid.DISCONT_AT_180;
            }
            TiePointGrid tgtTPG = new TiePointGrid(srcTPG.getName(), gridWidth, gridHeight, 0.0f, 0.0f, subSamplingX, subSamplingY, tiePoints, discontinuity);
            targetProduct.addTiePointGrid(tgtTPG);
            if (srcTPG.getName().equals(TPG_LATITUDE)) {
                latGrid = tgtTPG;
                continue;
            }
            if (!srcTPG.getName().equals(TPG_LONGITUDE)) continue;
            lonGrid = tgtTPG;
        }
        TiePointGeoCoding gc = new TiePointGeoCoding(latGrid, lonGrid);
        targetProduct.setGeoCoding((GeoCoding)gc);
    }

    public static Band[] getSourceBands(Product sourceProduct, String[] sourceBandNames) throws OperatorException {
        if (sourceBandNames == null || sourceBandNames.length == 0) {
            Band[] bands = sourceProduct.getBands();
            ArrayList<String> bandNameList = new ArrayList<String>(sourceProduct.getNumBands());
            Band[] bandArray = bands;
            int n = bandArray.length;
            for (int i = 0; i < n; ++i) {
                Band band = bandArray[i];
                if (band instanceof VirtualBand) continue;
                bandNameList.add(band.getName());
            }
            sourceBandNames = bandNameList.toArray(new String[bandNameList.size()]);
        }
        ArrayList<Band> sourceBandList = new ArrayList<Band>(sourceBandNames.length);
        for (String sourceBandName : sourceBandNames) {
            Band sourceBand = sourceProduct.getBand(sourceBandName);
            if (sourceBand == null) continue;
            sourceBandList.add(sourceBand);
        }
        return sourceBandList.toArray(new Band[sourceBandList.size()]);
    }

    public static Band[] addBands(Product targetProduct, String[] targetBandNameList, String suffix) {
        ArrayList<Band> bandList = new ArrayList<Band>(targetBandNameList.length);
        for (String targetBandName : targetBandNameList) {
            Band targetBand = new Band(targetBandName + suffix, 30, targetProduct.getSceneRasterWidth(), targetProduct.getSceneRasterHeight());
            if (targetBandName.contains("_real")) {
                targetBand.setUnit("real");
            } else if (targetBandName.contains("_imag")) {
                targetBand.setUnit("imaginary");
            } else {
                targetBand.setUnit("intensity");
            }
            bandList.add(targetBand);
            targetProduct.addBand(targetBand);
        }
        return bandList.toArray(new Band[bandList.size()]);
    }

    public static void catchOperatorException(String opName, Throwable e) throws OperatorException {
        if (opName.contains("$")) {
            opName = opName.substring(0, opName.indexOf(36));
        }
        String message = opName + ": ";
        message = e.getMessage() != null ? message + e.getMessage() : message + e.toString();
        if (Boolean.getBoolean("sendErrorOnException")) {
            ExceptionLog.log(message);
        }
        System.out.println(message);
        throw new OperatorException(message);
    }

    public static void computeImageGeoBoundary(Product[] sourceProducts, SceneProperties scnProp) {
        scnProp.latMin = 90.0;
        scnProp.latMax = -90.0;
        scnProp.lonMin = 180.0;
        scnProp.lonMax = -180.0;
        for (Product srcProd : sourceProducts) {
            GeoCoding geoCoding = srcProd.getGeoCoding();
            GeoPos geoPosFirstNear = geoCoding.getGeoPos(new PixelPos(0.0f, 0.0f), null);
            GeoPos geoPosFirstFar = geoCoding.getGeoPos(new PixelPos((float)(srcProd.getSceneRasterWidth() - 1), 0.0f), null);
            GeoPos geoPosLastNear = geoCoding.getGeoPos(new PixelPos(0.0f, (float)(srcProd.getSceneRasterHeight() - 1)), null);
            GeoPos geoPosLastFar = geoCoding.getGeoPos(new PixelPos((float)(srcProd.getSceneRasterWidth() - 1), (float)(srcProd.getSceneRasterHeight() - 1)), null);
            double[] lats = new double[]{geoPosFirstNear.getLat(), geoPosFirstFar.getLat(), geoPosLastNear.getLat(), geoPosLastFar.getLat()};
            double[] lons = new double[]{geoPosFirstNear.getLon(), geoPosFirstFar.getLon(), geoPosLastNear.getLon(), geoPosLastFar.getLon()};
            scnProp.srcCornerLatitudeMap.put(srcProd, lats);
            scnProp.srcCornerLongitudeMap.put(srcProd, lons);
            for (double lat : lats) {
                if (lat < scnProp.latMin) {
                    scnProp.latMin = lat;
                }
                if (!(lat > scnProp.latMax)) continue;
                scnProp.latMax = lat;
            }
            for (double lon : lons) {
                if (lon < scnProp.lonMin) {
                    scnProp.lonMin = lon;
                }
                if (!(lon > scnProp.lonMax)) continue;
                scnProp.lonMax = lon;
            }
        }
    }

    public static ImageGeoBoundary computeImageGeoBoundary(Product sourceProduct) throws OperatorException {
        ImageGeoBoundary geoBoundary = new ImageGeoBoundary();
        GeoCoding geoCoding = sourceProduct.getGeoCoding();
        if (geoCoding == null) {
            throw new OperatorException("Product does not contain a geocoding");
        }
        GeoPos geoPosFirstNear = geoCoding.getGeoPos(new PixelPos(0.5f, 0.5f), null);
        GeoPos geoPosFirstFar = geoCoding.getGeoPos(new PixelPos((float)sourceProduct.getSceneRasterWidth() - 0.5f, 0.5f), null);
        GeoPos geoPosLastNear = geoCoding.getGeoPos(new PixelPos(0.5f, (float)sourceProduct.getSceneRasterHeight() - 0.5f), null);
        GeoPos geoPosLastFar = geoCoding.getGeoPos(new PixelPos((float)sourceProduct.getSceneRasterWidth() - 0.5f, (float)sourceProduct.getSceneRasterHeight() - 0.5f), null);
        double[] lats = new double[]{geoPosFirstNear.getLat(), geoPosFirstFar.getLat(), geoPosLastNear.getLat(), geoPosLastFar.getLat()};
        double[] lons = new double[]{geoPosFirstNear.getLon(), geoPosFirstFar.getLon(), geoPosLastNear.getLon(), geoPosLastFar.getLon()};
        geoBoundary.latMin = 90.0;
        geoBoundary.latMax = -90.0;
        for (double lat : lats) {
            if (lat < geoBoundary.latMin) {
                geoBoundary.latMin = lat;
            }
            if (!(lat > geoBoundary.latMax)) continue;
            geoBoundary.latMax = lat;
        }
        geoBoundary.lonMin = 180.0;
        geoBoundary.lonMax = -180.0;
        for (double lon : lons) {
            if (lon < geoBoundary.lonMin) {
                geoBoundary.lonMin = lon;
            }
            if (!(lon > geoBoundary.lonMax)) continue;
            geoBoundary.lonMax = lon;
        }
        if (geoBoundary.lonMax - geoBoundary.lonMin >= 180.0) {
            geoBoundary.lonMin = 360.0;
            geoBoundary.lonMax = 0.0;
            for (double lon : lons) {
                if (lon < 0.0) {
                    lon += 360.0;
                }
                if (lon < geoBoundary.lonMin) {
                    geoBoundary.lonMin = lon;
                }
                if (!(lon > geoBoundary.lonMax)) continue;
                geoBoundary.lonMax = lon;
            }
        }
        return geoBoundary;
    }

    public static void getSceneDimensions(double minSpacing, SceneProperties scnProp) {
        double minAbsLat = scnProp.latMin * scnProp.latMax > 0.0 ? Math.min(Math.abs(scnProp.latMin), Math.abs(scnProp.latMax)) * (Math.PI / 180) : 0.0;
        double delLat = minSpacing / 6371008.7714 * 57.29577951308232;
        double delLon = minSpacing / (6371008.7714 * Math.cos(minAbsLat)) * 57.29577951308232;
        delLon = delLat = Math.min(delLat, delLon);
        scnProp.sceneWidth = (int)((scnProp.lonMax - scnProp.lonMin) / delLon) + 1;
        scnProp.sceneHeight = (int)((scnProp.latMax - scnProp.latMin) / delLat) + 1;
    }

    public static void addGeoCoding(Product targetProduct, SceneProperties scnProp) {
        float[] latTiePoints = new float[]{(float)scnProp.latMax, (float)scnProp.latMax, (float)scnProp.latMin, (float)scnProp.latMin};
        float[] lonTiePoints = new float[]{(float)scnProp.lonMin, (float)scnProp.lonMax, (float)scnProp.lonMin, (float)scnProp.lonMax};
        int gridWidth = 10;
        int gridHeight = 10;
        float[] fineLatTiePoints = new float[100];
        ReaderUtils.createFineTiePointGrid(2, 2, 10, 10, latTiePoints, fineLatTiePoints);
        float subSamplingX = (float)targetProduct.getSceneRasterWidth() / 9.0f;
        float subSamplingY = (float)targetProduct.getSceneRasterHeight() / 9.0f;
        TiePointGrid latGrid = new TiePointGrid(TPG_LATITUDE, 10, 10, 0.5f, 0.5f, subSamplingX, subSamplingY, fineLatTiePoints);
        latGrid.setUnit("deg");
        float[] fineLonTiePoints = new float[100];
        ReaderUtils.createFineTiePointGrid(2, 2, 10, 10, lonTiePoints, fineLonTiePoints);
        TiePointGrid lonGrid = new TiePointGrid(TPG_LONGITUDE, 10, 10, 0.5f, 0.5f, subSamplingX, subSamplingY, fineLonTiePoints, TiePointGrid.DISCONT_AT_180);
        lonGrid.setUnit("deg");
        TiePointGeoCoding tpGeoCoding = new TiePointGeoCoding(latGrid, lonGrid, Datum.WGS_84);
        targetProduct.addTiePointGrid(latGrid);
        targetProduct.addTiePointGrid(lonGrid);
        targetProduct.setGeoCoding((GeoCoding)tpGeoCoding);
    }

    public static void addSelectedBands(Product sourceProduct, String[] sourceBandNames, Product targetProduct, Map<String, String[]> targetBandNameToSourceBandName, boolean outputIntensity, boolean outputFloat) throws OperatorException {
        Band[] sourceBands = OperatorUtils.getSourceBands(sourceProduct, sourceBandNames);
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata(sourceProduct);
        boolean isPolsar = absRoot.getAttributeInt("polsar_data", 0) == 1;
        for (int i = 0; i < sourceBands.length; ++i) {
            String targetBandName;
            Band srcBand = sourceBands[i];
            String unit = srcBand.getUnit();
            if (unit == null) {
                unit = "amplitude";
            }
            String targetUnit = "";
            if (unit.contains("phase") && outputIntensity) continue;
            if (unit.contains("imaginary") && outputIntensity && !isPolsar) {
                throw new OperatorException("Real and imaginary bands should be selected in pairs");
            }
            if (unit.contains("real") && outputIntensity && !isPolsar) {
                String pol;
                if (i == sourceBands.length - 1) {
                    throw new OperatorException("Real and imaginary bands should be selected in pairs");
                }
                String nextUnit = sourceBands[i + 1].getUnit();
                if (!(nextUnit != null && (unit.equals("real") && nextUnit.equals("imaginary") || unit.equals("imaginary") && nextUnit.equals("real")))) {
                    throw new OperatorException("Real and imaginary bands should be selected in pairs");
                }
                String[] srcBandNames = new String[]{srcBand.getName(), sourceBands[i + 1].getName()};
                targetBandName = "Intensity";
                String suff = OperatorUtils.getSuffixFromBandName(srcBandNames[0]);
                if (suff != null) {
                    targetBandName = targetBandName + '_' + suff;
                }
                if (!((pol = OperatorUtils.getBandPolarization(srcBandNames[0], absRoot)) == null || pol.isEmpty() || isPolsar || targetBandName.toLowerCase().contains(pol))) {
                    targetBandName = targetBandName + '_' + pol.toUpperCase();
                }
                if (isPolsar) {
                    String pre = OperatorUtils.getPrefixFromBandName(srcBandNames[0]);
                    targetBandName = "Intensity_" + pre;
                }
                ++i;
                if (targetProduct.getBand(targetBandName) == null) {
                    targetBandNameToSourceBandName.put(targetBandName, srcBandNames);
                    targetUnit = "intensity";
                }
            } else {
                String[] srcBandNames = new String[]{srcBand.getName()};
                targetBandName = srcBand.getName();
                String pol = OperatorUtils.getBandPolarization(targetBandName, absRoot);
                if (!(pol == null || pol.isEmpty() || isPolsar || targetBandName.toLowerCase().contains(pol))) {
                    targetBandName = targetBandName + '_' + pol.toUpperCase();
                }
                if (targetProduct.getBand(targetBandName) == null) {
                    targetBandNameToSourceBandName.put(targetBandName, srcBandNames);
                    targetUnit = unit;
                }
            }
            if (targetProduct.getBand(targetBandName) != null) continue;
            int dataType = srcBand.getDataType();
            if (outputFloat) {
                dataType = 30;
            }
            if (outputIntensity && (dataType == 10 || dataType == 11)) {
                dataType = 12;
            }
            if (outputIntensity && (dataType == 20 || dataType == 21)) {
                dataType = 22;
            }
            Band targetBand = new Band(targetBandName, dataType, targetProduct.getSceneRasterWidth(), targetProduct.getSceneRasterHeight());
            targetBand.setUnit(targetUnit);
            targetBand.setDescription(srcBand.getDescription());
            targetBand.setNoDataValue(srcBand.getNoDataValue());
            targetBand.setNoDataValueUsed(srcBand.isNoDataValueUsed());
            targetProduct.addBand(targetBand);
        }
    }

    public static Rectangle[] getAllTileRectangles(Product sourceProduct, Dimension tileSize, int margin) {
        int rasterHeight = sourceProduct.getSceneRasterHeight() - margin - margin;
        int rasterWidth = sourceProduct.getSceneRasterWidth() - margin - margin;
        Rectangle boundary = new Rectangle(margin, margin, rasterWidth, rasterHeight);
        int tileCountX = MathUtils.ceilInt((double)((double)boundary.width / (double)tileSize.width));
        int tileCountY = MathUtils.ceilInt((double)((double)boundary.height / (double)tileSize.height));
        Rectangle[] rectangles = new Rectangle[tileCountX * tileCountY];
        int index = 0;
        for (int tileY = 0; tileY < tileCountY; ++tileY) {
            for (int tileX = 0; tileX < tileCountX; ++tileX) {
                Rectangle intersection;
                Rectangle tileRectangle = new Rectangle(tileX * tileSize.width + margin, tileY * tileSize.height + margin, tileSize.width, tileSize.height);
                rectangles[index] = intersection = boundary.intersection(tileRectangle);
                ++index;
            }
        }
        return rectangles;
    }

    public static class SceneProperties {
        public int sceneWidth;
        public int sceneHeight;
        public double latMin;
        public double lonMin;
        public double latMax;
        public double lonMax;
        public final Map<Product, double[]> srcCornerLatitudeMap = new HashMap<Product, double[]>(10);
        public final Map<Product, double[]> srcCornerLongitudeMap = new HashMap<Product, double[]>(10);
    }

    public static class ImageGeoBoundary {
        public double latMin = 0.0;
        public double latMax = 0.0;
        public double lonMin = 0.0;
        public double lonMax = 0.0;
    }
}

