/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.eo;

import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.snap.gpf.TileGeoreferencing;

public class LocalGeometry {
    public double leftPointLat;
    public double leftPointLon;
    public double rightPointLat;
    public double rightPointLon;
    public double upPointLat;
    public double upPointLon;
    public double downPointLat;
    public double downPointLon;
    public double[] sensorPos;
    public double[] centrePoint;

    public LocalGeometry(int x, int y, TileGeoreferencing tileGeoRef, double[] earthPoint, double[] sensorPos) {
        GeoPos geo = new GeoPos();
        tileGeoRef.getGeoPos(x - 1, y, geo);
        this.leftPointLat = geo.lat;
        this.leftPointLon = geo.lon;
        tileGeoRef.getGeoPos(x + 1, y, geo);
        this.rightPointLat = geo.lat;
        this.rightPointLon = geo.lon;
        tileGeoRef.getGeoPos(x, y - 1, geo);
        this.upPointLat = geo.lat;
        this.upPointLon = geo.lon;
        tileGeoRef.getGeoPos(x, y + 1, geo);
        this.downPointLat = geo.lat;
        this.downPointLon = geo.lon;
        this.centrePoint = earthPoint;
        this.sensorPos = sensorPos;
    }

    public LocalGeometry(double lat, double lon, double delLat, double delLon, double[] earthPoint, double[] sensorPos) {
        this.leftPointLat = lat;
        this.leftPointLon = lon - delLon;
        this.rightPointLat = lat;
        this.rightPointLon = lon + delLon;
        this.upPointLat = lat - delLat;
        this.upPointLon = lon;
        this.downPointLat = lat + delLat;
        this.downPointLon = lon;
        this.centrePoint = earthPoint;
        this.sensorPos = sensorPos;
    }
}

