/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.eo;

import Jama.Matrix;
import org.apache.commons.math3.util.FastMath;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.snap.datamodel.Orbits;

public final class GeoUtils {
    private static final double EPS5 = 1.0E-5;
    private static final double EPS = 1.0E-10;

    private GeoUtils() {
    }

    public static void geo2xyz(GeoPos geoPos, double[] xyz) {
        GeoUtils.geo2xyz(geoPos.lat, geoPos.lon, 0.0, xyz, EarthModel.WGS84);
    }

    public static void geo2xyz(double latitude, double longitude, double altitude, double[] xyz, EarthModel geoSystem) {
        double a = 0.0;
        double e2 = 0.0;
        if (geoSystem == EarthModel.WGS84) {
            a = 6378137.0;
            e2 = 0.006694379990141381;
        } else if (geoSystem == EarthModel.GRS80) {
            a = 6378137.0;
            e2 = 0.006694380023011879;
        } else {
            throw new OperatorException("Incorrect geodetic system");
        }
        double lat = latitude * (Math.PI / 180);
        double lon = longitude * (Math.PI / 180);
        double sinLat = FastMath.sin((double)lat);
        double cosLat = FastMath.cos((double)lat);
        double N = a / Math.sqrt(1.0 - e2 * sinLat * sinLat);
        xyz[0] = (N + altitude) * cosLat * FastMath.cos((double)lon);
        xyz[1] = (N + altitude) * cosLat * FastMath.sin((double)lon);
        xyz[2] = ((1.0 - e2) * N + altitude) * sinLat;
    }

    public static void geo2xyzWGS84(double latitude, double longitude, double altitude, double[] xyz) {
        double lat = latitude * (Math.PI / 180);
        double lon = longitude * (Math.PI / 180);
        double sinLat = FastMath.sin((double)lat);
        double N = 6378137.0 / Math.sqrt(1.0 - 0.006694379990141381 * sinLat * sinLat);
        double NcosLat = (N + altitude) * FastMath.cos((double)lat);
        xyz[0] = NcosLat * FastMath.cos((double)lon);
        xyz[1] = NcosLat * FastMath.sin((double)lon);
        xyz[2] = (N + altitude - 0.006694379990141381 * N) * sinLat;
    }

    public static void xyz2geo(double[] xyz, GeoPos geoPos) {
        GeoUtils.xyz2geoWGS84(xyz, geoPos);
    }

    public static void xyz2geo(double[] xyz, GeoPos geoPos, EarthModel geoSystem) {
        double a = 0.0;
        double b = 0.0;
        double e2 = 0.0;
        double ep2 = 0.0;
        if (geoSystem == EarthModel.WGS84) {
            a = 6378137.0;
            b = 6356752.314245179;
            e2 = 0.006694379990141381;
            ep2 = 0.006739496742276499;
        } else if (geoSystem == EarthModel.GRS80) {
            a = 6378137.0;
            b = 6356752.31414;
            e2 = 0.006694380023011879;
            ep2 = 0.006739496775591552;
        } else {
            throw new OperatorException("Incorrect geodetic system");
        }
        double x = xyz[0];
        double y = xyz[1];
        double z = xyz[2];
        double s = Math.sqrt(x * x + y * y);
        double theta = FastMath.atan((double)(z * a / (s * b)));
        geoPos.lon = (float)(FastMath.atan((double)(y / x)) * 57.29577951308232);
        if ((double)geoPos.lon < 0.0 && y >= 0.0) {
            geoPos.lon = (float)((double)geoPos.lon + 180.0);
        } else if ((double)geoPos.lon > 0.0 && y < 0.0) {
            geoPos.lon = (float)((double)geoPos.lon - 180.0);
        }
        geoPos.lat = (float)(FastMath.atan((double)((z + ep2 * b * FastMath.pow((double)FastMath.sin((double)theta), (int)3)) / (s - e2 * a * FastMath.pow((double)FastMath.cos((double)theta), (int)3)))) * 57.29577951308232);
    }

    public static void xyz2geoWGS84(double[] xyz, GeoPos geoPos) {
        double x = xyz[0];
        double y = xyz[1];
        double z = xyz[2];
        double s = Math.sqrt(x * x + y * y);
        double theta = FastMath.atan((double)(z * 6378137.0 / (s * 6356752.314245179)));
        geoPos.lon = (float)(FastMath.atan((double)(y / x)) * 57.29577951308232);
        if ((double)geoPos.lon < 0.0 && y >= 0.0) {
            geoPos.lon = (float)((double)geoPos.lon + 180.0);
        } else if ((double)geoPos.lon > 0.0 && y < 0.0) {
            geoPos.lon = (float)((double)geoPos.lon - 180.0);
        }
        geoPos.lat = (float)(FastMath.atan((double)((z + 42841.31151331398 * FastMath.pow((double)FastMath.sin((double)theta), (int)3)) / (s - 42697.672707180376 * FastMath.pow((double)FastMath.cos((double)theta), (int)3)))) * 57.29577951308232);
    }

    public static void polar2cartesian(double latitude, double longitude, double radius, double[] xyz) {
        double latRad = latitude * (Math.PI / 180);
        double lonRad = longitude * (Math.PI / 180);
        double sinLat = FastMath.sin((double)latRad);
        double cosLat = FastMath.cos((double)latRad);
        xyz[0] = radius * cosLat * FastMath.cos((double)lonRad);
        xyz[1] = radius * cosLat * FastMath.sin((double)lonRad);
        xyz[2] = radius * sinLat;
    }

    public static void cartesian2polar(double[] xyz, double[] phiLamHeight) {
        phiLamHeight[2] = Math.sqrt(xyz[0] * xyz[0] + xyz[1] * xyz[1] + xyz[2] * xyz[2]);
        phiLamHeight[1] = Math.atan2(xyz[1], xyz[0]);
        phiLamHeight[0] = Math.asin(xyz[2] / phiLamHeight[2]);
    }

    public static void computeAccurateXYZ(Orbits.OrbitData data, double[] xyz, double time) {
        double a = 6378137.0;
        double b = 6356752.314245179;
        double a2 = 4.0680631590769E13;
        double b2 = 4.0408299984661445E13;
        double del = 0.001;
        int maxIter = 10;
        Matrix X = new Matrix(3, 1);
        Matrix F = new Matrix(3, 1);
        Matrix J = new Matrix(3, 3);
        X.set(0, 0, xyz[0]);
        X.set(1, 0, xyz[1]);
        X.set(2, 0, xyz[2]);
        J.set(0, 0, data.xVel);
        J.set(0, 1, data.yVel);
        J.set(0, 2, data.zVel);
        double time2 = FastMath.pow((double)(time * 1.49896229E8), (double)2.0);
        for (int i = 0; i < 10; ++i) {
            double x = X.get(0, 0);
            double y = X.get(1, 0);
            double z = X.get(2, 0);
            double dx = x - data.xPos;
            double dy = y - data.yPos;
            double dz = z - data.zPos;
            F.set(0, 0, data.xVel * dx + data.yVel * dy + data.zVel * dz);
            F.set(1, 0, dx * dx + dy * dy + dz * dz - time2);
            F.set(2, 0, x * x / 4.0680631590769E13 + y * y / 4.0680631590769E13 + z * z / 4.0408299984661445E13 - 1.0);
            J.set(1, 0, 2.0 * dx);
            J.set(1, 1, 2.0 * dy);
            J.set(1, 2, 2.0 * dz);
            J.set(2, 0, 2.0 * x / 4.0680631590769E13);
            J.set(2, 1, 2.0 * y / 4.0680631590769E13);
            J.set(2, 2, 2.0 * z / 4.0408299984661445E13);
            X = X.minus(J.inverse().times(F));
            if (Math.abs(F.get(0, 0)) <= 0.001 && Math.abs(F.get(1, 0)) <= 0.001 && Math.abs(F.get(2, 0)) <= 0.001) break;
        }
        xyz[0] = X.get(0, 0);
        xyz[1] = X.get(1, 0);
        xyz[2] = X.get(2, 0);
    }

    public static LatLonHeading vincenty_direct(double lon1, double lat1, double dist, double head1) {
        double E;
        double CY;
        double CZ;
        double SY;
        LatLonHeading pos = new LatLonHeading();
        lon1 *= Math.PI / 180;
        double FAZ = head1 * (Math.PI / 180);
        double F = 0.0;
        double R = 1.0;
        double TU = 1.0 * Math.tan(lat1 *= Math.PI / 180);
        double SF = Math.sin(FAZ);
        double CF = Math.cos(FAZ);
        double BAZ = 0.0;
        if (CF != 0.0) {
            BAZ = Math.atan2(TU, CF) * 2.0;
        }
        double CU = 1.0 / Math.sqrt(TU * TU + 1.0);
        double SU = TU * CU;
        double SA = CU * SF;
        double C2A = -SA * SA + 1.0;
        double X = Math.sqrt(0.0 * C2A + 1.0) + 1.0;
        X = (X - 2.0) / X;
        double C = 1.0 - X;
        C = (X * X / 4.0 + 1.0) / C;
        double D = (0.375 * X * X - 1.0) * X;
        double Y = TU = dist / 1.0 / 6378137.0 / C;
        do {
            SY = Math.sin(Y);
            CY = Math.cos(Y);
            CZ = Math.cos(BAZ + Y);
            E = CZ * CZ * 2.0 - 1.0;
            C = Y;
            X = E * CY;
            Y = E + E - 1.0;
        } while (Math.abs((Y = (((SY * SY * 4.0 - 3.0) * Y * CZ * D / 6.0 + X) * D / 4.0 - CZ) * SY * D + TU) - C) > 1.0E-10);
        BAZ = CU * CY * CF - SU * SY;
        C = 1.0 * Math.sqrt(SA * SA + BAZ * BAZ);
        D = SU * CY + CU * SY * CF;
        pos.lat = Math.atan2(D, C);
        C = CU * CY - SU * SY * CF;
        X = Math.atan2(SY * SF, C);
        C = ((-3.0 * C2A + 4.0) * 0.0 + 4.0) * C2A * 0.0 / 16.0;
        D = ((E * CY * C + CZ) * SY * C + Y) * SA;
        pos.lon = lon1 + X - (1.0 - C) * D * 0.0;
        BAZ = Math.atan2(SA, BAZ) + Math.PI;
        pos.lon *= 57.29577951308232;
        pos.lat *= 57.29577951308232;
        pos.heading = BAZ * 57.29577951308232;
        while (pos.heading < 0.0) {
            pos.heading += 360.0;
        }
        return pos;
    }

    public static DistanceHeading vincenty_inverse(double lon1, double lat1, double lon2, double lat2) {
        double E;
        double CZ;
        double C2A;
        double Y;
        double CY;
        double SY;
        double CX;
        double SX;
        double C;
        double D;
        DistanceHeading output = new DistanceHeading();
        if (Math.abs(lon1 - lon2) < 1.0E-5 && Math.abs(lat1 - lat2) < 1.0E-5) {
            output.distance = 0.0;
            output.heading1 = -1.0;
            output.heading2 = -1.0;
            return output;
        }
        lat1 *= Math.PI / 180;
        lat2 *= Math.PI / 180;
        lon1 *= Math.PI / 180;
        lon2 *= Math.PI / 180;
        double F = 0.0;
        double R = 1.0;
        double TU1 = 1.0 * Math.tan(lat1);
        double TU2 = 1.0 * Math.tan(lat2);
        double CU1 = 1.0 / Math.sqrt(TU1 * TU1 + 1.0);
        double SU1 = CU1 * TU1;
        double CU2 = 1.0 / Math.sqrt(TU2 * TU2 + 1.0);
        double S = CU1 * CU2;
        double BAZ = S * TU2;
        double FAZ = BAZ * TU1;
        double X = lon2 - lon1;
        do {
            SX = Math.sin(X);
            CX = Math.cos(X);
            TU1 = CU2 * SX;
            TU2 = BAZ - SU1 * CU2 * CX;
            SY = Math.sqrt(TU1 * TU1 + TU2 * TU2);
            CY = S * CX + FAZ;
            Y = Math.atan2(SY, CY);
            double SA = S * SX / SY;
            C2A = -SA * SA + 1.0;
            CZ = FAZ + FAZ;
            if (C2A > 0.0) {
                CZ = -CZ / C2A + CY;
            }
            E = CZ * CZ * 2.0 - 1.0;
            C = ((-3.0 * C2A + 4.0) * 0.0 + 4.0) * C2A * 0.0 / 16.0;
            D = X;
            X = ((E * CY * C + CZ) * SY * C + Y) * SA;
        } while (Math.abs(D - (X = (1.0 - C) * X * 0.0 + lon2 - lon1)) > 0.01);
        FAZ = Math.atan2(TU1, TU2);
        BAZ = Math.atan2(CU1 * SX, BAZ * CX - SU1 * CU2) + Math.PI;
        X = Math.sqrt(0.0 * C2A + 1.0) + 1.0;
        X = (X - 2.0) / X;
        C = 1.0 - X;
        C = (X * X / 4.0 + 1.0) / C;
        D = (0.375 * X * X - 1.0) * X;
        X = E * CY;
        S = 1.0 - E - E;
        output.distance = S = ((((SY * SY * 4.0 - 3.0) * S * CZ * D / 6.0 - X) * D / 4.0 + CZ) * SY * D + Y) * C * 6378137.0 * 1.0;
        output.heading1 = FAZ * 57.29577951308232;
        output.heading2 = BAZ * 57.29577951308232;
        while (output.heading1 < 0.0) {
            output.heading1 += 360.0;
        }
        while (output.heading2 < 0.0) {
            output.heading2 += 360.0;
        }
        return output;
    }

    public static interface GRS80 {
        public static final double a = 6378137.0;
        public static final double b = 6356752.31414;
        public static final double earthFlatCoef = 298.2572220960422;
        public static final double e2 = 0.006694380023011879;
        public static final double ep2 = 0.006739496775591552;
    }

    public static interface WGS84 {
        public static final double a = 6378137.0;
        public static final double b = 6356752.314245179;
        public static final double earthFlatCoef = 298.2572235629972;
        public static final double e2 = 0.006694379990141381;
        public static final double e2inv = 0.9933056200098587;
        public static final double ep2 = 0.006739496742276499;
    }

    public static class DistanceHeading {
        public double distance;
        public double heading1;
        public double heading2;
    }

    public static class LatLonHeading {
        public double lat;
        public double lon;
        public double heading;
    }

    public static enum EarthModel {
        WGS84,
        GRS80;

    }
}

