/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.db;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.VirtualDir;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.util.ProductUtils;
import org.esa.snap.db.ProductEntry;
import org.esa.snap.util.ResourceUtils;
import org.esa.snap.util.ZipUtils;

public class QuickLookGenerator {
    private static final String QUICKLOOK_PREFIX = "QL_";
    private static final String QUICKLOOK_EXT = ".jpg";
    private static final int MAX_WIDTH = 400;
    private static final File dbStorageDir = new File(ResourceUtils.getApplicationUserDir(true), "productDB" + File.separator + "QuickLooks");

    public static boolean quickLookExists(ProductEntry entry) {
        File quickLookFile = QuickLookGenerator.getQuickLookFile(dbStorageDir, entry.getId());
        return quickLookFile.exists() && quickLookFile.length() > 0L;
    }

    public static BufferedImage loadQuickLook(ProductEntry entry) {
        File quickLookFile = QuickLookGenerator.getQuickLookFile(dbStorageDir, entry.getId());
        BufferedImage bufferedImage = null;
        if (quickLookFile.exists() && quickLookFile.length() > 0L) {
            bufferedImage = QuickLookGenerator.loadFile(quickLookFile);
        }
        return bufferedImage;
    }

    public static void deleteQuickLook(int id) {
        File quickLookFile = QuickLookGenerator.getQuickLookFile(dbStorageDir, id);
        if (quickLookFile.exists()) {
            quickLookFile.delete();
        }
    }

    private static File getQuickLookFile(File storageDir, int id) {
        return new File(storageDir, QUICKLOOK_PREFIX + id + QUICKLOOK_EXT);
    }

    private static BufferedImage loadFile(File file) {
        BufferedImage bufferedImage = null;
        if (file.canRead()) {
            try (BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));){
                bufferedImage = ImageIO.read(fis);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bufferedImage;
    }

    private static BufferedImage createQuickLookImage(Product product, boolean preprocess) throws IOException {
        String quicklookBandName;
        String srcBandName = quicklookBandName = ProductUtils.findSuitableQuicklookBandName((Product)product);
        Product productSubset = product;
        if (preprocess) {
            ProductSubsetDef productSubsetDef = new ProductSubsetDef("subset");
            int scaleFactor = Math.max(product.getSceneRasterWidth(), product.getSceneRasterHeight()) / 400;
            if (scaleFactor < 1) {
                scaleFactor = 1;
            }
            productSubsetDef.setSubSampling(scaleFactor, scaleFactor);
            Band srcBand = product.getBand(quicklookBandName);
            if (!(srcBand instanceof VirtualBand)) {
                productSubsetDef.setNodeNames(new String[]{quicklookBandName});
            }
            productSubset = product.createSubset(productSubsetDef, null, null);
        }
        BufferedImage image = ProductUtils.createColorIndexedImage((RasterDataNode)productSubset.getBand(srcBandName), (ProgressMonitor)ProgressMonitor.NULL);
        productSubset.dispose();
        return image;
    }

    private static BufferedImage average(BufferedImage image) {
        int rangeFactor = 4;
        int azimuthFactor = 4;
        int rangeAzimuth = 16;
        Raster raster = image.getData();
        int w = image.getWidth() / 4;
        int h = image.getHeight() / 4;
        int index = 0;
        byte[] data = new byte[w * h];
        for (int ty = 0; ty < h; ++ty) {
            int yStart = ty * 4;
            int yEnd = yStart + 4;
            for (int tx = 0; tx < w; ++tx) {
                int xStart = tx * 4;
                int xEnd = xStart + 4;
                double meanValue = 0.0;
                for (int y = yStart; y < yEnd; ++y) {
                    for (int x = xStart; x < xEnd; ++x) {
                        meanValue += (double)raster.getSample(x, y, 0);
                    }
                }
                data[index++] = (byte)(meanValue /= 16.0);
            }
        }
        return QuickLookGenerator.createRenderedImage(data, w, h);
    }

    private static BufferedImage createRenderedImage(byte[] array, int w, int h) {
        SampleModel sm = RasterFactory.createBandedSampleModel((int)0, (int)w, (int)h, (int)1);
        ColorModel cm = PlanarImage.createColorModel((SampleModel)sm);
        DataBufferByte dataBuffer = new DataBufferByte(array, array.length);
        WritableRaster writeraster = RasterFactory.createWritableRaster((SampleModel)sm, (DataBuffer)dataBuffer, (Point)new Point(0, 0));
        return new BufferedImage(cm, writeraster, cm.isAlphaPremultiplied(), null);
    }

    private static File findProductBrowseImage(File productFile) {
        if (ZipUtils.isZip(productFile)) {
            try {
                if (ZipUtils.findInZip(productFile, "s1", "quick-look.png")) {
                    VirtualDir zipDir = VirtualDir.create((File)productFile);
                    String rootFolder = ZipUtils.getRootFolder(productFile, "manifest.safe");
                    return zipDir.getFile(rootFolder + "preview/quick-look.png");
                }
                if (ZipUtils.findInZip(productFile, "rs2", "browseimage.tif")) {
                    VirtualDir zipDir = VirtualDir.create((File)productFile);
                    String rootFolder = ZipUtils.getRootFolder(productFile, "product.xml");
                    return zipDir.getFile(rootFolder + "BrowseImage.tif");
                }
            }
            catch (Exception e) {
                return null;
            }
            return null;
        }
        File parentFolder = productFile.getParentFile();
        File browseFile = new File(parentFolder, "preview" + File.separator + "quick-look.png");
        if (browseFile.exists()) {
            return browseFile;
        }
        browseFile = new File(parentFolder, "PREVIEW" + File.separator + "BROWSE.tif");
        if (browseFile.exists()) {
            return browseFile;
        }
        browseFile = new File(parentFolder, "BrowseImage.tif");
        if (browseFile.exists()) {
            return browseFile;
        }
        return null;
    }

    public static boolean createQuickLook(int id, File productFile) throws IOException {
        boolean preprocess = false;
        File browseFile = QuickLookGenerator.findProductBrowseImage(productFile);
        if (browseFile == null) {
            browseFile = productFile;
            preprocess = true;
        }
        boolean isCorrupt = false;
        Product sourceProduct = ProductIO.readProduct((File)browseFile);
        if (sourceProduct != null) {
            QuickLookGenerator.createQuickLook(id, sourceProduct, preprocess);
            sourceProduct.dispose();
        }
        return isCorrupt;
    }

    public static void createQuickLook(int id, Product product, boolean preprocess) {
        File quickLookFile = QuickLookGenerator.getQuickLookFile(dbStorageDir, id);
        try {
            if (!dbStorageDir.exists()) {
                dbStorageDir.mkdirs();
            }
            quickLookFile.createNewFile();
            BufferedImage bufferedImage = QuickLookGenerator.createQuickLookImage(product, true);
            ImageIO.write((RenderedImage)QuickLookGenerator.average(bufferedImage), "JPG", quickLookFile);
        }
        catch (Exception e) {
            System.out.println("Quicklook create data failed :" + product.getFileLocation() + "\n" + e.getMessage());
            quickLookFile.delete();
        }
    }
}

