/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.db;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.util.ProductUtils;
import org.esa.snap.datamodel.AbstractMetadata;
import org.esa.snap.db.ProductDB;
import org.esa.snap.db.QuickLookGenerator;

public class ProductEntry {
    public static final String FILE_SIZE = "file_size";
    public static final String LAST_MODIFIED = "last_modified";
    public static final String FILE_FORMAT = "file_format";
    public static final String GEO_BOUNDARY = "geo_boundary";
    public static final DateFormat yyyMMdd_Format = ProductData.UTC.createDateFormat((String)"yyy-MM-dd");
    private int id;
    private File file;
    private long fileSize;
    private String name;
    private String mission;
    private String productType;
    private String acquisitionMode;
    private ProductData.UTC firstLineTime;
    private String pass;
    private double range_spacing;
    private double azimuth_spacing;
    private long lastModified;
    private String fileFormat;
    private MetadataElement absRoot = null;
    private final GeoPos firstNear = new GeoPos();
    private final GeoPos firstFar = new GeoPos();
    private final GeoPos lastNear = new GeoPos();
    private final GeoPos lastFar = new GeoPos();
    private GeoPos[] geoboundary;
    private BufferedImage quickLookImage = null;

    public ProductEntry(int id, File file) {
        this.id = id;
        this.file = file;
    }

    public ProductEntry(Product product) {
        this.file = product.getFileLocation();
        if (this.file != null) {
            this.lastModified = this.file.lastModified();
        }
        this.fileSize = product.getRawStorageSize();
        this.fileFormat = product.getProductReader().getReaderPlugIn().getFormatNames()[0];
        this.absRoot = AbstractMetadata.getAbstractedMetadata(product).createDeepClone();
        if (this.absRoot != null) {
            this.name = this.absRoot.getAttributeString("PRODUCT");
            this.mission = this.absRoot.getAttributeString("MISSION");
            this.productType = this.absRoot.getAttributeString("PRODUCT_TYPE");
            this.acquisitionMode = this.absRoot.getAttributeString("ACQUISITION_MODE");
            this.pass = this.absRoot.getAttributeString("PASS");
            this.range_spacing = this.absRoot.getAttributeDouble("range_spacing");
            this.azimuth_spacing = this.absRoot.getAttributeDouble("azimuth_spacing");
            this.firstLineTime = this.absRoot.getAttributeUTC("first_line_time");
        }
        if (this.name.isEmpty() || this.name.equals(" ")) {
            this.name = product.getName();
        }
        if (this.productType.isEmpty() || this.productType.equals(" ")) {
            this.productType = product.getProductType();
        }
        if (this.firstLineTime.equals((Object)AbstractMetadata.NO_METADATA_UTC)) {
            this.firstLineTime = product.getStartTime();
        }
        this.getCornerPoints(product);
        this.geoboundary = this.mission.equals("SMOS") ? ProductEntry.getSMOSGeoBoundary(product) : ProductEntry.getGeoBoundary(product);
        this.id = -1;
    }

    public ProductEntry(ResultSet results) throws SQLException {
        this.id = results.getInt(1);
        this.file = new File(results.getString("PATH"));
        this.name = results.getString("PRODUCT");
        this.mission = results.getString("MISSION");
        this.productType = results.getString("PRODUCT_TYPE");
        this.acquisitionMode = results.getString("ACQUISITION_MODE");
        this.pass = results.getString("PASS");
        this.range_spacing = results.getDouble("range_spacing");
        this.azimuth_spacing = results.getDouble("azimuth_spacing");
        Date date = results.getDate("first_line_time");
        this.firstLineTime = AbstractMetadata.parseUTC(date.toString(), yyyMMdd_Format);
        this.fileSize = (long)results.getDouble(FILE_SIZE);
        this.lastModified = (long)results.getDouble(LAST_MODIFIED);
        this.fileFormat = results.getString(FILE_FORMAT);
        this.firstNear.setLocation((float)results.getDouble("first_near_lat"), (float)results.getDouble("first_near_long"));
        this.firstFar.setLocation((float)results.getDouble("first_far_lat"), (float)results.getDouble("first_far_long"));
        this.lastNear.setLocation((float)results.getDouble("last_near_lat"), (float)results.getDouble("last_near_long"));
        this.lastFar.setLocation((float)results.getDouble("last_far_lat"), (float)results.getDouble("last_far_long"));
        this.geoboundary = ProductEntry.parseGeoBoundaryStr(results.getString(GEO_BOUNDARY));
    }

    public void dispose() {
        if (this.absRoot != null) {
            this.absRoot.dispose();
        }
    }

    public static void dispose(ProductEntry[] productEntryList) {
        for (ProductEntry e : productEntryList) {
            e.dispose();
        }
    }

    private void getCornerPoints(Product product) {
        GeoCoding geoCoding = product.getGeoCoding();
        if (geoCoding == null) {
            return;
        }
        if (!geoCoding.canGetGeoPos()) {
            return;
        }
        int w = product.getSceneRasterWidth();
        int h = product.getSceneRasterHeight();
        geoCoding.getGeoPos(new PixelPos(0.0f, 0.0f), this.firstNear);
        geoCoding.getGeoPos(new PixelPos((float)w, 0.0f), this.firstFar);
        geoCoding.getGeoPos(new PixelPos(0.0f, (float)h), this.lastNear);
        geoCoding.getGeoPos(new PixelPos((float)w, (float)h), this.lastFar);
    }

    private static GeoPos[] getSMOSGeoBoundary(Product product) {
        GeoCoding gc = product.getGeoCoding();
        if (gc == null) {
            return new GeoPos[0];
        }
        Band band = product.getBand("Latitude");
        if (band == null) {
            band = product.getBandAt(0);
        }
        int width = band.getRasterWidth();
        int height = band.getRasterHeight();
        float[] line = new float[width];
        double nodata = band.getNoDataValue();
        PixelPos pix = new PixelPos();
        int stepX = 20;
        int stepY = 300;
        int min = 1500;
        int max = Math.min(height, 6000);
        int size = 2 * (max - 1500) / 300;
        ArrayList<Object> geoPoints = new ArrayList<Object>(size);
        ArrayList<GeoPos> geoPoints2 = new ArrayList<GeoPos>(size);
        try {
            for (int y = 1500; y < max; y += 300) {
                band.readPixels(0, y, width, 1, line, ProgressMonitor.NULL);
                int x1 = 20;
                int x2 = width - 20;
                boolean haveX1 = false;
                boolean haveX2 = false;
                while (!(x1 >= width || x2 <= 0 || haveX1 && haveX2)) {
                    if (!haveX1) {
                        if ((double)line[x1] != nodata) {
                            haveX1 = true;
                        }
                        x1 += 20;
                    }
                    if (haveX2) continue;
                    if ((double)line[x2] != nodata) {
                        haveX2 = true;
                    }
                    x2 -= 20;
                }
                if (!haveX1 || !haveX2 || x2 - x1 <= 200) continue;
                pix.setLocation((float)x1, (float)y);
                geoPoints.add(gc.getGeoPos(pix, null));
                pix.setLocation((float)x2, (float)y);
                geoPoints2.add(gc.getGeoPos(pix, null));
            }
            for (int i = geoPoints2.size() - 1; i >= 0; --i) {
                geoPoints.add(geoPoints2.get(i));
            }
        }
        catch (Exception e) {
            System.out.println("Error reading SMOS " + e.getMessage());
        }
        return geoPoints.toArray(new GeoPos[geoPoints.size()]);
    }

    private static GeoPos[] getGeoBoundary(Product product) {
        GeoCoding gc = product.getGeoCoding();
        if (gc == null) {
            return new GeoPos[0];
        }
        int step = Math.max(30, (product.getSceneRasterWidth() + product.getSceneRasterHeight()) / 20);
        GeoPos[] geoPoints = ProductUtils.createGeoBoundary((Product)product, null, (int)step, (boolean)true);
        ProductUtils.normalizeGeoPolygon((GeoPos[])geoPoints);
        return geoPoints;
    }

    public String formatGeoBoundayString() {
        StringBuilder str = new StringBuilder(this.geoboundary.length * 20);
        if (this.geoboundary.length > 50) {
            DecimalFormat df = new DecimalFormat("0.000");
            for (GeoPos geo : this.geoboundary) {
                str.append(df.format(geo.getLat()));
                str.append(',');
                str.append(df.format(geo.getLon()));
                str.append(',');
            }
        } else {
            for (GeoPos geo : this.geoboundary) {
                str.append(geo.getLat());
                str.append(',');
                str.append(geo.getLon());
                str.append(',');
            }
        }
        return str.toString();
    }

    private static GeoPos[] parseGeoBoundaryStr(String str) {
        ArrayList<GeoPos> geoPos = new ArrayList<GeoPos>(100);
        if (str != null && !str.isEmpty()) {
            StringTokenizer st = new StringTokenizer(str, ",");
            while (st.hasMoreTokens()) {
                geoPos.add(new GeoPos(Float.parseFloat(st.nextToken()), Float.parseFloat(st.nextToken())));
            }
        }
        return geoPos.toArray(new GeoPos[geoPos.size()]);
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return this.name;
    }

    public String getMission() {
        return this.mission;
    }

    public String getProductType() {
        return this.productType;
    }

    public String getAcquisitionMode() {
        return this.acquisitionMode;
    }

    public String getPass() {
        return this.pass;
    }

    public double getRangeSpacing() {
        return this.range_spacing;
    }

    public double getAzimuthSpacing() {
        return this.azimuth_spacing;
    }

    public GeoPos getFirstNearGeoPos() {
        return this.firstNear;
    }

    public GeoPos getFirstFarGeoPos() {
        return this.firstFar;
    }

    public GeoPos getLastNearGeoPos() {
        return this.lastNear;
    }

    public GeoPos getLastFarGeoPos() {
        return this.lastFar;
    }

    public GeoPos[] getGeoBoundary() {
        if (this.geoboundary == null || this.geoboundary.length == 0) {
            return this.getBox();
        }
        return this.geoboundary;
    }

    public ProductData.UTC getFirstLineTime() {
        return this.firstLineTime;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public MetadataElement getMetadata() {
        if (this.absRoot == null) {
            try {
                this.absRoot = ProductDB.instance().getProductMetadata(this.id);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        return this.absRoot;
    }

    public boolean quickLookExists() {
        return QuickLookGenerator.quickLookExists(this);
    }

    public BufferedImage getQuickLook() {
        if (this.quickLookImage == null) {
            this.quickLookImage = QuickLookGenerator.loadQuickLook(this);
        }
        return this.quickLookImage;
    }

    public void setQuickLook(BufferedImage img) {
        this.quickLookImage = img;
    }

    public boolean equals(Object other) {
        boolean bEqual = false;
        if (this == other) {
            bEqual = true;
        } else if (other instanceof ProductEntry) {
            ProductEntry entry = (ProductEntry)other;
            if (this.file == null ? entry.file == null : this.file.equals(entry.file)) {
                bEqual = true;
            }
        }
        return bEqual;
    }

    public static File[] getFileList(ProductEntry[] productEntryList) {
        File[] fileList = new File[productEntryList.length];
        int i = 0;
        for (ProductEntry entry : productEntryList) {
            fileList[i++] = entry.getFile();
        }
        return fileList;
    }

    public GeoPos[] getBox() {
        if (this.mission.equals("SMOS") && this.geoboundary != null && this.geoboundary.length != 0) {
            return this.geoboundary;
        }
        GeoPos[] geoBound = new GeoPos[]{this.getFirstNearGeoPos(), this.getFirstFarGeoPos(), this.getLastFarGeoPos(), this.getLastNearGeoPos()};
        return geoBound;
    }

    public static ProductEntry[] createProductEntryList(File[] fileList) {
        ArrayList<ProductEntry> entryList = new ArrayList<ProductEntry>(fileList.length);
        for (File file : fileList) {
            try {
                Product prod = ProductIO.readProduct((File)file);
                entryList.add(new ProductEntry(prod));
                prod.dispose();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return entryList.toArray(new ProductEntry[entryList.size()]);
    }

    public static ProductEntry[] createProductEntryList(Product[] productList) {
        ArrayList<ProductEntry> entryList = new ArrayList<ProductEntry>(productList.length);
        for (Product prod : productList) {
            entryList.add(new ProductEntry(prod));
        }
        return entryList.toArray(new ProductEntry[entryList.size()]);
    }
}

