/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.db;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.io.FileDeleteStrategy;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.snap.db.DAO;
import org.esa.snap.db.DBQuery;
import org.esa.snap.db.MetadataTable;
import org.esa.snap.db.ProductEntry;
import org.esa.snap.db.ProductTable;
import org.esa.snap.db.QuickLookGenerator;

public class ProductDB
extends DAO {
    private ProductTable productTable;
    private MetadataTable metadataTable;
    private Connection dbConnection = null;
    private static ProductDB _instance = null;
    public static final String DEFAULT_PRODUCT_DATABASE_NAME = "productDB";
    private static final String strGetProductsWhere = "SELECT * FROM APP.PRODUCTS, APP.METADATA WHERE APP.PRODUCTS.ID = APP.METADATA.ID AND ";

    public static ProductDB instance() throws Exception {
        if (_instance == null) {
            _instance = new ProductDB();
            ProductDB.initializeInstance();
        }
        return _instance;
    }

    public static ProductDB testInstance(File dbPropertiesFile) throws Exception {
        if (_instance == null) {
            _instance = new ProductDB(dbPropertiesFile);
            ProductDB.initializeInstance();
        }
        return _instance;
    }

    private static void initializeInstance() throws Exception {
        boolean connected = _instance.connect();
        if (!connected) {
            String dbLocation = _instance.getDatabaseLocation();
            ProductDB.deleteInstance();
            File dbFolder = new File(dbLocation);
            File qlFolder = new File(dbFolder.getParentFile(), "QuickLooks");
            boolean deleted = FileDeleteStrategy.FORCE.deleteQuietly(dbFolder);
            deleted = FileDeleteStrategy.FORCE.deleteQuietly(qlFolder);
            _instance = new ProductDB();
            connected = _instance.connect();
            if (!connected) {
                throw new Exception("Unable to connect to database\n" + _instance.getLastSQLException().getMessage());
            }
        }
    }

    public static void deleteInstance() {
        _instance.disconnect();
        _instance = null;
    }

    private ProductDB() throws IOException {
        super(DEFAULT_PRODUCT_DATABASE_NAME);
    }

    private ProductDB(File dbPropertiesFile) throws IOException {
        super(DEFAULT_PRODUCT_DATABASE_NAME, dbPropertiesFile);
    }

    public boolean isReady() {
        return this.productTable != null;
    }

    @Override
    protected boolean createTables(Connection connection) throws SQLException {
        this.dbConnection = connection;
        this.productTable = new ProductTable(this.dbConnection);
        this.productTable.createTable();
        this.metadataTable = new MetadataTable(this.dbConnection);
        this.metadataTable.createTable();
        return true;
    }

    @Override
    protected void validateTables(Connection connection) throws SQLException {
        this.dbConnection = connection;
        if (this.productTable == null) {
            this.productTable = new ProductTable(this.dbConnection);
        }
        if (this.metadataTable == null) {
            this.metadataTable = new MetadataTable(this.dbConnection);
        }
        this.productTable.validateTable();
        this.metadataTable.validateTable();
    }

    @Override
    protected void prepareStatements() throws SQLException {
        this.productTable.prepareStatements();
        this.metadataTable.prepareStatements();
    }

    public boolean pathExistsInDB(File path) throws SQLException {
        return this.productTable.pathExists(path);
    }

    public ProductEntry getProductEntry(File path) throws SQLException {
        return this.productTable.getProductEntry(path);
    }

    public ProductEntry[] getProductEntryInPath(File baseDir) throws SQLException {
        String queryStr = "PATH LIKE '" + baseDir.getAbsolutePath() + "%'";
        return this.queryProduct(queryStr);
    }

    public MetadataElement getProductMetadata(int id) throws SQLException {
        return this.metadataTable.getProductMetadata(id);
    }

    public ProductEntry saveProduct(Product product) throws SQLException {
        ProductEntry newEntry = new ProductEntry(product);
        if (!this.productTable.pathExists(newEntry.getFile())) {
            this.addRecord(newEntry);
        }
        return newEntry;
    }

    private void addRecord(ProductEntry record) throws SQLException {
        ResultSet results = this.productTable.addRecord(record);
        if (results.next()) {
            int id = results.getInt(1);
            record.setId(id);
            this.metadataTable.addRecord(record);
        }
    }

    public void cleanUpRemovedProducts() throws SQLException {
        ProductEntry[] entries;
        DBQuery dbQuery = new DBQuery();
        for (ProductEntry entry : entries = dbQuery.queryDatabase(this)) {
            if (entry.getFile().exists()) continue;
            this.deleteProductEntry(entry);
        }
    }

    public void deleteProductEntry(ProductEntry entry) throws SQLException {
        this.deleteRecord(entry.getId());
    }

    private void deleteRecord(int id) throws SQLException {
        this.productTable.deleteRecord(id);
        this.metadataTable.deleteRecord(id);
        QuickLookGenerator.deleteQuickLook(id);
    }

    public void removeProducts(File baseDir) throws SQLException {
        ProductEntry[] list;
        String queryStr = "PATH LIKE '" + baseDir.getAbsolutePath() + "%'";
        for (ProductEntry entry : list = this.queryProduct(queryStr)) {
            this.deleteProductEntry(entry);
        }
    }

    public void removeAllProducts() throws SQLException {
        ProductEntry[] list;
        String queryStr = "";
        for (ProductEntry entry : list = this.queryProduct("")) {
            this.deleteProductEntry(entry);
        }
    }

    public ProductEntry[] getProductEntryList(boolean validate) throws SQLException {
        if (!validate) {
            return this.productTable.getProductEntryList();
        }
        ProductEntry[] entries = this.productTable.getProductEntryList();
        ArrayList<ProductEntry> list = new ArrayList<ProductEntry>(entries.length);
        for (ProductEntry entry : entries) {
            if (entry.getFile().exists()) {
                list.add(entry);
                continue;
            }
            this.deleteRecord(entry.getId());
        }
        return list.toArray(new ProductEntry[list.size()]);
    }

    public ProductEntry[] queryProduct(String queryStr) throws SQLException {
        ArrayList<ProductEntry> listEntries = new ArrayList<ProductEntry>();
        Statement queryStatement = this.dbConnection.createStatement();
        String whereStr = strGetProductsWhere;
        if (queryStr.isEmpty()) {
            whereStr = strGetProductsWhere.substring(0, strGetProductsWhere.lastIndexOf(" AND "));
        }
        ResultSet results = queryStatement.executeQuery(whereStr + queryStr);
        while (results.next()) {
            listEntries.add(new ProductEntry(results));
        }
        return listEntries.toArray(new ProductEntry[listEntries.size()]);
    }

    public String[] getAllMissions() throws SQLException {
        if (this.productTable == null) {
            return new String[0];
        }
        return this.productTable.getAllMissions();
    }

    public String[] getAllProductTypes() throws SQLException {
        return this.productTable.getAllProductTypes();
    }

    public String[] getProductTypes(String[] missions) throws SQLException {
        return this.productTable.getProductTypes(missions);
    }

    public String[] getAllAcquisitionModes() throws SQLException {
        return this.productTable.getAllAcquisitionModes();
    }

    public String[] getAcquisitionModes(String[] missions) throws SQLException {
        return this.productTable.getAcquisitionModes(missions);
    }

    public String[] getMetadataNames() {
        ProductDB productDB = this;
        return productDB.metadataTable.getAllMetadataNames();
    }
}

