/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.db;

import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.snap.db.DBQuery;
import org.esa.snap.db.ProductDB;
import org.esa.snap.db.ProductEntry;

public class DBSearch {
    public static ProductEntry[] search(File srcFile) throws Exception {
        return DBSearch.search(ProductIO.readProduct((File)srcFile));
    }

    public static ProductEntry[] search(Product srcProduct) throws Exception {
        GeoPos centerGeoPos = srcProduct.getGeoCoding().getGeoPos(new PixelPos((float)(srcProduct.getSceneRasterWidth() / 2), (float)(srcProduct.getSceneRasterHeight() / 2)), null);
        ProductEntry masterEntry = new ProductEntry(srcProduct);
        return DBSearch.findCCDPairs(ProductDB.instance(), masterEntry, centerGeoPos, 1, false);
    }

    private static ProductEntry[] findCCDPairs(ProductDB db, ProductEntry master, GeoPos centerGeoPos, int maxSlaves, boolean anyDate) throws SQLException {
        DBQuery dbQuery = new DBQuery();
        dbQuery.setFreeQuery("PRODUCT <> '" + master.getName() + '\'');
        dbQuery.setSelectionRect(new GeoPos[]{centerGeoPos, centerGeoPos, centerGeoPos, centerGeoPos});
        dbQuery.setReturnAllIfNoIntersection(false);
        dbQuery.setSelectedPass(master.getPass());
        dbQuery.setStartEndDate(null, master.getFirstLineTime().getAsCalendar());
        dbQuery.setSelectedProductTypes(new String[]{master.getProductType()});
        ProductEntry[] entries = dbQuery.queryDatabase(db);
        if (entries.length == 0) {
            return entries;
        }
        return DBSearch.getClosestDatePairs(entries, master, dbQuery, maxSlaves, anyDate);
    }

    private static ProductEntry[] getClosestDatePairs(ProductEntry[] entries, ProductEntry master, DBQuery dbQuery, int maxSlaves, boolean anyDate) {
        double endTime;
        double masterTime;
        double cutoffTime = masterTime = master.getFirstLineTime().getMJD();
        if (dbQuery != null && dbQuery.getEndDate() != null && (endTime = ProductData.UTC.create((Date)dbQuery.getEndDate().getTime(), (long)0L).getMJD()) > masterTime) {
            cutoffTime = endTime;
        }
        ArrayList resultList = new ArrayList(maxSlaves);
        HashMap<Double, ProductEntry> timesMap = new HashMap<Double, ProductEntry>();
        ArrayList<Double> diffList = new ArrayList<Double>();
        for (ProductEntry entry : entries) {
            double diff;
            double entryTime = entry.getFirstLineTime().getMJD();
            if (!anyDate && !(entryTime < cutoffTime) || !((diff = masterTime - entryTime) > 0.0) || !(diff > 1.0)) continue;
            timesMap.put(diff, entry);
            diffList.add(diff);
        }
        Collections.sort(diffList);
        for (Double diff : diffList) {
            resultList.add(timesMap.get(diff));
            if (resultList.size() < maxSlaves) continue;
            break;
        }
        return resultList.toArray(new ProductEntry[resultList.size()]);
    }
}

