/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.db;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.SwingWorker;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.datamodel.Product;
import org.esa.snap.db.ProductDB;
import org.esa.snap.db.ProductEntry;
import org.esa.snap.db.QuickLookGenerator;
import org.esa.snap.gpf.ThreadManager;
import org.esa.snap.util.ProductFunctions;

public final class DBScanner
extends SwingWorker {
    private final ProductDB db;
    private final File baseDir;
    private final boolean doRecursive;
    private final boolean generateQuicklooks;
    private final ProgressMonitor pm;
    private final List<DBScannerListener> listenerList = new ArrayList<DBScannerListener>(1);
    private final List<ErrorFile> errorList = new ArrayList<ErrorFile>();

    public DBScanner(ProductDB database, File baseDir, boolean doRecursive, boolean doQuicklooks, ProgressMonitor pm) {
        this.db = database;
        this.pm = pm;
        this.baseDir = baseDir;
        this.doRecursive = doRecursive;
        this.generateQuicklooks = doQuicklooks;
    }

    public void addListener(DBScannerListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public void removeListener(DBScannerListener listener) {
        this.listenerList.remove(listener);
    }

    private void notifyMSG(DBScannerListener.MSG msg) {
        for (DBScannerListener listener : this.listenerList) {
            listener.notifyMSG(this, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean doInBackground() throws Exception {
        this.errorList.clear();
        ArrayList<File> dirList = new ArrayList<File>(20);
        dirList.add(this.baseDir);
        if (this.doRecursive) {
            File[] subDirs = DBScanner.collectAllSubDirs(this.baseDir);
            dirList.addAll(Arrays.asList(subDirs));
        }
        ProductFunctions.ValidProductFileFilter fileFilter = new ProductFunctions.ValidProductFileFilter(false);
        ArrayList<File> fileList = new ArrayList<File>(dirList.size());
        for (File file : dirList) {
            fileList.addAll(Arrays.asList(file.listFiles(fileFilter)));
        }
        ArrayList<File> qlProductFiles = new ArrayList<File>(fileList.size());
        ArrayList<Integer> qlIDs = new ArrayList<Integer>(fileList.size());
        ProductEntry[] entriesInPath = this.db.getProductEntryInPath(this.baseDir);
        ConcurrentHashMap<File, ProductEntry> fileMap = new ConcurrentHashMap<File, ProductEntry>(entriesInPath.length);
        for (ProductEntry entry : entriesInPath) {
            fileMap.put(entry.getFile(), entry);
        }
        int total = fileList.size();
        this.pm.beginTask("Scanning Files...", total);
        int i = 0;
        int prodCount = 0;
        try {
            for (File file : fileList) {
                String taskMsg = "Scanning " + ++i + " of " + total + " files ";
                if (prodCount > 0) {
                    taskMsg = taskMsg + "(" + prodCount + " new products)";
                }
                this.pm.setTaskName(taskMsg);
                this.pm.worked(1);
                ProductEntry existingEntry = (ProductEntry)fileMap.get(file);
                if (existingEntry != null) {
                    if (this.generateQuicklooks && !existingEntry.quickLookExists()) {
                        qlProductFiles.add(file);
                        qlIDs.add(existingEntry.getId());
                    }
                    existingEntry.dispose();
                    continue;
                }
                if (this.pm.isCanceled()) break;
                try {
                    Product sourceProduct = ProductIO.readProduct((File)file);
                    if (sourceProduct != null) {
                        ProductEntry entry = this.db.saveProduct(sourceProduct);
                        ++prodCount;
                        if (!entry.quickLookExists()) {
                            qlProductFiles.add(file);
                            qlIDs.add(entry.getId());
                        }
                        sourceProduct.dispose();
                        entry.dispose();
                        continue;
                    }
                    if (file.isDirectory()) continue;
                    System.out.println("No reader for " + file.getAbsolutePath());
                }
                catch (Throwable e) {
                    this.errorList.add(new ErrorFile(file, "Product unreadable"));
                    System.out.println("Unable to read " + file.getAbsolutePath() + '\n' + e.getMessage());
                }
            }
            this.db.cleanUpRemovedProducts();
            this.notifyMSG(DBScannerListener.MSG.FOLDERS_SCANNED);
            if (this.generateQuicklooks) {
                int numQL = qlProductFiles.size();
                this.pm.beginTask("Generating Quicklooks...", numQL);
                ThreadManager threadManager = new ThreadManager();
                for (int j = 0; j < numQL; ++j) {
                    this.pm.setTaskName("Generating Quicklook... " + (j + 1) + " of " + numQL);
                    this.pm.worked(1);
                    if (this.pm.isCanceled()) break;
                    final File file = (File)qlProductFiles.get(j);
                    final int qlID = (Integer)qlIDs.get(j);
                    Thread worker = new Thread(){

                        @Override
                        public void run() {
                            try {
                                boolean isCorrupt = QuickLookGenerator.createQuickLook(qlID, file);
                                if (isCorrupt) {
                                    DBScanner.this.errorList.add(new ErrorFile(file, "Corrupt Image"));
                                }
                            }
                            catch (Throwable e) {
                                System.out.println("QL Unable to read " + file.getAbsolutePath() + '\n' + e.getMessage());
                            }
                        }
                    };
                    threadManager.add(worker);
                    this.notifyMSG(DBScannerListener.MSG.QUICK_LOOK_GENERATED);
                }
                threadManager.finish();
            }
            this.pm.setTaskName("");
        }
        catch (Throwable e) {
            System.out.println("Scanning Exception\n" + e.getMessage());
        }
        finally {
            this.pm.done();
        }
        return true;
    }

    @Override
    public void done() {
        this.notifyMSG(DBScannerListener.MSG.DONE);
    }

    private static File[] collectAllSubDirs(File dir) {
        File[] subDirs;
        ArrayList<File> dirList = new ArrayList<File>(20);
        ProductFunctions.DirectoryFileFilter dirFilter = new ProductFunctions.DirectoryFileFilter();
        for (File subDir : subDirs = dir.listFiles(dirFilter)) {
            dirList.add(subDir);
            File[] dirs = DBScanner.collectAllSubDirs(subDir);
            dirList.addAll(Arrays.asList(dirs));
        }
        return dirList.toArray(new File[dirList.size()]);
    }

    public List<ErrorFile> getErrorList() {
        return this.errorList;
    }

    public static interface DBScannerListener {
        public void notifyMSG(DBScanner var1, MSG var2);

        public static enum MSG {
            DONE,
            FOLDERS_SCANNED,
            QUICK_LOOK_GENERATED;

        }
    }

    public static class ErrorFile {
        public final File file;
        public final String message;
        public static final String CORRUPT = "Corrupt Image";
        public static final String UNREADABLE = "Product unreadable";

        public ErrorFile(File file, String msg) {
            this.file = file;
            this.message = msg;
        }
    }
}

