/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.db;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.util.StringUtils;
import org.esa.beam.util.logging.BeamLogManager;
import org.esa.snap.db.ProductDB;
import org.esa.snap.db.ProductEntry;
import org.esa.snap.db.SQLUtils;
import org.esa.snap.util.XMLSupport;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;

public class DBQuery {
    public static final String ALL_MISSIONS = "All_Missions";
    public static final String ALL_PRODUCT_TYPES = "All_Types";
    public static final String ALL_PASSES = "All_Passes";
    public static final String ALL_MODES = "All_Modes";
    public static final String ASCENDING_PASS = "ASCENDING";
    public static final String DESCENDING_PASS = "DESCENDING";
    public static final String ALL_FOLDERS = "All_Folders";
    public static final String ANY = "Any";
    public static final String DUALPOL = "Dual-Pol";
    public static final String QUADPOL = "Quad-Pol";
    public static final String HHVV = "HH+VV";
    public static final String HHHV = "HH+HV";
    public static final String VVVH = "VV+VH";
    public static final String CALIBRATED = "Calibrated";
    public static final String NOT_CALIBRATED = "Not_Calibrated";
    public static final String ORBIT_PRELIMINARY = "Preliminary";
    public static final String ORBIT_PRECISE = "Precise";
    public static final String ORBIT_VERIFIED = "Verified";
    public static final String DB_QUERY = "dbQuery";
    private String[] selectedMissions = new String[0];
    private String[] selectedProductTypes = new String[0];
    private String selectedAcquisitionMode = "";
    private String selectedPass = "";
    private String selectedTrack = "";
    private String selectedSampleType = "";
    private String selectedPolarization = "Any";
    private String selectedCalibration = "Any";
    private String selectedOrbitCorrection = "Any";
    private Rectangle2D.Float selectionRectangle = null;
    private File baseDir = null;
    private File excludeDir = null;
    private Calendar startDate = null;
    private Calendar endDate = null;
    private String freeQuery = "";
    private boolean returnAllIfNoIntersection = true;
    private final Map<String, String> metadataQueryMap = new HashMap<String, String>();

    public void setSelectedMissions(String[] missions) {
        this.selectedMissions = missions;
    }

    public String[] getSelectedMissions() {
        return this.selectedMissions;
    }

    public void setSelectedProductTypes(String[] productTypes) {
        this.selectedProductTypes = productTypes;
    }

    public String[] getSelectedProductTypes() {
        return this.selectedProductTypes;
    }

    public void setSelectedAcquisitionMode(String mode) {
        if (mode != null) {
            this.selectedAcquisitionMode = mode;
        }
    }

    public String getSelectedAcquisitionMode() {
        return this.selectedAcquisitionMode;
    }

    public void setSelectedPass(String pass) {
        if (pass != null) {
            this.selectedPass = pass;
        }
    }

    public String getSelectedPass() {
        return this.selectedPass;
    }

    public void setSelectedTrack(String track) {
        if (track != null) {
            this.selectedTrack = track;
        }
    }

    public String getSelectedTrack() {
        return this.selectedTrack;
    }

    public void setSelectedSampleType(String sampleType) {
        if (sampleType != null) {
            this.selectedSampleType = sampleType;
        }
    }

    public String getSelectedSampleType() {
        return this.selectedSampleType;
    }

    public void setSelectedPolarization(String pol) {
        if (pol != null) {
            this.selectedPolarization = pol;
        }
    }

    public String getSelectedPolarization() {
        return this.selectedPolarization;
    }

    public void setSelectedCalibration(String calib) {
        if (calib != null) {
            this.selectedCalibration = calib;
        }
    }

    public String getSelectedCalibration() {
        return this.selectedCalibration;
    }

    public void setSelectedOrbitCorrection(String orbitCor) {
        if (orbitCor != null) {
            this.selectedOrbitCorrection = orbitCor;
        }
    }

    public String getSelectedOrbitCorrection() {
        return this.selectedOrbitCorrection;
    }

    public void setBaseDir(File dir) {
        this.baseDir = dir;
    }

    public void setExcludeDir(File dir) {
        this.excludeDir = dir;
    }

    public void setStartEndDate(Calendar start, Calendar end) {
        this.startDate = start;
        this.endDate = end;
    }

    public Calendar getStartDate() {
        return this.startDate;
    }

    public Calendar getEndDate() {
        return this.endDate;
    }

    public void clearMetadataQuery() {
        this.metadataQueryMap.clear();
    }

    public void addMetadataQuery(String name, String value) {
        this.metadataQueryMap.put(name, value);
    }

    public void setFreeQuery(String queryStr) {
        this.freeQuery = queryStr;
    }

    public String getFreeQuery() {
        return this.freeQuery;
    }

    public void setReturnAllIfNoIntersection(boolean flag) {
        this.returnAllIfNoIntersection = flag;
    }

    public ProductEntry[] queryDatabase(ProductDB db) throws SQLException {
        if (StringUtils.contains((String[])this.selectedMissions, (String)ALL_MISSIONS)) {
            this.selectedMissions = new String[0];
        }
        if (StringUtils.contains((String[])this.selectedProductTypes, (String)ALL_PRODUCT_TYPES)) {
            this.selectedProductTypes = new String[0];
        }
        StringBuilder queryStr = new StringBuilder(1000);
        if (this.selectedMissions.length > 0) {
            queryStr.append(SQLUtils.getOrList("APP.PRODUCTS.MISSION", this.selectedMissions));
        }
        if (this.selectedProductTypes.length > 0) {
            SQLUtils.addAND(queryStr);
            queryStr.append(SQLUtils.getOrList("APP.PRODUCTS.PRODUCT_TYPE", this.selectedProductTypes));
        }
        if (!this.selectedAcquisitionMode.isEmpty() && !this.selectedAcquisitionMode.equals(ALL_MODES)) {
            SQLUtils.addAND(queryStr);
            queryStr.append("APP.PRODUCTS.ACQUISITION_MODE='" + this.selectedAcquisitionMode + '\'');
        }
        if (!this.selectedPass.isEmpty() && !this.selectedPass.equals(ALL_PASSES)) {
            SQLUtils.addAND(queryStr);
            queryStr.append("APP.PRODUCTS.PASS='" + this.selectedPass + '\'');
        }
        if (!this.selectedTrack.isEmpty()) {
            SQLUtils.addAND(queryStr);
            queryStr.append("( APP.METADATA.REL_ORBIT=" + this.selectedTrack + " )");
        }
        if (!this.selectedSampleType.isEmpty() && !this.selectedSampleType.equals(ANY)) {
            SQLUtils.addAND(queryStr);
            queryStr.append("( APP.METADATA.SAMPLE_TYPE='" + this.selectedSampleType + "' )");
        }
        if (!this.selectedPolarization.isEmpty() && !this.selectedPolarization.equals(ANY)) {
            SQLUtils.addAND(queryStr);
            switch (this.selectedPolarization) {
                case "HH+VV": {
                    queryStr.append("( APP.METADATA.mds1_tx_rx_polar!='' AND APP.METADATA.mds2_tx_rx_polar!='' AND  ( APP.METADATA.mds1_tx_rx_polar='HH' OR APP.METADATA.mds1_tx_rx_polar='VV' )  AND  ( APP.METADATA.mds2_tx_rx_polar='HH' OR APP.METADATA.mds2_tx_rx_polar='VV' ) )");
                    break;
                }
                case "HH+HV": {
                    queryStr.append("( APP.METADATA.mds1_tx_rx_polar!='' AND APP.METADATA.mds2_tx_rx_polar!='' AND  ( APP.METADATA.mds1_tx_rx_polar='HH' OR APP.METADATA.mds1_tx_rx_polar='HV' )  AND  ( APP.METADATA.mds2_tx_rx_polar='HH' OR APP.METADATA.mds2_tx_rx_polar='HV' ) )");
                    break;
                }
                case "VV+VH": {
                    queryStr.append("( APP.METADATA.mds1_tx_rx_polar!='' AND APP.METADATA.mds2_tx_rx_polar!='' AND  ( APP.METADATA.mds1_tx_rx_polar='VV' OR APP.METADATA.mds1_tx_rx_polar='VH' )  AND  ( APP.METADATA.mds2_tx_rx_polar='VV' OR APP.METADATA.mds2_tx_rx_polar='VH' ) )");
                    break;
                }
                case "Dual-Pol": {
                    queryStr.append("( APP.METADATA.mds1_tx_rx_polar!='' AND APP.METADATA.mds2_tx_rx_polar!='' AND APP.METADATA.mds3_tx_rx_polar='' AND APP.METADATA.mds4_tx_rx_polar='' )");
                    break;
                }
                case "Quad-Pol": {
                    queryStr.append("( APP.METADATA.mds1_tx_rx_polar!='' AND APP.METADATA.mds2_tx_rx_polar!='' AND APP.METADATA.mds3_tx_rx_polar!='' AND APP.METADATA.mds4_tx_rx_polar!='' )");
                    break;
                }
                default: {
                    queryStr.append("( APP.METADATA.mds1_tx_rx_polar='" + this.selectedPolarization + '\'' + " OR " + "APP.METADATA" + '.' + "mds2_tx_rx_polar" + "='" + this.selectedPolarization + '\'' + " OR " + "APP.METADATA" + '.' + "mds3_tx_rx_polar" + "='" + this.selectedPolarization + '\'' + " OR " + "APP.METADATA" + '.' + "mds4_tx_rx_polar" + "='" + this.selectedPolarization + '\'' + " )");
                }
            }
        }
        if (!this.selectedCalibration.isEmpty() && !this.selectedCalibration.equals(ANY)) {
            SQLUtils.addAND(queryStr);
            if (this.selectedCalibration.equals(CALIBRATED)) {
                queryStr.append("APP.METADATA.abs_calibration_flag=1");
            } else if (this.selectedCalibration.equals(NOT_CALIBRATED)) {
                queryStr.append("APP.METADATA.abs_calibration_flag=0");
            }
        }
        if (!this.selectedOrbitCorrection.isEmpty() && !this.selectedOrbitCorrection.equals(ANY)) {
            this.formOrbitCorrectionQuery(queryStr);
        }
        if (this.startDate != null) {
            SQLUtils.addAND(queryStr);
            Date start = SQLUtils.toSQLDate(this.startDate);
            if (this.endDate != null) {
                Date end = SQLUtils.toSQLDate(this.endDate);
                queryStr.append("( APP.PRODUCTS.first_line_time BETWEEN '" + ((java.util.Date)start).toString() + "' AND '" + ((java.util.Date)end).toString() + "' )");
            } else {
                queryStr.append("APP.PRODUCTS.first_line_time>='" + ((java.util.Date)start).toString() + '\'');
            }
        } else if (this.endDate != null) {
            SQLUtils.addAND(queryStr);
            Date end = SQLUtils.toSQLDate(this.endDate);
            queryStr.append("APP.PRODUCTS.first_line_time<='" + ((java.util.Date)end).toString() + '\'');
        }
        Set<String> metadataNames = this.metadataQueryMap.keySet();
        for (String name : metadataNames) {
            String value = this.metadataQueryMap.get(name);
            if (value == null || value.isEmpty()) continue;
            SQLUtils.addAND(queryStr);
            queryStr.append("APP.METADATA." + name + "='" + value + '\'');
        }
        if (!this.freeQuery.isEmpty()) {
            SQLUtils.addAND(queryStr);
            String metadataFreeQuery = SQLUtils.insertTableName(db.getMetadataNames(), "APP.METADATA", this.freeQuery);
            queryStr.append("( " + metadataFreeQuery + " )");
        }
        if (this.baseDir != null) {
            SQLUtils.addAND(queryStr);
            queryStr.append("APP.PRODUCTS.PATH LIKE '" + this.baseDir.getAbsolutePath() + "%'");
        }
        if (this.excludeDir != null) {
            SQLUtils.addAND(queryStr);
            queryStr.append("APP.PRODUCTS.PATH NOT LIKE '" + this.excludeDir.getAbsolutePath() + "%'");
        }
        if (queryStr.length() > 0) {
            BeamLogManager.getSystemLogger().info("Query=" + queryStr);
            return this.intersectMapSelection(db.queryProduct(queryStr.toString()), this.returnAllIfNoIntersection);
        }
        return this.intersectMapSelection(db.getProductEntryList(false), this.returnAllIfNoIntersection);
    }

    private void formOrbitCorrectionQuery(StringBuilder queryStr) {
        SQLUtils.addAND(queryStr);
        switch (this.selectedOrbitCorrection) {
            case "Verified": {
                queryStr.append("APP.METADATA.orbit_state_vector_file LIKE 'DORIS Verified%'");
                break;
            }
            case "Precise": {
                queryStr.append("( APP.METADATA.orbit_state_vector_file LIKE 'DORIS Precise%' OR APP.METADATA.orbit_state_vector_file LIKE 'DELFT Precise%' OR APP.METADATA.orbit_state_vector_file LIKE 'PRARE Precise%' )");
                break;
            }
            case "Preliminary": {
                queryStr.append("( APP.METADATA.orbit_state_vector_file NOT LIKE 'DORIS%' AND APP.METADATA.orbit_state_vector_file NOT LIKE 'DELFT%' AND APP.METADATA.orbit_state_vector_file NOT LIKE 'PRARE%' )");
            }
        }
    }

    public void setSelectionRect(GeoPos[] selectionBox) {
        this.selectionRectangle = DBQuery.getBoundingRect(selectionBox);
    }

    private ProductEntry[] intersectMapSelection(ProductEntry[] resultsList, boolean returnAllIfNoIntersection) {
        if (this.selectionRectangle == null) {
            return resultsList;
        }
        ArrayList<ProductEntry> intersectList = new ArrayList<ProductEntry>(resultsList.length);
        int mult = 100000;
        Rectangle selRect = new Rectangle((int)(this.selectionRectangle.x * 100000.0f), (int)(this.selectionRectangle.y * 100000.0f), (int)(this.selectionRectangle.width * 100000.0f), (int)(this.selectionRectangle.height * 100000.0f));
        boolean singlePointSelection = this.selectionRectangle.getWidth() == 0.0 && this.selectionRectangle.getHeight() == 0.0;
        Polygon p = new Polygon();
        for (ProductEntry entry : resultsList) {
            GeoPos[] geoBox;
            p.reset();
            for (GeoPos geo : geoBox = entry.getBox()) {
                p.addPoint((int)(geo.getLat() * 100000.0f), (int)(geo.getLon() * 100000.0f));
            }
            p.addPoint((int)(geoBox[0].getLat() * 100000.0f), (int)(geoBox[0].getLon() * 100000.0f));
            if (singlePointSelection) {
                if (!p.contains(selRect.x, selRect.y)) continue;
                intersectList.add(entry);
                continue;
            }
            if (p.contains(selRect)) {
                intersectList.add(entry);
                continue;
            }
            boolean allPoints = true;
            for (GeoPos geo : geoBox) {
                if (selRect.contains((int)(geo.getLat() * 100000.0f), (int)(geo.getLon() * 100000.0f))) continue;
                allPoints = false;
                break;
            }
            if (!allPoints) continue;
            intersectList.add(entry);
        }
        if (singlePointSelection && returnAllIfNoIntersection && intersectList.isEmpty()) {
            return resultsList;
        }
        return intersectList.toArray(new ProductEntry[intersectList.size()]);
    }

    public static Rectangle2D.Float getBoundingRect(GeoPos[] geoPositions) {
        float minX = Float.MAX_VALUE;
        float maxX = -3.4028235E38f;
        float minY = Float.MAX_VALUE;
        float maxY = -3.4028235E38f;
        for (GeoPos pos : geoPositions) {
            float x = pos.getLat();
            float y = pos.getLon();
            if (x < minX) {
                minX = x;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (!(y > maxY)) continue;
            maxY = y;
        }
        if (minX >= maxX || minY >= maxY) {
            return new Rectangle2D.Float(minX, minY, 0.0f, 0.0f);
        }
        return new Rectangle2D.Float(minX, minY, maxX - minX, maxY - minY);
    }

    public Element toXML() {
        Element elem = new Element(DB_QUERY);
        Element missionsElem = new Element("selectedMissions");
        elem.addContent((Content)missionsElem);
        for (String m : this.selectedMissions) {
            missionsElem.addContent((Content)new Element(m));
        }
        Element productTypesElem = new Element("selectedProductTypes");
        elem.addContent((Content)productTypesElem);
        for (String p : this.selectedProductTypes) {
            productTypesElem.addContent((Content)new Element(p));
        }
        if (this.selectionRectangle != null) {
            Element rectElem = new Element("selectionRectangle");
            elem.addContent((Content)rectElem);
            rectElem.setAttribute("x", String.valueOf(this.selectionRectangle.getX()));
            rectElem.setAttribute("y", String.valueOf(this.selectionRectangle.getY()));
            rectElem.setAttribute("w", String.valueOf(this.selectionRectangle.getWidth()));
            rectElem.setAttribute("h", String.valueOf(this.selectionRectangle.getHeight()));
        }
        elem.setAttribute("selectedAcquisitionMode", this.selectedAcquisitionMode);
        elem.setAttribute("selectedPass", this.selectedPass);
        if (this.baseDir != null) {
            elem.setAttribute("baseDir", this.baseDir.getAbsolutePath());
        }
        if (this.startDate != null) {
            Element startDateElem = new Element("startDate");
            elem.addContent((Content)startDateElem);
            startDateElem.setAttribute("year", String.valueOf(this.startDate.get(1)));
            startDateElem.setAttribute("month", String.valueOf(this.startDate.get(2)));
            startDateElem.setAttribute("day", String.valueOf(this.startDate.get(5)));
        }
        if (this.endDate != null) {
            Element endDateElem = new Element("endDate");
            elem.addContent((Content)endDateElem);
            endDateElem.setAttribute("year", String.valueOf(this.endDate.get(1)));
            endDateElem.setAttribute("month", String.valueOf(this.endDate.get(2)));
            endDateElem.setAttribute("day", String.valueOf(this.endDate.get(5)));
        }
        elem.setAttribute("freeQuery", this.freeQuery);
        return elem;
    }

    public void fromXML(Element dbQueryElem) {
        Element endDateElem;
        Element startDateElem;
        Element rectElem;
        Element productTypesElem;
        Element missionsElem = dbQueryElem.getChild("selectedMissions");
        if (missionsElem != null) {
            this.selectedMissions = XMLSupport.getStringList(missionsElem);
        }
        if ((productTypesElem = dbQueryElem.getChild("selectedProductTypes")) != null) {
            this.selectedProductTypes = XMLSupport.getStringList(productTypesElem);
        }
        if ((rectElem = dbQueryElem.getChild("selectionRectangle")) != null) {
            Attribute x = rectElem.getAttribute("x");
            Attribute y = rectElem.getAttribute("y");
            Attribute w = rectElem.getAttribute("w");
            Attribute h = rectElem.getAttribute("h");
            if (x != null && y != null && w != null && h != null) {
                this.selectionRectangle = new Rectangle2D.Float(Float.parseFloat(x.getValue()), Float.parseFloat(y.getValue()), Float.parseFloat(w.getValue()), Float.parseFloat(h.getValue()));
            }
        }
        this.selectedAcquisitionMode = XMLSupport.getAttrib(dbQueryElem, "selectedAcquisitionMode");
        this.selectedPass = XMLSupport.getAttrib(dbQueryElem, "selectedPass");
        String baseDirStr = XMLSupport.getAttrib(dbQueryElem, "baseDir");
        if (!baseDirStr.isEmpty()) {
            this.baseDir = new File(baseDirStr);
        }
        if ((startDateElem = dbQueryElem.getChild("startDate")) != null) {
            this.startDate = DBQuery.getCalendarDate(startDateElem);
        }
        if ((endDateElem = dbQueryElem.getChild("endDate")) != null) {
            this.endDate = DBQuery.getCalendarDate(endDateElem);
        }
        this.freeQuery = XMLSupport.getAttrib(dbQueryElem, "freeQuery");
    }

    private static GregorianCalendar getCalendarDate(Element elem) {
        Attribute y = elem.getAttribute("year");
        Attribute m = elem.getAttribute("month");
        Attribute d = elem.getAttribute("day");
        if (y != null && m != null && d != null) {
            return new GregorianCalendar(Integer.parseInt(y.getValue()), Integer.parseInt(m.getValue()), Integer.parseInt(d.getValue()));
        }
        return null;
    }
}

