/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.datamodel.metadata;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.logging.Logger;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.util.logging.BeamLogManager;
import org.esa.snap.datamodel.metadata.AbstractMetadata;

public abstract class AbstractMetadataBase {
    protected MetadataElement absRoot;
    private static Logger log = BeamLogManager.getSystemLogger();
    public static final int NO_METADATA = 99999;
    public static final short NO_METADATA_BYTE = 0;
    public static final String NO_METADATA_STRING = " ";
    public static final ProductData.UTC NO_METADATA_UTC = new ProductData.UTC(0.0);
    public static final DateFormat dateFormat = ProductData.UTC.createDateFormat((String)"yyyy-MM-dd HH:mm:ss");

    AbstractMetadataBase(MetadataElement root, MetadataElement abstractedMetadata) {
        this.absRoot = abstractedMetadata;
        if (this.absRoot == null) {
            this.absRoot = this.addAbstractedMetadataHeader(root);
        } else {
            this.migrateToCurrentVersion(this.absRoot);
            this.patchMissingMetadata(this.absRoot);
        }
    }

    protected final MetadataElement getAbsRoot() {
        return this.absRoot;
    }

    protected abstract boolean isCurrentVersion();

    protected abstract void migrateToCurrentVersion(MetadataElement var1);

    protected abstract MetadataElement addAbstractedMetadataHeader(MetadataElement var1);

    private void patchMissingMetadata(MetadataElement abstractedMetadata) {
        MetadataAttribute[] attribs;
        if (this.isCurrentVersion()) {
            return;
        }
        MetadataElement tmpElem = new MetadataElement("tmp");
        MetadataElement completeMetadata = this.addAbstractedMetadataHeader(tmpElem);
        for (MetadataAttribute at : attribs = completeMetadata.getAttributes()) {
            if (abstractedMetadata.containsAttribute(at.getName())) continue;
            abstractedMetadata.addAttribute(at);
            abstractedMetadata.getProduct().setModified(false);
        }
    }

    public MetadataAttribute addAbstractedAttribute(MetadataElement dest, String tag, int dataType, String unit, String desc) {
        MetadataAttribute attribute = new MetadataAttribute(tag, dataType, 1);
        if (dataType == 41) {
            attribute.getData().setElems((Object)NO_METADATA_STRING);
        } else if (dataType == 10 || dataType == 20) {
            attribute.getData().setElems((Object)new String[]{String.valueOf(0)});
        } else if (dataType != 51) {
            attribute.getData().setElems((Object)new String[]{String.valueOf(99999)});
        }
        attribute.setUnit(unit);
        attribute.setDescription(desc);
        attribute.setReadOnly(false);
        dest.addAttribute(attribute);
        return attribute;
    }

    public void setAttribute(String tag, String value) {
        AbstractMetadataBase.setAttribute(this.absRoot, tag, value);
    }

    private static void setAttribute(MetadataElement dest, String tag, String value) {
        if (dest == null) {
            return;
        }
        MetadataAttribute attrib = dest.getAttribute(tag);
        if (attrib != null && value != null) {
            if (value.isEmpty()) {
                attrib.getData().setElems((Object)NO_METADATA_STRING);
            } else {
                attrib.getData().setElems((Object)value);
            }
        } else {
            if (attrib == null) {
                log.severe(tag + " not found in metadata");
            }
            if (value == null) {
                log.severe(tag + " metadata value is null");
            }
        }
    }

    public void setAttribute(String tag, ProductData.UTC value) {
        AbstractMetadataBase.setAttribute(this.absRoot, tag, value);
    }

    private static void setAttribute(MetadataElement dest, String tag, ProductData.UTC value) {
        if (dest == null) {
            return;
        }
        MetadataAttribute attrib = dest.getAttribute(tag);
        if (attrib != null && value != null) {
            attrib.getData().setElems((Object)value.getArray());
        } else {
            if (attrib == null) {
                log.severe(tag + " not found in metadata");
            }
            if (value == null) {
                log.severe(tag + " metadata value is null");
            }
        }
    }

    public void setAttribute(String tag, int value) {
        AbstractMetadataBase.setAttribute(this.absRoot, tag, value);
    }

    private static void setAttribute(MetadataElement dest, String tag, int value) {
        if (dest == null) {
            return;
        }
        MetadataAttribute attrib = dest.getAttribute(tag);
        if (attrib == null) {
            log.severe(tag + " not found in metadata");
        } else {
            attrib.getData().setElemInt(value);
        }
    }

    public void setAttribute(String tag, Double value) {
        this.setAttribute(this.absRoot, tag, value);
    }

    public void setAttribute(MetadataElement dest, String tag, Double value) {
        if (dest == null) {
            return;
        }
        MetadataAttribute attrib = dest.getAttribute(tag);
        if (attrib == null) {
            log.severe(tag + " not found in metadata");
        } else if (value != null) {
            attrib.getData().setElemDouble(value.doubleValue());
        }
    }

    public static ProductData.UTC parseUTC(String timeStr) {
        try {
            if (timeStr == null) {
                return NO_METADATA_UTC;
            }
            return ProductData.UTC.parse((String)timeStr);
        }
        catch (ParseException e) {
            return NO_METADATA_UTC;
        }
    }

    private static ProductData.UTC parseUTC(String timeStr, DateFormat format) {
        try {
            int dotPos = timeStr.lastIndexOf(46);
            if (dotPos > 0) {
                String newTimeStr = timeStr.substring(0, Math.min(dotPos + 6, timeStr.length()));
                return ProductData.UTC.parse((String)newTimeStr, (DateFormat)format);
            }
            return ProductData.UTC.parse((String)timeStr, (DateFormat)format);
        }
        catch (ParseException e) {
            log.severe("UTC parse error:" + e.toString());
            return NO_METADATA_UTC;
        }
    }

    public boolean getAttributeBoolean(String tag) throws IllegalArgumentException {
        int val = this.absRoot.getAttributeInt(tag);
        if (val == 99999) {
            throw new IllegalArgumentException("Metadata " + tag + " has not been set");
        }
        return val != 0;
    }

    public double getAttributeDouble(String tag) throws IllegalArgumentException {
        double val = this.absRoot.getAttributeDouble(tag);
        if (val == 99999.0) {
            throw new IllegalArgumentException("Metadata " + tag + " has not been set");
        }
        return val;
    }

    public int getAttributeInt(String tag) throws IllegalArgumentException {
        int val = this.absRoot.getAttributeInt(tag);
        if (val == 99999) {
            throw new IllegalArgumentException("Metadata " + tag + " has not been set");
        }
        return val;
    }

    public String getAttributeString(String tag) throws IllegalArgumentException {
        return this.absRoot.getAttributeString(tag);
    }

    public ProductData.UTC getAttributeUTC(String tag) {
        return this.absRoot.getAttributeUTC(tag, AbstractMetadata.NO_METADATA_UTC);
    }

    public MetadataElement getElement(String tag) throws IllegalArgumentException {
        MetadataElement elem = this.absRoot.getElement(tag);
        if (elem == null) {
            throw new IllegalArgumentException("Element " + tag + " has not been set");
        }
        return elem;
    }
}

