/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.datamodel;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.esa.beam.util.io.FileUtils;
import org.esa.snap.datamodel.DownloadableContent;
import org.esa.snap.datamodel.DownloadableFile;
import org.esa.snap.gpf.StatusProgressMonitor;
import org.esa.snap.util.ResourceUtils;
import org.esa.snap.util.ftpUtils;

public abstract class DownloadableContentImpl
implements DownloadableContent {
    private File localFile;
    private final File localZipFile;
    private boolean localFileExists = false;
    private boolean remoteFileExists = true;
    private boolean errorInLocalFile = false;
    private DownloadableFile contentFile = null;
    private ftpUtils ftp = null;
    private Map<String, Long> fileSizeMap = null;
    private boolean unrecoverableError = false;
    private final URL remoteURL;

    public DownloadableContentImpl(File localFile, URL remoteURL, String archiveExt) {
        this.remoteURL = remoteURL;
        this.localFile = localFile;
        this.localZipFile = FileUtils.exchangeExtension((File)localFile, (String)archiveExt);
    }

    @Override
    public void dispose() {
        try {
            if (this.ftp != null) {
                this.ftp.disconnect();
            }
            this.ftp = null;
            this.contentFile.dispose();
            this.contentFile = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public final DownloadableFile getContentFile() throws IOException {
        if (this.contentFile == null) {
            if (!this.remoteFileExists && !this.localFileExists) {
                return null;
            }
            this.findFile();
        }
        return this.contentFile;
    }

    @Override
    public String getFileName() {
        return this.localFile.getName();
    }

    protected abstract DownloadableFile createContentFile(File var1);

    private boolean findLocalFile() {
        return this.localFile.exists() && this.localFile.isFile() || this.localZipFile.exists() && this.localZipFile.isFile();
    }

    private boolean getRemoteFile() throws IOException {
        if (this.remoteURL.getProtocol().contains("http")) {
            return this.getRemoteHttpFile(this.remoteURL.toString());
        }
        return this.getRemoteFTPFile(this.remoteURL);
    }

    private synchronized void findFile() throws IOException {
        block10: {
            try {
                if (this.contentFile != null) {
                    return;
                }
                if (!this.localFileExists && !this.errorInLocalFile) {
                    this.localFileExists = this.findLocalFile();
                }
                if (this.localFileExists) {
                    this.getLocalFile();
                } else if (this.remoteFileExists && this.getRemoteFile()) {
                    this.getLocalFile();
                }
                if (this.contentFile != null) {
                    this.errorInLocalFile = false;
                } else {
                    if (!this.remoteFileExists && this.localFileExists) {
                        System.out.println("Unable to read product " + this.localFile.getAbsolutePath());
                    }
                    this.localFileExists = false;
                    this.errorInLocalFile = true;
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                this.contentFile = null;
                this.localFileExists = false;
                this.errorInLocalFile = true;
                if (!this.unrecoverableError) break block10;
                throw new IOException(e);
            }
        }
    }

    private void getLocalFile() throws IOException {
        File dataFile = this.localFile;
        if (!dataFile.exists()) {
            dataFile = this.getFileFromZip(this.localZipFile);
        }
        if (dataFile != null) {
            this.contentFile = this.createContentFile(dataFile);
        }
    }

    private boolean getRemoteHttpFile(String baseUrl) throws IOException {
        String remotePath = baseUrl + this.localZipFile.getName();
        System.out.println("http retrieving " + remotePath);
        try {
            DownloadableContentImpl.downloadFile(new URL(remotePath), this.localZipFile);
            return true;
        }
        catch (Exception e) {
            System.out.println("http error:" + e.getMessage() + " on " + remotePath);
            this.remoteFileExists = false;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File downloadFile(URL fileUrl, File localZipFile) throws IOException {
        BufferedOutputStream os;
        File outputFile = new File(localZipFile.getParentFile(), new File(fileUrl.getFile()).getName());
        URLConnection urlConnection = fileUrl.openConnection();
        int contentLength = urlConnection.getContentLength();
        BufferedInputStream is = new BufferedInputStream(urlConnection.getInputStream(), contentLength);
        try {
            if (!outputFile.getParentFile().exists()) {
                outputFile.getParentFile().mkdirs();
            }
            os = new BufferedOutputStream(new FileOutputStream(outputFile));
        }
        catch (IOException e) {
            ((InputStream)is).close();
            throw e;
        }
        try {
            int b;
            int n;
            StatusProgressMonitor status = new StatusProgressMonitor(contentLength, "Downloading " + localZipFile.getName() + "... ");
            status.setAllowStdOut(false);
            int size = 32768;
            byte[] buf = new byte[32768];
            int total = 0;
            while ((n = ((InputStream)is).read(buf, 0, 32768)) > -1) {
                ((OutputStream)os).write(buf, 0, n);
                status.worked(total += n);
            }
            status.done();
            while ((b = ((InputStream)is).read()) != -1) {
                ((OutputStream)os).write(b);
            }
        }
        catch (IOException e) {
            outputFile.delete();
            throw e;
        }
        finally {
            try {
                ((OutputStream)os).close();
            }
            finally {
                ((InputStream)is).close();
            }
        }
        return outputFile;
    }

    private boolean getRemoteFTPFile(URL remoteURL) throws IOException {
        try {
            if (this.ftp == null) {
                this.ftp = new ftpUtils(remoteURL.getHost());
                this.fileSizeMap = ftpUtils.readRemoteFileList(this.ftp, remoteURL.getHost(), remoteURL.getPath());
            }
            String remoteFileName = this.localZipFile.getName();
            Long fileSize = this.fileSizeMap.get(remoteFileName);
            ftpUtils.FTPError result = this.ftp.retrieveFile(remoteURL.getPath() + remoteFileName, this.localZipFile, fileSize);
            if (result == ftpUtils.FTPError.OK) {
                return true;
            }
            if (result == ftpUtils.FTPError.FILE_NOT_FOUND) {
                this.remoteFileExists = false;
            } else {
                this.dispose();
            }
            this.localZipFile.delete();
            return false;
        }
        catch (SocketException e) {
            this.unrecoverableError = true;
            throw e;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            if (this.ftp == null) {
                this.unrecoverableError = false;
                this.remoteFileExists = false;
                throw new IOException("Failed to connect to FTP " + remoteURL.getHost() + '\n' + e.getMessage());
            }
            this.dispose();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getFileFromZip(File dataFile) throws IOException {
        String ext = FileUtils.getExtension((String)dataFile.getName());
        if (ext.equalsIgnoreCase(".zip")) {
            String baseName = this.localFile.getName();
            File newFile = new File(ResourceUtils.getApplicationUserTempDataDir(), baseName);
            if (newFile.exists()) {
                return newFile;
            }
            ZipFile zipFile = null;
            FilterOutputStream fileoutputstream = null;
            try {
                int n;
                String folderName;
                zipFile = new ZipFile(dataFile);
                fileoutputstream = new BufferedOutputStream(new FileOutputStream(newFile));
                ZipEntry zipEntry = zipFile.getEntry(baseName);
                if (zipEntry == null && (zipEntry = zipFile.getEntry(baseName.toLowerCase())) == null && (zipEntry = zipFile.getEntry((folderName = FileUtils.getFilenameWithoutExtension((String)dataFile.getName())) + '/' + this.localFile.getName())) == null) {
                    this.localFileExists = false;
                    throw new IOException("Entry '" + baseName + "' not found in zip file.");
                }
                int size = 8192;
                byte[] buf = new byte[8192];
                InputStream zipinputstream = zipFile.getInputStream(zipEntry);
                while ((n = zipinputstream.read(buf, 0, 8192)) > -1) {
                    ((BufferedOutputStream)fileoutputstream).write(buf, 0, n);
                }
                File file = newFile;
                return file;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                dataFile.delete();
                File file = null;
                return file;
            }
            finally {
                if (zipFile != null) {
                    zipFile.close();
                }
                if (fileoutputstream != null) {
                    fileoutputstream.close();
                }
            }
        }
        return dataFile;
    }
}

