/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.util;

import org.esa.snap.util.Maths;
import org.junit.Assert;
import org.junit.Test;

public class TestMathUtils {
    @Test
    public void testHanning() {
        int windowLength = 5;
        double w0 = Maths.hanning((double)-2.0, (int)windowLength);
        double w1 = Maths.hanning((double)-1.0, (int)windowLength);
        double w2 = Maths.hanning((double)0.0, (int)windowLength);
        double w3 = Maths.hanning((double)1.0, (int)windowLength);
        double w4 = Maths.hanning((double)2.0, (int)windowLength);
        Assert.assertTrue((Double.compare(w0, 0.2500000000000001) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(w1, 0.75) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(w2, 1.0) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(w3, 0.75) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Double.compare(w4, 0.2500000000000001) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testInterpolationSinc() {
        double yExpected;
        double y0 = 5.289999999999999;
        double y1 = 1.6900000000000002;
        double y2 = 0.09;
        double y3 = 0.48999999999999994;
        double y4 = 2.8899999999999997;
        double mu = 0.3;
        double y = Maths.interpolationSinc((double)y0, (double)y1, (double)y2, (double)y3, (double)y4, (double)mu);
        Assert.assertTrue((Double.compare(y, yExpected = -0.06751353045007909) == 0 ? 1 : 0) != 0);
    }
}

