/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.csv.dataio.writer;

import java.io.IOException;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.csv.dataio.writer.CsvWriterBuilder;
import org.esa.snap.csv.dataio.writer.OutputFormatStrategy;
import org.esa.snap.csv.dataio.writer.PixelCsvWriter;
import org.esa.snap.csv.dataio.writer.WriteStrategy;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class PixelCsvWriterTest {
    @Test
    @Ignore
    public void testWriteCsv() throws Exception {
        final StringBuilder actual = new StringBuilder();
        PixelCsvWriter csvWriter = new PixelCsvWriter(new WriteStrategy(){

            public void writeCsv(String fullOutput) throws IOException {
                actual.append(fullOutput);
            }
        }, (OutputFormatStrategy)new CsvWriterBuilder.BeamOutputFormat());
        Product testProduct = new Product("testProduct", "someType", 10, 10);
        PixelPos[] pixelPositions = new PixelPos[]{new PixelPos(), new PixelPos()};
        csvWriter.writeCsv(new Object[]{testProduct, pixelPositions});
        StringBuilder expected = new StringBuilder();
        expected.append("featureId\tattr_1:string\tattr_2:float");
        expected.append("\n");
        expected.append("0\tval_1\t10.0");
        expected.append("\n");
        expected.append("1\tval_2\t20.0");
        expected.append("\n");
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
    }

    @Test
    public void testIsValidInput() throws Exception {
        PixelCsvWriter csvWriter = new PixelCsvWriter(null, null);
        Product testProduct = new Product("testProduct", "someType", 10, 10);
        PixelPos[] pixelPositions = new PixelPos[10];
        Assert.assertFalse((boolean)csvWriter.isValidInput(new Object[0]));
        Assert.assertFalse((boolean)csvWriter.isValidInput(new Object[]{"", "", ""}));
        Assert.assertFalse((boolean)csvWriter.isValidInput(new Object[]{testProduct, new PixelPos(), new PixelPos()}));
        Assert.assertTrue((boolean)csvWriter.isValidInput(new Object[]{testProduct, pixelPositions}));
    }
}

