/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.csv.dataio.writer;

import java.io.IOException;
import junit.framework.Assert;
import org.esa.beam.csv.dataio.writer.CsvWriterBuilder;
import org.esa.beam.csv.dataio.writer.OutputFormatStrategy;
import org.esa.beam.csv.dataio.writer.PixelCsvWriter;
import org.esa.beam.csv.dataio.writer.WriteStrategy;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.junit.Ignore;
import org.junit.Test;

public class PixelCsvWriterTest {
    @Test
    @Ignore
    public void testWriteCsv() throws Exception {
        final StringBuilder actual = new StringBuilder();
        PixelCsvWriter csvWriter = new PixelCsvWriter(new WriteStrategy(){

            public void writeCsv(String fullOutput) throws IOException {
                actual.append(fullOutput);
            }
        }, (OutputFormatStrategy)new CsvWriterBuilder.BeamOutputFormat());
        Product testProduct = new Product("testProduct", "someType", 10, 10);
        PixelPos[] pixelPositions = new PixelPos[]{new PixelPos(), new PixelPos()};
        csvWriter.writeCsv(new Object[]{testProduct, pixelPositions});
        StringBuilder expected = new StringBuilder();
        expected.append("featureId\tattr_1:string\tattr_2:float");
        expected.append("\n");
        expected.append("0\tval_1\t10.0");
        expected.append("\n");
        expected.append("1\tval_2\t20.0");
        expected.append("\n");
        Assert.assertEquals((String)expected.toString(), (String)actual.toString());
    }

    @Test
    public void testIsValidInput() throws Exception {
        PixelCsvWriter csvWriter = new PixelCsvWriter(null, null);
        Product testProduct = new Product("testProduct", "someType", 10, 10);
        PixelPos[] pixelPositions = new PixelPos[10];
        Assert.assertFalse((boolean)csvWriter.isValidInput(new Object[0]));
        Assert.assertFalse((boolean)csvWriter.isValidInput(new Object[]{"", "", ""}));
        Assert.assertFalse((boolean)csvWriter.isValidInput(new Object[]{testProduct, new PixelPos(), new PixelPos()}));
        Assert.assertTrue((boolean)csvWriter.isValidInput(new Object[]{testProduct, pixelPositions}));
    }
}

