/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.csv.dataio.writer;

import java.io.IOException;
import junit.framework.Assert;
import org.esa.beam.csv.dataio.writer.CsvWriterBuilder;
import org.esa.beam.csv.dataio.writer.FeatureCsvWriter;
import org.esa.beam.csv.dataio.writer.OutputFormatStrategy;
import org.esa.beam.csv.dataio.writer.WriteStrategy;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.FeatureTypeImpl;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;

public class FeatureCsvWriterTest {
    @Test
    public void testWriteCsv() throws Exception {
        final StringBuilder s = new StringBuilder();
        FeatureCsvWriter csvWriter = new FeatureCsvWriter(new WriteStrategy(){

            public void writeCsv(String fullOutput) throws IOException {
                s.append(fullOutput);
            }
        }, (OutputFormatStrategy)new CsvWriterBuilder.BeamOutputFormat());
        SimpleFeatureTypeBuilder featureTypeBuilder = new SimpleFeatureTypeBuilder();
        featureTypeBuilder.setName((Name)new NameImpl(""));
        featureTypeBuilder.add("attr_1", String.class);
        featureTypeBuilder.add("attr_2", Float.class);
        SimpleFeatureType featureType = featureTypeBuilder.buildFeatureType();
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
        featureBuilder.set("attr_1", (Object)"val_1");
        featureBuilder.set("attr_2", (Object)Float.valueOf(10.0f));
        SimpleFeature firstFeature = featureBuilder.buildFeature("0");
        featureBuilder.reset();
        featureBuilder.set("attr_1", (Object)"val_2");
        featureBuilder.set("attr_2", (Object)Float.valueOf(20.0f));
        SimpleFeature secondFeature = featureBuilder.buildFeature("1");
        DefaultFeatureCollection featureCollection = new DefaultFeatureCollection("id", featureType);
        featureCollection.add(firstFeature);
        featureCollection.add(secondFeature);
        csvWriter.writeCsv(new Object[]{featureType, featureCollection});
        String csv = s.toString();
        StringBuilder expected = new StringBuilder();
        expected.append("featureId\tattr_1:string\tattr_2:float");
        expected.append("\n");
        expected.append("0\tval_1\t10.0");
        expected.append("\n");
        expected.append("1\tval_2\t20.0");
        expected.append("\n");
        Assert.assertEquals((String)expected.toString(), (String)csv);
    }

    @Test
    public void testIsValidInput() throws Exception {
        FeatureCsvWriter csvWriter = new FeatureCsvWriter(null, null);
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName((Name)new NameImpl(""));
        SimpleFeatureType simpleFeatureType = builder.buildFeatureType();
        Assert.assertTrue((boolean)csvWriter.isValidInput(new Object[]{simpleFeatureType, new DefaultFeatureCollection("id", simpleFeatureType)}));
        FeatureTypeImpl featureType = new FeatureTypeImpl((Name)new NameImpl(""), null, null, false, null, null, null);
        Assert.assertFalse((boolean)csvWriter.isValidInput(new Object[]{featureType, new DefaultFeatureCollection("id", simpleFeatureType)}));
        Assert.assertFalse((boolean)csvWriter.isValidInput(new Object[0]));
    }
}

