/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.csv.dataio.writer;

import com.bc.ceres.core.ProgressMonitor;
import java.io.StringWriter;
import java.io.Writer;
import org.esa.beam.csv.dataio.writer.CsvProductWriterPlugIn;
import org.esa.beam.framework.dataio.ProductWriter;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CsvProductWriterTest {
    private StringWriter result;
    private ProductWriter writer;
    private Product product;

    @Before
    public void setUp() throws Exception {
        this.result = new StringWriter();
        CsvProductWriterPlugIn plugIn = new CsvProductWriterPlugIn((Writer)this.result, 3);
        this.writer = plugIn.createWriterInstance();
        this.product = new Product("testProduct", "testType", 2, 3);
        this.fillBandDataFloat(this.product.addBand("radiance_1", 30), 0);
        this.fillBandDataFloat(this.product.addBand("radiance_2", 31), 10);
        this.fillBandDataInt(this.product.addBand("radiance_3", 12), 100);
        this.writer.writeProductNodes(this.product, (Object)"");
    }

    @Test
    public void testWriteHeader() throws Exception {
        Assert.assertEquals((Object)"featureId\tradiance_1:float\tradiance_2:double\tradiance_3:int", (Object)this.result.toString().trim());
    }

    @Test
    public void testWriteFeatures() throws Exception {
        this.writer.writeBandRasterData(null, -1, -1, -1, -1, null, ProgressMonitor.NULL);
        StringBuilder expected = new StringBuilder("featureId\tradiance_1:float\tradiance_2:double\tradiance_3:int\n");
        expected.append("0\t0.0\t10.0\t100\n");
        expected.append("1\t1.0\t11.0\t101\n");
        expected.append("2\t2.0\t12.0\t102\n");
        expected.append("3\t3.0\t13.0\t103\n");
        expected.append("4\t4.0\t14.0\t104\n");
        expected.append("5\t5.0\t15.0\t105");
        Assert.assertEquals((Object)expected.toString(), (Object)this.result.toString().trim());
    }

    private void fillBandDataInt(Band band, int startValue) {
        ProductData data = band.createCompatibleProductData(this.product.getSceneRasterWidth() * this.product.getSceneRasterHeight());
        int value = startValue;
        int dataIndex = 0;
        for (int i = 0; i < this.product.getSceneRasterWidth(); ++i) {
            for (int j = 0; j < this.product.getSceneRasterHeight(); ++j) {
                data.setElemIntAt(dataIndex++, value++);
            }
        }
        band.setData(data);
    }

    private void fillBandDataFloat(Band band, int startValue) {
        ProductData data = band.createCompatibleProductData(this.product.getSceneRasterWidth() * this.product.getSceneRasterHeight());
        int value = startValue;
        int dataIndex = 0;
        for (int i = 0; i < this.product.getSceneRasterWidth(); ++i) {
            for (int j = 0; j < this.product.getSceneRasterHeight(); ++j) {
                data.setElemFloatAt(dataIndex++, (float)value++);
            }
        }
        band.setData(data);
    }
}

