/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.csv.dataio.reader;

import java.awt.image.Raster;
import java.io.IOException;
import org.esa.beam.csv.dataio.reader.CsvProductReader;
import org.esa.beam.csv.dataio.reader.CsvProductReaderPlugIn;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class CsvProductReaderTest {
    private ProductReader reader;

    @Before
    public void setUp() throws Exception {
        this.reader = new CsvProductReader((ProductReaderPlugIn)new CsvProductReaderPlugIn());
    }

    @Test
    public void testRead_QuadraticProduct() throws Exception {
        Product product = this.readTestProduct("simple_format_4_features.txt");
        Assert.assertNotNull((Object)product);
        Assert.assertEquals((long)2L, (long)product.getSceneRasterWidth());
        Assert.assertEquals((long)2L, (long)product.getSceneRasterHeight());
        this.testBands(product);
    }

    @Test
    public void testRead_QuadraticProduct_2() throws Exception {
        Product product = this.readTestProduct("simple_format_8_features.txt");
        Assert.assertNotNull((Object)product);
        Assert.assertEquals((long)3L, (long)product.getSceneRasterWidth());
        Assert.assertEquals((long)3L, (long)product.getSceneRasterHeight());
        this.testBands(product);
    }

    @Test
    public void testRead_ProductWithGivenWidth() throws Exception {
        Product product = this.readTestProduct("simple_format_sceneRasterWidth.txt");
        Assert.assertNotNull((Object)product);
        Assert.assertEquals((long)4L, (long)product.getSceneRasterWidth());
        Assert.assertEquals((long)2L, (long)product.getSceneRasterHeight());
        this.testBands(product);
    }

    private void testBands(Product product) {
        Band[] bands = product.getBands();
        Assert.assertEquals((long)4L, (long)bands.length);
        Assert.assertEquals((Object)"lat", (Object)bands[0].getName());
        Assert.assertEquals((Object)"lon", (Object)bands[1].getName());
        Assert.assertEquals((Object)"radiance_1", (Object)bands[2].getName());
        Assert.assertEquals((Object)"radiance_2", (Object)bands[3].getName());
        Assert.assertEquals((long)30L, (long)bands[0].getDataType());
        Assert.assertEquals((long)30L, (long)bands[1].getDataType());
        Assert.assertEquals((long)30L, (long)bands[2].getDataType());
        Assert.assertEquals((long)30L, (long)bands[3].getDataType());
    }

    @Test
    public void testRead_ProductWithIntegerValues() throws Exception {
        Product product = this.readTestProduct("simple_format_4_integer_features.txt");
        Assert.assertNotNull((Object)product);
        Assert.assertEquals((long)2L, (long)product.getSceneRasterWidth());
        Assert.assertEquals((long)2L, (long)product.getSceneRasterHeight());
        Band[] bands = product.getBands();
        Assert.assertEquals((long)3L, (long)bands.length);
        Assert.assertEquals((Object)"class", (Object)bands[0].getName());
        Assert.assertEquals((Object)"radiance", (Object)bands[1].getName());
        Assert.assertEquals((Object)"anotherOne", (Object)bands[2].getName());
        Assert.assertEquals((long)12L, (long)bands[0].getDataType());
        Assert.assertEquals((long)30L, (long)bands[1].getDataType());
        Assert.assertEquals((long)12L, (long)bands[2].getDataType());
    }

    @Test
    public void testReadBandRasterData() throws Exception {
        Product product = this.readTestProduct("simple_format_example.txt");
        Assert.assertEquals((long)3L, (long)product.getSceneRasterWidth());
        Assert.assertEquals((long)2L, (long)product.getSceneRasterHeight());
        Band radiance1 = product.getBand("radiance_1");
        Band radiance2 = product.getBand("radiance_2");
        Raster radiance1Data = radiance1.getSourceImage().getData();
        Raster radiance2Data = radiance2.getSourceImage().getData();
        Assert.assertEquals((long)6L, (long)radiance1Data.getDataBuffer().getSize());
        Assert.assertEquals((long)6L, (long)radiance2Data.getDataBuffer().getSize());
        Assert.assertEquals((double)Double.NaN, (double)radiance1Data.getSampleFloat(0, 0, 0), (double)1.0E-6);
        Assert.assertEquals((double)13.4f, (double)radiance2Data.getSampleFloat(0, 0, 0), (double)1.0E-6);
        Assert.assertEquals((double)18.3f, (double)radiance1Data.getSampleFloat(1, 0, 0), (double)1.0E-6);
        Assert.assertEquals((double)2.4f, (double)radiance2Data.getSampleFloat(1, 0, 0), (double)1.0E-6);
        Assert.assertEquals((double)10.5, (double)radiance1Data.getSampleFloat(2, 0, 0), (double)1.0E-6);
        Assert.assertEquals((double)10.6f, (double)radiance2Data.getSampleFloat(2, 0, 0), (double)1.0E-6);
        Assert.assertEquals((double)11.5, (double)radiance1Data.getSampleFloat(0, 1, 0), (double)1.0E-6);
        Assert.assertEquals((double)11.6f, (double)radiance2Data.getSampleFloat(0, 1, 0), (double)1.0E-6);
        Assert.assertEquals((double)Double.NaN, (double)radiance1Data.getSampleFloat(1, 1, 0), (double)1.0E-6);
        Assert.assertEquals((double)Double.NaN, (double)radiance2Data.getSampleFloat(1, 1, 0), (double)1.0E-6);
        Assert.assertEquals((double)Double.NaN, (double)radiance1Data.getSampleFloat(2, 1, 0), (double)1.0E-6);
        Assert.assertEquals((double)Double.NaN, (double)radiance2Data.getSampleFloat(2, 1, 0), (double)1.0E-6);
    }

    private Product readTestProduct(String name) throws IOException {
        return this.reader.readProductNodes((Object)this.getClass().getResource(name).getFile(), null);
    }

    @Test
    public void testInvalidInput() throws Exception {
        try {
            ((CsvProductReader)this.reader).getProductData(null, (ProductData)new ProductData.UTC());
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            Assert.assertTrue((boolean)expected.getMessage().matches("Unsupported type.*"));
        }
    }

    @Test
    public void testGetDataType() throws Exception {
        Assert.assertEquals((long)41L, (long)((CsvProductReader)this.reader).getProductDataType(String.class));
        Assert.assertEquals((long)30L, (long)((CsvProductReader)this.reader).getProductDataType(Float.class));
        Assert.assertEquals((long)31L, (long)((CsvProductReader)this.reader).getProductDataType(Double.class));
        Assert.assertEquals((long)10L, (long)((CsvProductReader)this.reader).getProductDataType(Byte.class));
    }

    @Test
    public void testIsSquareNumber() throws Exception {
        Assert.assertTrue((boolean)CsvProductReader.isSquareNumber((int)1));
        Assert.assertTrue((boolean)CsvProductReader.isSquareNumber((int)4));
        Assert.assertTrue((boolean)CsvProductReader.isSquareNumber((int)9));
        Assert.assertTrue((boolean)CsvProductReader.isSquareNumber((int)16));
        Assert.assertFalse((boolean)CsvProductReader.isSquareNumber((int)2));
        Assert.assertFalse((boolean)CsvProductReader.isSquareNumber((int)3));
        Assert.assertFalse((boolean)CsvProductReader.isSquareNumber((int)5));
        Assert.assertFalse((boolean)CsvProductReader.isSquareNumber((int)10));
        Assert.assertFalse((boolean)CsvProductReader.isSquareNumber((int)11));
    }

    @Test
    @Ignore
    public void testReadMetaData() throws Exception {
        Product product = this.readTestProduct("simple_format_example.txt");
        MetadataElement[] metadataElements = product.getMetadataRoot().getElements();
        MetadataElement propertyElement = metadataElements[0];
        MetadataElement recordElement = metadataElements[1];
        MetadataAttribute[] properties = propertyElement.getAttributes();
        MetadataElement[] records = recordElement.getElements();
        Assert.assertEquals((long)2L, (long)metadataElements.length);
        Assert.assertEquals((Object)"Properties", (Object)propertyElement.getName());
        Assert.assertEquals((Object)"Records", (Object)recordElement.getName());
        Assert.assertEquals((long)4L, (long)properties.length);
        Assert.assertEquals((long)3L, (long)records.length);
        Assert.assertEquals((Object)"geometry1", (Object)properties[0].getName());
        Assert.assertEquals((Object)"POLYGON(1.0, 1.0, 1.1)", (Object)properties[0].getData().getElemString());
        Assert.assertEquals((Object)"geometry2", (Object)properties[1].getName());
        Assert.assertEquals((Object)"POLYGON(2.0, 1.0, 1.1)", (Object)properties[1].getData().getElemString());
        Assert.assertEquals((Object)"separator", (Object)properties[2].getName());
        Assert.assertEquals((Object)",", (Object)properties[2].getData().getElemString());
        Assert.assertEquals((Object)"crs", (Object)properties[3].getName());
        Assert.assertTrue((boolean)properties[3].getData().getElemString().startsWith("GEOGCS[\"WGS 84\""));
        MetadataElement firstRecord = records[0];
        Assert.assertEquals((Object)"0", (Object)firstRecord.getName());
        Assert.assertEquals((long)3L, (long)firstRecord.getAttributes().length);
        Assert.assertEquals((Object)"station", (Object)firstRecord.getAttributes()[0].getName());
        Assert.assertEquals((Object)"AMRU1", (Object)firstRecord.getAttributes()[0].getData().getElemString());
        Assert.assertEquals((long)ProductData.UTC.parse((String)"2010-06-01T12:45:00", (String)"yyyy-MM-dd'T'HH:mm:ss").getAsDate().getTime(), (long)firstRecord.getAttributeUTC("date_time").getAsDate().getTime());
        Assert.assertEquals((long)ProductData.UTC.parse((String)"2011-06-01T10:45:00", (String)"yyyy-MM-dd'T'HH:mm:ss").getAsDate().getTime(), (long)firstRecord.getAttributeUTC("testTime").getAsDate().getTime());
        MetadataElement secondRecord = records[1];
        Assert.assertEquals((Object)"1", (Object)secondRecord.getName());
        Assert.assertEquals((long)2L, (long)secondRecord.getAttributes().length);
        Assert.assertEquals((Object)"station", (Object)secondRecord.getAttributes()[0].getName());
        Assert.assertEquals((Object)"AMRU1", (Object)secondRecord.getAttributes()[0].getData().getElemString());
        Assert.assertEquals((long)ProductData.UTC.parse((String)"2010-06-01T12:48:00", (String)"yyyy-MM-dd'T'HH:mm:ss").getAsDate().getTime(), (long)secondRecord.getAttributeUTC("date_time").getAsDate().getTime());
        Assert.assertNull((Object)secondRecord.getAttribute("testTime"));
        MetadataElement thirdRecord = records[2];
        Assert.assertEquals((Object)"2", (Object)thirdRecord.getName());
        Assert.assertEquals((long)2L, (long)thirdRecord.getAttributes().length);
        Assert.assertEquals((Object)"station", (Object)thirdRecord.getAttributes()[0].getName());
        Assert.assertEquals((Object)"AMRU2", (Object)thirdRecord.getAttributes()[0].getData().getElemString());
        Assert.assertNull((Object)thirdRecord.getAttribute("date_time"));
        Assert.assertEquals((long)ProductData.UTC.parse((String)"2011-06-01T12:45:00", (String)"yyyy-MM-dd'T'HH:mm:ss").getAsDate().getTime(), (long)thirdRecord.getAttributeUTC("testTime").getAsDate().getTime());
    }
}

