/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.collocation;

import java.awt.Color;
import org.esa.snap.collocation.CollocateOp;
import org.esa.snap.collocation.ResamplingType;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VirtualBand;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class CollocateOpTest {
    private static float[] wl = new float[]{412.63956f, 442.51602f, 489.8733f, 509.83f, 559.75757f, 619.7248f, 664.7287f, 680.9848f, 708.49896f, 753.53125f, 761.7092f, 778.552f, 864.88f, 884.8976f, 899.91003f};

    @Test
    public void testCollocate1Type() {
        Product masterProduct = CollocateOpTest.createTestProduct1();
        Product slaveProduct = CollocateOpTest.createTestProduct1();
        CollocateOp op = new CollocateOp();
        op.setParameterDefaultValues();
        Assert.assertEquals((Object)"COLLOCATED", (Object)op.getTargetProductType());
        Assert.assertEquals((Object)true, (Object)op.getRenameMasterComponents());
        Assert.assertEquals((Object)true, (Object)op.getRenameSlaveComponents());
        Assert.assertEquals((Object)"${ORIGINAL_NAME}_M", (Object)op.getMasterComponentPattern());
        Assert.assertEquals((Object)"${ORIGINAL_NAME}_S", (Object)op.getSlaveComponentPattern());
        Assert.assertEquals((Object)ResamplingType.NEAREST_NEIGHBOUR, (Object)op.getResamplingType());
        op.setMasterProduct(masterProduct);
        op.setSlaveProduct(slaveProduct);
        Product targetProduct = op.getTargetProduct();
        int numMasterBands = masterProduct.getNumBands();
        int numSlaveBands = slaveProduct.getNumBands();
        int numMasterTPGs = masterProduct.getNumTiePointGrids();
        int numSlaveTPGs = slaveProduct.getNumTiePointGrids();
        Assert.assertEquals((long)(numMasterBands + numSlaveBands + numSlaveTPGs + 1), (long)targetProduct.getNumBands());
        Assert.assertEquals((long)numMasterTPGs, (long)targetProduct.getNumTiePointGrids());
        Assert.assertEquals((Object)"radiance_1_M", (Object)targetProduct.getBandAt(0).getName());
        Assert.assertEquals((Object)"radiance_2_M", (Object)targetProduct.getBandAt(1).getName());
        Assert.assertEquals((Object)"l1_flags_M", (Object)targetProduct.getBandAt(15).getName());
        Assert.assertEquals((Object)"l1_class_M", (Object)targetProduct.getBandAt(16).getName());
        Assert.assertEquals((Object)"radiance_1_S", (Object)targetProduct.getBandAt(17).getName());
        Assert.assertEquals((Object)"radiance_2_S", (Object)targetProduct.getBandAt(18).getName());
        Assert.assertEquals((Object)"l1_flags_S", (Object)targetProduct.getBandAt(32).getName());
        Assert.assertEquals((Object)"l1_class_S", (Object)targetProduct.getBandAt(33).getName());
        Assert.assertEquals((Object)"latitude_S", (Object)targetProduct.getBandAt(34).getName());
        Assert.assertEquals((Object)"longitude_S", (Object)targetProduct.getBandAt(35).getName());
        Assert.assertEquals((Object)"dem_altitude_S", (Object)targetProduct.getBandAt(36).getName());
        Assert.assertEquals((Object)"!l1_flags_M.INVALID && radiance_1_M > 10", (Object)targetProduct.getBandAt(0).getValidMaskExpression());
        Assert.assertEquals((Object)"!l1_flags_M.INVALID && radiance_1_M > 10", (Object)targetProduct.getBandAt(1).getValidMaskExpression());
        Assert.assertEquals((Object)"(!l1_flags_S.INVALID && radiance_1_S > 10) && collocation_flags.SLAVE_PRESENT", (Object)targetProduct.getBandAt(17).getValidMaskExpression());
        Assert.assertEquals((Object)"(!l1_flags_S.INVALID && radiance_1_S > 10) && collocation_flags.SLAVE_PRESENT", (Object)targetProduct.getBandAt(18).getValidMaskExpression());
        Assert.assertEquals((long)4L, (long)targetProduct.getMaskGroup().getNodeCount());
        Mask mask1 = (Mask)targetProduct.getMaskGroup().get(0);
        Mask mask2 = (Mask)targetProduct.getMaskGroup().get(1);
        Mask mask3 = (Mask)targetProduct.getMaskGroup().get(2);
        Mask mask4 = (Mask)targetProduct.getMaskGroup().get(3);
        Assert.assertNotNull((Object)mask1);
        Assert.assertNotNull((Object)mask2);
        Assert.assertNotNull((Object)mask3);
        Assert.assertNotNull((Object)mask4);
        Assert.assertEquals((Object)"bitmask_M", (Object)mask1.getName());
        Assert.assertEquals((Object)"invalid_M", (Object)mask2.getName());
        Assert.assertEquals((Object)"bitmask_S", (Object)mask3.getName());
        Assert.assertEquals((Object)"invalid_S", (Object)mask4.getName());
        Assert.assertEquals((Object)"radiance_1_M > 10", (Object)Mask.BandMathsType.getExpression((Mask)mask1));
        Assert.assertEquals((Object)"l1_flags_M.INVALID", (Object)Mask.BandMathsType.getExpression((Mask)mask2));
        Assert.assertEquals((Object)"radiance_1_S > 10", (Object)Mask.BandMathsType.getExpression((Mask)mask3));
        Assert.assertEquals((Object)"l1_flags_S.INVALID", (Object)Mask.BandMathsType.getExpression((Mask)mask4));
        Assert.assertEquals((Object)Color.RED, (Object)mask1.getImageColor());
        Assert.assertEquals((Object)Color.GREEN, (Object)mask2.getImageColor());
        Assert.assertEquals((Object)Color.RED, (Object)mask3.getImageColor());
        Assert.assertEquals((Object)Color.GREEN, (Object)mask4.getImageColor());
        Assert.assertEquals((double)0.5, (double)mask1.getImageTransparency(), (double)1.0E-5);
        Assert.assertEquals((double)0.5, (double)mask2.getImageTransparency(), (double)1.0E-5);
        Assert.assertEquals((double)0.5, (double)mask3.getImageTransparency(), (double)1.0E-5);
        Assert.assertEquals((double)0.5, (double)mask4.getImageTransparency(), (double)1.0E-5);
        Assert.assertEquals((long)3L, (long)targetProduct.getFlagCodingGroup().getNodeCount());
        Assert.assertNotNull((Object)targetProduct.getFlagCodingGroup().get("l1_flags_M"));
        Assert.assertNotNull((Object)targetProduct.getFlagCodingGroup().get("l1_flags_S"));
        Assert.assertEquals((long)2L, (long)targetProduct.getIndexCodingGroup().getNodeCount());
        Assert.assertNotNull((Object)targetProduct.getIndexCodingGroup().get("l1_class_M"));
        Assert.assertNotNull((Object)targetProduct.getIndexCodingGroup().get("l1_class_S"));
        Product.AutoGrouping autoGrouping = targetProduct.getAutoGrouping();
        Assert.assertNotNull((Object)autoGrouping);
        Assert.assertEquals((long)2L, (long)autoGrouping.size());
        Assert.assertArrayEquals((Object[])new String[]{"*radiance*_M"}, (Object[])((Object[])autoGrouping.get(0)));
        Assert.assertArrayEquals((Object[])new String[]{"*radiance*_S"}, (Object[])((Object[])autoGrouping.get(1)));
    }

    @Test
    public void testCollocate2Types() {
        Product masterProduct = CollocateOpTest.createTestProduct1();
        Product slaveProduct = CollocateOpTest.createTestProduct2();
        CollocateOp op = new CollocateOp();
        op.setParameterDefaultValues();
        Assert.assertEquals((Object)"COLLOCATED", (Object)op.getTargetProductType());
        Assert.assertEquals((Object)true, (Object)op.getRenameMasterComponents());
        Assert.assertEquals((Object)true, (Object)op.getRenameSlaveComponents());
        Assert.assertEquals((Object)"${ORIGINAL_NAME}_M", (Object)op.getMasterComponentPattern());
        Assert.assertEquals((Object)"${ORIGINAL_NAME}_S", (Object)op.getSlaveComponentPattern());
        Assert.assertEquals((Object)ResamplingType.NEAREST_NEIGHBOUR, (Object)op.getResamplingType());
        op.setMasterProduct(masterProduct);
        op.setSlaveProduct(slaveProduct);
        Product targetProduct = op.getTargetProduct();
        int numMasterBands = masterProduct.getNumBands();
        int numSlaveBands = slaveProduct.getNumBands();
        int numMasterTPGs = masterProduct.getNumTiePointGrids();
        int numSlaveTPGs = slaveProduct.getNumTiePointGrids();
        Assert.assertEquals((long)(numMasterBands + numSlaveBands + numSlaveTPGs + 1), (long)targetProduct.getNumBands());
        Assert.assertEquals((long)numMasterTPGs, (long)targetProduct.getNumTiePointGrids());
        Assert.assertEquals((Object)"radiance_1_M", (Object)targetProduct.getBandAt(0).getName());
        Assert.assertEquals((Object)"radiance_2_M", (Object)targetProduct.getBandAt(1).getName());
        Assert.assertEquals((Object)"l1_flags_M", (Object)targetProduct.getBandAt(15).getName());
        Assert.assertEquals((Object)"l1_class_M", (Object)targetProduct.getBandAt(16).getName());
        Assert.assertEquals((Object)"reflec_1_S", (Object)targetProduct.getBandAt(17).getName());
        Assert.assertEquals((Object)"reflec_2_S", (Object)targetProduct.getBandAt(18).getName());
        Assert.assertEquals((Object)"l2_flags_S", (Object)targetProduct.getBandAt(32).getName());
        Assert.assertEquals((Object)"l2_class_S", (Object)targetProduct.getBandAt(33).getName());
        Assert.assertEquals((Object)"latitude_S", (Object)targetProduct.getBandAt(34).getName());
        Assert.assertEquals((Object)"longitude_S", (Object)targetProduct.getBandAt(35).getName());
        Assert.assertEquals((Object)"dem_altitude_S", (Object)targetProduct.getBandAt(36).getName());
        Assert.assertEquals((Object)"!l1_flags_M.INVALID && radiance_1_M > 10", (Object)targetProduct.getBandAt(0).getValidMaskExpression());
        Assert.assertEquals((Object)"!l1_flags_M.INVALID && radiance_1_M > 10", (Object)targetProduct.getBandAt(1).getValidMaskExpression());
        Assert.assertEquals((Object)"(!l2_flags_S.INVALID && reflec_1_S > 0.1) && collocation_flags.SLAVE_PRESENT", (Object)targetProduct.getBandAt(17).getValidMaskExpression());
        Assert.assertEquals((Object)"(!l2_flags_S.INVALID && reflec_1_S > 0.1) && collocation_flags.SLAVE_PRESENT", (Object)targetProduct.getBandAt(18).getValidMaskExpression());
        Assert.assertEquals((long)3L, (long)targetProduct.getMaskGroup().getNodeCount());
        Mask mask1 = (Mask)targetProduct.getMaskGroup().get(0);
        Mask mask2 = (Mask)targetProduct.getMaskGroup().get(1);
        Mask mask3 = (Mask)targetProduct.getMaskGroup().get(2);
        Assert.assertNotNull((Object)mask1);
        Assert.assertNotNull((Object)mask2);
        Assert.assertNotNull((Object)mask3);
        Assert.assertEquals((Object)"bitmask_M", (Object)mask1.getName());
        Assert.assertEquals((Object)"invalid_M", (Object)mask2.getName());
        Assert.assertEquals((Object)"invalid_S", (Object)mask3.getName());
        Assert.assertEquals((Object)"radiance_1_M > 10", (Object)Mask.BandMathsType.getExpression((Mask)mask1));
        Assert.assertEquals((Object)"l1_flags_M.INVALID", (Object)Mask.BandMathsType.getExpression((Mask)mask2));
        Assert.assertEquals((Object)"l2_flags_S.INVALID", (Object)Mask.BandMathsType.getExpression((Mask)mask3));
        Assert.assertEquals((Object)Color.RED, (Object)mask1.getImageColor());
        Assert.assertEquals((Object)Color.GREEN, (Object)mask2.getImageColor());
        Assert.assertEquals((Object)Color.BLUE, (Object)mask3.getImageColor());
        Assert.assertEquals((double)0.5, (double)mask1.getImageTransparency(), (double)1.0E-5);
        Assert.assertEquals((double)0.5, (double)mask2.getImageTransparency(), (double)1.0E-5);
        Assert.assertEquals((double)0.5, (double)mask3.getImageTransparency(), (double)1.0E-5);
        Assert.assertEquals((long)3L, (long)targetProduct.getFlagCodingGroup().getNodeCount());
        Assert.assertNotNull((Object)targetProduct.getFlagCodingGroup().get("l1_flags_M"));
        Assert.assertNotNull((Object)targetProduct.getFlagCodingGroup().get("l2_flags_S"));
        Assert.assertEquals((long)2L, (long)targetProduct.getIndexCodingGroup().getNodeCount());
        Assert.assertNotNull((Object)targetProduct.getIndexCodingGroup().get("l1_class_M"));
        Assert.assertNotNull((Object)targetProduct.getIndexCodingGroup().get("l2_class_S"));
        Product.AutoGrouping autoGrouping = targetProduct.getAutoGrouping();
        Assert.assertNotNull((Object)autoGrouping);
        Assert.assertEquals((long)2L, (long)autoGrouping.size());
        Assert.assertArrayEquals((Object[])new String[]{"*radiance*_M"}, (Object[])((Object[])autoGrouping.get(0)));
        Assert.assertArrayEquals((Object[])new String[]{"*reflec*_S"}, (Object[])((Object[])autoGrouping.get(1)));
    }

    @Test
    public void testAutogroupingAATSRStyle() {
        Product masterProduct = CollocateOpTest.createTestProductAATSR();
        Product slaveProduct = CollocateOpTest.createTestProduct1();
        CollocateOp op = new CollocateOp();
        op.setParameterDefaultValues();
        op.setMasterProduct(masterProduct);
        op.setSlaveProduct(slaveProduct);
        Product targetProduct = op.getTargetProduct();
        Product.AutoGrouping autoGrouping = targetProduct.getAutoGrouping();
        Assert.assertNotNull((Object)autoGrouping);
        Assert.assertEquals((long)3L, (long)autoGrouping.size());
        Assert.assertArrayEquals((Object[])new String[]{"*nadir*_M"}, (Object[])((Object[])autoGrouping.get(0)));
        Assert.assertArrayEquals((Object[])new String[]{"*fward*_M"}, (Object[])((Object[])autoGrouping.get(1)));
        Assert.assertArrayEquals((Object[])new String[]{"*radiance*_S"}, (Object[])((Object[])autoGrouping.get(2)));
    }

    private static Product createTestProduct1() {
        Product product = new Product("MER_RR_1P", "MER_RR_1P", 16, 16);
        for (int i = 0; i < wl.length; ++i) {
            VirtualBand band = new VirtualBand("radiance_" + (i + 1), 30, 16, 16, "X+Y");
            band.setValidPixelExpression("!l1_flags.INVALID && radiance_1 > 10");
            band.setSpectralWavelength(wl[i]);
            band.setSpectralBandIndex(i);
            product.addBand((Band)band);
        }
        CollocateOpTest.addFlagCoding(product, "l1_flags");
        CollocateOpTest.addIndexCoding(product, "l1_class");
        product.addTiePointGrid(CollocateOpTest.createTPG("latitude"));
        product.addTiePointGrid(CollocateOpTest.createTPG("longitude"));
        product.addTiePointGrid(CollocateOpTest.createTPG("dem_altitude"));
        CollocateOpTest.setSceneGeoCoding(product);
        product.addMask("bitmask", "radiance_1 > 10", null, Color.RED, 0.5);
        product.addMask("invalid", "l1_flags.INVALID", null, Color.GREEN, 0.5);
        product.setAutoGrouping("radiance");
        return product;
    }

    private static Product createTestProduct2() {
        Product product = new Product("MER_RR_2P", "MER_RR_2P", 16, 16);
        for (int i = 0; i < wl.length; ++i) {
            VirtualBand band = new VirtualBand("reflec_" + (i + 1), 30, 16, 16, "X*Y");
            band.setValidPixelExpression("!l2_flags.INVALID && reflec_1 > 0.1");
            band.setSpectralWavelength(wl[i]);
            band.setSpectralBandIndex(i);
            product.addBand((Band)band);
        }
        CollocateOpTest.addFlagCoding(product, "l2_flags");
        CollocateOpTest.addIndexCoding(product, "l2_class");
        product.addTiePointGrid(CollocateOpTest.createTPG("latitude"));
        product.addTiePointGrid(CollocateOpTest.createTPG("longitude"));
        product.addTiePointGrid(CollocateOpTest.createTPG("dem_altitude"));
        CollocateOpTest.setSceneGeoCoding(product);
        product.addMask("invalid", "l2_flags.INVALID", null, Color.BLUE, 0.5);
        product.setAutoGrouping("reflec");
        return product;
    }

    private static Product createTestProductAATSR() {
        Product product = new Product("ATS_TOA_1P", "ATS_TOA_1P", 16, 16);
        product.addBand((Band)new VirtualBand("btemp_nadir_1200", 30, 16, 16, "X*Y"));
        product.addBand((Band)new VirtualBand("btemp_nadir_1100", 30, 16, 16, "X+Y"));
        product.addBand((Band)new VirtualBand("btemp_nadir_0370", 30, 16, 16, "X*X"));
        product.addBand((Band)new VirtualBand("btemp_fward_1200", 30, 16, 16, "Y"));
        product.addBand((Band)new VirtualBand("btemp_fward_1100", 30, 16, 16, "Y*Y"));
        CollocateOpTest.setSceneGeoCoding(product);
        product.setAutoGrouping("nadir:fward");
        return product;
    }

    private static void setSceneGeoCoding(Product product) {
        try {
            product.setSceneGeoCoding((GeoCoding)new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, 16, 16, 0.2, 0.2, 0.1, 0.1));
        }
        catch (FactoryException | TransformException e) {
            Assert.fail((String)"Test product could not be created");
        }
    }

    private static void addIndexCoding(Product product, String indexCodingName) {
        Band classBand = product.addBand(indexCodingName, 21);
        IndexCoding indexCoding = new IndexCoding(indexCodingName);
        indexCoding.addIndex("CLASS_1", 1, "first class");
        indexCoding.addIndex("CLASS_2", 2, "first class");
        classBand.setSampleCoding((SampleCoding)indexCoding);
        product.getIndexCodingGroup().add((ProductNode)indexCoding);
    }

    private static void addFlagCoding(Product product, String flagCodingName) {
        Band flagsBand = product.addBand(flagCodingName, 22);
        FlagCoding flagCoding = new FlagCoding(flagCodingName);
        flagCoding.addFlag("INVALID", 1, "invalid description");
        flagsBand.setSampleCoding((SampleCoding)flagCoding);
        product.getFlagCodingGroup().add((ProductNode)flagCoding);
    }

    private static TiePointGrid createTPG(String name) {
        return new TiePointGrid(name, 5, 5, 0.5, 0.5, 4.0, 4.0, new float[25]);
    }
}

