/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.collocation.visat;

import javax.swing.DefaultComboBoxModel;
import org.esa.snap.collocation.ResamplingType;
import org.esa.snap.collocation.visat.CollocationForm;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.junit.Assert;
import org.junit.Test;

public class CollocationFormTest {
    @Test
    public void testAdaptResamplingComboBoxModel() {
        Product product = new Product("name", "type", 10, 10);
        Band band1 = product.addBand("band1", 12);
        Band band2 = product.addBand("band2", 12);
        DefaultComboBoxModel<ResamplingType> resamplingComboBoxModel = new DefaultComboBoxModel<ResamplingType>(ResamplingType.values());
        boolean validPixelExpressionUsed = CollocationForm.isValidPixelExpressionUsed((Product)product);
        Assert.assertFalse((boolean)validPixelExpressionUsed);
        CollocationForm.adaptResamplingComboBoxModel(resamplingComboBoxModel, (boolean)validPixelExpressionUsed);
        Assert.assertEquals((long)5L, (long)resamplingComboBoxModel.getSize());
        band1.setValidPixelExpression("true");
        validPixelExpressionUsed = CollocationForm.isValidPixelExpressionUsed((Product)product);
        Assert.assertTrue((boolean)validPixelExpressionUsed);
        CollocationForm.adaptResamplingComboBoxModel(resamplingComboBoxModel, (boolean)validPixelExpressionUsed);
        Assert.assertEquals((long)1L, (long)resamplingComboBoxModel.getSize());
        Assert.assertEquals((Object)ResamplingType.NEAREST_NEIGHBOUR, (Object)resamplingComboBoxModel.getSelectedItem());
        band1.setValidPixelExpression(null);
        band2.setValidPixelExpression("  ");
        validPixelExpressionUsed = CollocationForm.isValidPixelExpressionUsed((Product)product);
        Assert.assertFalse((boolean)validPixelExpressionUsed);
        CollocationForm.adaptResamplingComboBoxModel(resamplingComboBoxModel, (boolean)validPixelExpressionUsed);
        Assert.assertEquals((long)5L, (long)resamplingComboBoxModel.getSize());
        Assert.assertEquals((Object)ResamplingType.NEAREST_NEIGHBOUR, (Object)resamplingComboBoxModel.getSelectedItem());
    }
}

