/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.cluster;

import org.esa.snap.cluster.Distribution;
import org.esa.snap.cluster.IndexFilter;

public class ProbabilityCalculator {
    private final IndexFilter NO_FILTERING = new IndexFilter(){

        @Override
        public boolean accept(int index) {
            return true;
        }
    };
    private final Distribution[] distributions;
    private final double[] priors;

    public ProbabilityCalculator(Distribution[] distributions, double[] priors) {
        this.distributions = distributions;
        this.priors = priors;
    }

    public void calculate(double[] point, double[] posteriors) {
        this.calculate(point, posteriors, this.NO_FILTERING);
    }

    public void calculate(double[] point, double[] posteriors, IndexFilter filter) {
        int k;
        double sum = 0.0;
        for (k = 0; k < this.distributions.length; ++k) {
            if (filter.accept(k)) {
                posteriors[k] = this.priors[k] * this.distributions[k].probabilityDensity(point);
                sum += posteriors[k];
                continue;
            }
            posteriors[k] = 0.0;
        }
        if (sum > 0.0) {
            for (k = 0; k < this.distributions.length; ++k) {
                if (!filter.accept(k)) continue;
                int n = k;
                posteriors[n] = posteriors[n] / sum;
            }
        } else {
            int k2;
            double[] sums = new double[this.distributions.length];
            for (k2 = 0; k2 < this.distributions.length; ++k2) {
                if (!filter.accept(k2)) continue;
                posteriors[k2] = this.distributions[k2].logProbabilityDensity(point);
            }
            for (k2 = 0; k2 < this.distributions.length; ++k2) {
                if (!filter.accept(k2)) continue;
                for (int l = 0; l < this.distributions.length; ++l) {
                    if (!filter.accept(l) || l == k2) continue;
                    int n = k2;
                    sums[n] = sums[n] + this.priors[l] / this.priors[k2] * Math.exp(posteriors[l] - posteriors[k2]);
                }
            }
            for (k2 = 0; k2 < this.distributions.length; ++k2) {
                if (!filter.accept(k2)) continue;
                posteriors[k2] = 1.0 / (1.0 + sums[k2]);
            }
        }
    }
}

