/*
 * Decompiled with CFR 0.152.
 */
package de.gkss.hs.datev2004;

import de.gkss.hs.datev2004.Clucov;
import de.gkss.hs.datev2004.DataSet;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Random;
import junit.framework.TestCase;

public class ClucovTest
extends TestCase {
    public void testClucov() throws IOException, URISyntaxException {
        DataSet ds = new DataSet(ClucovTest.class.getResource("iris.mdda").toURI().getPath());
        Random rgen = new Random(12345L);
        Clucov clucov = new Clucov(ds, rgen);
        clucov.max_iteration = 20;
        clucov.n_planes = 100;
        clucov.mahadistsqCut = 16.0;
        clucov.t_comb = 0.45;
        clucov.t_div = 0.2;
        clucov.cont_min = 15;
        clucov.max_clusters = 20;
        clucov.few_changes = 0;
        clucov.initialize(6);
        clucov.run();
        ClucovTest.assertEquals((int)3, (int)clucov.clusters.size());
        this.testCluster(clucov, (short)1, "(3,1)l", 54, new double[]{6.5518519, 2.95, 5.4981481, 1.9888888}, new double[][]{{0.385089, 0.092407, 0.2988, 0.058354}, {0.092407, 0.111389, 0.083426, 0.056296}, {0.2988, 0.083426, 0.316108, 0.064239}, {0.058354, 0.056296, 0.064239, 0.084691}});
        this.testCluster(clucov, (short)2, "(5,4)", 50, new double[]{5.006, 3.425999, 1.457999, 0.246}, new double[][]{{0.121764, 0.097244, 0.015652, 0.010124}, {0.097244, 0.141124, 0.010292, 0.009204}, {0.015652, 0.010292, 0.030036, 0.005332}, {0.010124, 0.009204, 0.005332, 0.010884}});
        this.testCluster(clucov, (short)3, "(3,1)r", 46, new double[]{5.9217391, 2.7804348, 4.1934782, 1.3021739}, new double[][]{{0.279093, 0.09673, 0.186881, 0.056692}, {0.09673, 0.092009, 0.089003, 0.043303}, {0.186881, 0.089003, 0.194088, 0.060666}, {0.056692, 0.043303, 0.060666, 0.033256}});
    }

    private void testCluster(Clucov clucov, short k, String history, int npoints, double[] avg, double[][] cov) {
        int i;
        ClucovTest.assertNotNull((Object)clucov.clusters);
        Clucov.Cluster cluster = (Clucov.Cluster)clucov.clusters.get(k);
        ClucovTest.assertNotNull((Object)cluster);
        ClucovTest.assertEquals((short)k, (short)cluster.group);
        ClucovTest.assertEquals((String)history, (String)cluster.history);
        ClucovTest.assertEquals((long)npoints, (long)cluster.fm.npoints);
        ClucovTest.assertEquals((int)4, (int)cluster.fm.dim);
        ClucovTest.assertEquals((int)4, (int)cluster.fm.avg.length);
        for (i = 0; i < cluster.fm.avg.length; ++i) {
            ClucovTest.assertEquals((double)avg[i], (double)cluster.fm.avg[i], (double)1.0E-5);
        }
        ClucovTest.assertEquals((int)4, (int)cluster.fm.cov.length);
        for (i = 0; i < cluster.fm.cov.length; ++i) {
            ClucovTest.assertEquals((int)4, (int)cluster.fm.cov[i].length);
            for (int j = 0; j < cluster.fm.cov[i].length; ++j) {
                ClucovTest.assertEquals((double)cov[i][j], (double)cluster.fm.cov[i][j], (double)1.0E-5);
            }
        }
    }
}

