/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.cluster;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import junit.framework.TestCase;
import org.esa.snap.cluster.EMCluster;
import org.esa.snap.cluster.EMClusterer;

public class EMClustererTest
extends TestCase {
    private static final double A = 1.0;
    private static final double B = 2.0;

    public void testFindClusters() {
        double[][] points = EMClustererTest.createRandomPoints(new double[]{1.0, 2.0, 1.0, 2.0, 1.0, 2.0, 1.0, 2.0, 2.0, 1.0, 2.0, 1.0, 2.0, 1.0, 2.0, 1.0, 1.0, 2.0, 1.0, 2.0, 1.0, 2.0, 1.0, 2.0, 2.0, 1.0, 2.0, 1.0, 2.0, 1.0, 2.0, 1.0, 1.0, 2.0, 1.0, 2.0, 1.0, 2.0, 1.0, 2.0, 2.0, 1.0, 2.0, 1.0, 2.0, 1.0, 2.0, 1.0, 1.0, 2.0, 1.0, 2.0, 1.0, 2.0, 1.0, 2.0, 2.0, 1.0, 2.0, 1.0, 2.0, 1.0, 2.0, 1.0});
        EMCluster[] clusters = EMClusterer.findClusters((double[][])points, (int)2, (int)100, (int)5489);
        EMClustererTest.assertEquals((int)2, (int)clusters.length);
        Arrays.sort(clusters, new Comparator<EMCluster>(){

            @Override
            public int compare(EMCluster o1, EMCluster o2) {
                return Double.compare(o1.getMean(0), o2.getMean(0));
            }
        });
        EMClustererTest.assertEquals((double)1.0, (double)clusters[0].getMean(0), (double)0.1);
        EMClustererTest.assertEquals((double)2.0, (double)clusters[1].getMean(0), (double)0.1);
    }

    private static double[][] createRandomPoints(double[] doubles) {
        double[][] points = new double[doubles.length][1];
        Random random = new Random(5489L);
        for (int i = 0; i < doubles.length; ++i) {
            points[i][0] = doubles[i] + 0.1 * random.nextGaussian();
        }
        return points;
    }
}

