/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.classification.gpf.maximumlikelihood;

import Jama.Matrix;
import java.util.HashMap;
import java.util.Map;
import net.sf.javaml.classification.AbstractClassifier;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.correlation.StorelessCovariance;
import org.esa.snap.core.util.SystemUtils;

public class MaximumLikelihood
extends AbstractClassifier {
    private Map<Object, double[]> meanVector;
    private Map<Object, Matrix> invCov;
    private Map<Object, Double> determinant;
    private double constantTerm;
    private final boolean biasCorrected = true;

    public void buildClassifier(Dataset data) {
        this.meanVector = new HashMap<Object, double[]>();
        this.invCov = new HashMap<Object, Matrix>();
        this.determinant = new HashMap<Object, Double>();
        this.constantTerm = 1.0 / Math.pow(Math.PI * 2, (double)data.noAttributes() / 2.0);
        HashMap covarianceMap = new HashMap();
        HashMap<Object, Integer> cntMap = new HashMap<Object, Integer>();
        for (Object o : data.classes()) {
            covarianceMap.put(o, new StorelessCovariance(data.noAttributes(), true));
            this.meanVector.put(o, new double[data.noAttributes()]);
            cntMap.put(o, 0);
        }
        double[] features = new double[data.noAttributes()];
        for (Instance i : data) {
            Object classVal = i.classValue();
            int j = 0;
            while (j < features.length) {
                double featureVal;
                features[j] = featureVal = i.value(j);
                double[] dArray = this.meanVector.get(classVal);
                int n = j++;
                dArray[n] = dArray[n] + featureVal;
            }
            ((StorelessCovariance)covarianceMap.get(classVal)).increment(features);
            cntMap.replace(classVal, (Integer)cntMap.get(classVal) + 1);
        }
        for (Object o : covarianceMap.keySet()) {
            int i = 0;
            while (i < data.noAttributes()) {
                double[] dArray = this.meanVector.get(o);
                int n = i++;
                dArray[n] = dArray[n] / (double)((Integer)cntMap.get(o)).intValue();
            }
            try {
                RealMatrix m1 = ((StorelessCovariance)covarianceMap.get(o)).getCovarianceMatrix();
                Matrix m2 = new Matrix(m1.getData());
                this.invCov.put(o, m2.inverse());
                this.determinant.put(o, Math.abs(m2.det()));
            }
            catch (Exception e) {
                SystemUtils.LOG.info("MaximumLikelihood.buildClassifier: cannot classify " + o + ' ' + e.getMessage());
            }
        }
    }

    public Map<Object, Double> classDistribution(Instance instance) {
        HashMap<Object, Double> dis = new HashMap<Object, Double>();
        double sum = 0.0;
        for (Object o : this.meanVector.keySet()) {
            if (!this.invCov.containsKey(o) || !this.determinant.containsKey(o)) continue;
            double[] tmp = new double[instance.noAttributes()];
            for (int i = 0; i < instance.noAttributes(); ++i) {
                tmp[i] = instance.value(i) - this.meanVector.get(o)[i];
            }
            Matrix diffMat = new Matrix(tmp, tmp.length);
            Matrix tmpMat = diffMat.transpose().times(this.invCov.get(o));
            Matrix m1 = tmpMat.times(diffMat);
            if (m1.getColumnDimension() != 1 || m1.getRowDimension() != 1) {
                SystemUtils.LOG.info("ERROR: #col = " + m1.getColumnDimension() + " #row = " + m1.getRowDimension());
            }
            double expg = Math.exp(-0.5 * m1.get(0, 0)) * this.constantTerm * (1.0 / Math.sqrt(Math.abs(this.determinant.get(o))));
            sum += expg;
            dis.put(o, expg);
        }
        for (Object o : dis.keySet()) {
            double val = (Double)dis.get(o);
            dis.replace(o, val / sum);
        }
        return dis;
    }
}

