/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.classification.gpf.kdtknn;

import net.sf.javaml.classification.Classifier;
import net.sf.javaml.classification.KDtreeKNN;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;
import org.esa.snap.classification.gpf.BaseClassifier;
import org.esa.snap.classification.gpf.ClassifierDescriptor;
import org.esa.snap.classification.gpf.SupervisedClassifier;
import org.esa.snap.classification.gpf.kdtknn.KDTreeKNNClassifierParams;

public class KDTreeKNNClassifier
extends BaseClassifier
implements SupervisedClassifier {
    private int numNeighbours = 5;

    public KDTreeKNNClassifier(BaseClassifier.ClassifierParams params, int numNeighbours) {
        super(params);
        this.numNeighbours = numNeighbours;
    }

    @Override
    protected Object getObjectToSave(Dataset trainDataset) {
        return new KDTreeKNNClassifierParams(this.numNeighbours, trainDataset);
    }

    @Override
    public Classifier createMLClassifier(BaseClassifier.FeatureInfo[] featureInfos) {
        return new KDtreeKNN(this.numNeighbours);
    }

    @Override
    public Classifier retrieveMLClassifier(ClassifierDescriptor classifierDescriptor) {
        Object object = classifierDescriptor.getObject();
        KDTreeKNNClassifierParams params = (KDTreeKNNClassifierParams)object;
        KDtreeKNN classifier = new KDtreeKNN(params.getNumNeighbours());
        classifier.buildClassifier(params.getTrainDataset());
        return classifier;
    }

    @Override
    protected double getConfidence(Instance instance, Object classVal) {
        return 1.0;
    }

    @Override
    protected Object getXMLInfoToSave(BaseClassifier.ClassifierUserInfo commonInfo) {
        UserInfo userInfo = new UserInfo(commonInfo, this.numNeighbours);
        return userInfo;
    }

    public static class UserInfo {
        private BaseClassifier.ClassifierUserInfo commonInfo;
        private int numNeighbours;

        public UserInfo(BaseClassifier.ClassifierUserInfo commonInfo, int numNeighbours) {
            this.commonInfo = commonInfo;
            this.numNeighbours = numNeighbours;
        }
    }
}

