/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.classification.gpf.svm;

import java.util.Iterator;
import java.util.SortedSet;
import libsvm.LibSVM;
import libsvm.svm;
import libsvm.svm_node;
import libsvm.svm_parameter;
import libsvm.svm_problem;
import net.sf.javaml.classification.Classifier;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;
import org.esa.snap.classification.gpf.BaseClassifier;
import org.esa.snap.classification.gpf.ClassifierDescriptor;
import org.esa.snap.classification.gpf.SupervisedClassifier;
import org.esa.snap.core.dataop.downloadable.StatusProgressMonitor;
import org.esa.snap.engine_utilities.gpf.ThreadManager;

public class SVMClassifier
extends BaseClassifier
implements SupervisedClassifier {
    private static final double[] c = new double[]{0.03125, 0.125, 0.5, 2.0, 8.0, 32.0, 128.0, 512.0, 2048.0, 8192.0, 32768.0};
    private static final double[] gamma = new double[]{3.0517578125E-5, 1.220703125E-4, 4.8828125E-4, 0.001953125, 0.0078125, 0.03125, 0.125, 0.5, 2.0, 8.0};

    public SVMClassifier(BaseClassifier.ClassifierParams params) {
        super(params);
    }

    @Override
    public Classifier createMLClassifier(BaseClassifier.FeatureInfo[] featureInfos) {
        LibSVM libSVM = new LibSVM();
        svm_parameter param = libSVM.getParameters();
        param.svm_type = 1;
        param.kernel_type = 0;
        param.cache_size = 300.0;
        return libSVM;
    }

    @Override
    public Classifier retrieveMLClassifier(ClassifierDescriptor classifierDescriptor) {
        return (LibSVM)classifierDescriptor.getObject();
    }

    @Override
    protected void buildClassifier(Classifier classifier, Dataset trainDataset) {
        LibSVM libSVM = (LibSVM)classifier;
        libSVM.buildClassifier(trainDataset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void findOptimalModelParameters(LibSVM libSVM, Dataset trainDataset) throws Exception {
        StatusProgressMonitor pm = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
        svm_parameter param = libSVM.getParameters();
        final svm_problem problem = SVMClassifier.transformDataset(trainDataset);
        ThreadManager threadManager = new ThreadManager();
        final NewValues newValues = new NewValues();
        pm.beginTask("Determining optimal parameters...", c.length * gamma.length);
        try {
            for (int i = 0; i < c.length; ++i) {
                if (pm.isCanceled()) {
                    return;
                }
                int j = 0;
                while (j < gamma.length) {
                    final svm_parameter newParam = (svm_parameter)param.clone();
                    newParam.C = c[i];
                    newParam.gamma = gamma[j];
                    final int ii = i;
                    final int jj = j++;
                    Thread worker = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            double accuracy = SVMClassifier.performCrossValidation(newParam, problem);
                            1 var3_2 = this;
                            synchronized (var3_2) {
                                if (accuracy > newValues.accuracyMax) {
                                    newValues.accuracyMax = accuracy;
                                    newValues.cIdx = ii;
                                    newValues.gammaIdx = jj;
                                }
                            }
                        }
                    };
                    threadManager.add(worker);
                    pm.worked(1);
                }
            }
        }
        finally {
            pm.done();
        }
        threadManager.finish();
        param.C = c[newValues.cIdx];
        param.gamma = gamma[newValues.gammaIdx];
    }

    private static double performCrossValidation(svm_parameter param, svm_problem problem) {
        double[] target = new double[problem.l];
        svm.svm_cross_validation((svm_problem)problem, (svm_parameter)param, (int)3, (double[])target);
        int countErr = 0;
        int i = 0;
        for (double y : problem.y) {
            if (y != target[i]) {
                ++countErr;
            }
            ++i;
        }
        return (1.0 - (double)countErr / (double)problem.l) * 100.0;
    }

    private static svm_problem transformDataset(Dataset data) {
        svm_problem p = new svm_problem();
        p.l = data.size();
        p.y = new double[data.size()];
        p.x = new svm_node[data.size()][];
        int tmpIndex = 0;
        for (int j = 0; j < data.size(); ++j) {
            Instance tmp = data.instance(j);
            p.y[tmpIndex] = data.classIndex(tmp.classValue());
            p.x[tmpIndex] = new svm_node[tmp.keySet().size()];
            int i = 0;
            SortedSet tmpSet = tmp.keySet();
            Iterator i$ = tmpSet.iterator();
            while (i$.hasNext()) {
                int index = (Integer)i$.next();
                p.x[tmpIndex][i] = new svm_node();
                p.x[tmpIndex][i].index = index;
                p.x[tmpIndex][i].value = tmp.value(index);
                ++i;
            }
            ++tmpIndex;
        }
        return p;
    }

    private static class NewValues {
        public double accuracyMax = 0.0;
        public int cIdx = 0;
        public int gammaIdx = 0;

        private NewValues() {
        }
    }
}

