/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.selection.support;

import com.bc.ceres.swing.selection.Selection;
import com.bc.ceres.swing.selection.SelectionChangeEvent;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import com.bc.ceres.swing.selection.support.DefaultSelection;
import com.bc.ceres.swing.selection.support.ListSelectionContext;
import com.bc.ceres.swing.selection.support.TableSelectionContext;
import com.bc.ceres.swing.selection.support.TreeSelectionContext;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import junit.framework.TestCase;

public class SwingSelectionProviderTest
extends TestCase {
    private static final Object[] LIST_DATA = new Object[]{"Sauerkraut", "Zwiebeln", "\u00c4pfel", "Wacholderbeeren"};
    private static final TreeNode[] TREE_DATA;
    private static final Object[][] TABLE_DATA;
    private static final Object[][] TABLE_CNAMES;
    private static final DefaultMutableTreeNode TREE_GEMUESE;
    private static final DefaultMutableTreeNode TREE_OBST;
    private static final DefaultMutableTreeNode LEAF_SAUERKRAUT;
    private static final DefaultMutableTreeNode LEAF_ZWIEBELN;
    private static final DefaultMutableTreeNode LEAF_AEPFEL;
    private static final DefaultMutableTreeNode LEAF_BEEREN;

    public void testListSelectionProvider() {
        JList<Object> list = new JList<Object>(LIST_DATA);
        ListSelectionContext selectionContext = new ListSelectionContext(list);
        SwingSelectionProviderTest.assertSame(list, (Object)selectionContext.getList());
        SwingSelectionProviderTest.assertSame((Object)DefaultSelection.EMPTY, (Object)selectionContext.getSelection());
        SwingSelectionProviderTest.testListSelectionProvider(selectionContext);
        JList<Object> otherList = new JList<Object>(LIST_DATA);
        otherList.setSelectedIndices(new int[]{2, 0, 3});
        selectionContext.setList(otherList);
        SwingSelectionProviderTest.assertSame(otherList, (Object)selectionContext.getList());
        SwingSelectionProviderTest.assertEquals((Object)new DefaultSelection(new Object[]{"Sauerkraut", "\u00c4pfel", "Wacholderbeeren"}), (Object)selectionContext.getSelection());
        SwingSelectionProviderTest.testListSelectionProvider(selectionContext);
    }

    public void testTreeSelectionProvider() {
        JTree tree = new JTree(TREE_DATA);
        TreeSelectionContext selectionContext = new TreeSelectionContext(tree);
        SwingSelectionProviderTest.assertSame((Object)tree, (Object)selectionContext.getTree());
        SwingSelectionProviderTest.assertSame((Object)DefaultSelection.EMPTY, (Object)selectionContext.getSelection());
        SwingSelectionProviderTest.testTreeSelectionProvider(selectionContext);
        JTree otherTree = new JTree(TREE_DATA);
        otherTree.setSelectionPaths(new TreePath[]{new TreePath(new Object[]{TREE_GEMUESE, LEAF_SAUERKRAUT}), new TreePath(new Object[]{TREE_OBST, LEAF_AEPFEL}), new TreePath(new Object[]{TREE_OBST, LEAF_BEEREN})});
        selectionContext.setTree(otherTree);
        SwingSelectionProviderTest.assertSame((Object)otherTree, (Object)selectionContext.getTree());
        SwingSelectionProviderTest.testTreeSelectionProvider(selectionContext);
    }

    public void testTableSelectionProvider() {
        JTable table = new JTable(TABLE_DATA, (Object[])TABLE_CNAMES);
        TableSelectionContext selectionContext = new TableSelectionContext(table);
        SwingSelectionProviderTest.assertSame((Object)table, (Object)selectionContext.getTable());
        SwingSelectionProviderTest.assertSame((Object)DefaultSelection.EMPTY, (Object)selectionContext.getSelection());
        SwingSelectionProviderTest.testTableSelectionProvider(selectionContext);
        JTable otherTable = new JTable(TABLE_DATA, (Object[])TABLE_CNAMES);
        otherTable.setRowSelectionInterval(2, 2);
        otherTable.addRowSelectionInterval(0, 0);
        otherTable.addRowSelectionInterval(3, 3);
        selectionContext.setTable(otherTable);
        SwingSelectionProviderTest.assertSame((Object)otherTable, (Object)selectionContext.getTable());
        SwingSelectionProviderTest.assertEquals((Object)new DefaultSelection(new Object[]{0, 2, 3}), (Object)selectionContext.getSelection());
        SwingSelectionProviderTest.testTableSelectionProvider(selectionContext);
    }

    private static void testListSelectionProvider(ListSelectionContext selectionContext) {
        SelectionChangeHandler listener = new SelectionChangeHandler();
        selectionContext.addSelectionChangeListener((SelectionChangeListener)listener);
        DefaultSelection selection = new DefaultSelection((Object[])new String[]{"Zwiebeln"});
        selectionContext.setSelection((Selection)selection);
        SwingSelectionProviderTest.assertNotSame((Object)selection, (Object)selectionContext.getSelection());
        SwingSelectionProviderTest.assertEquals((Object)selection, (Object)selectionContext.getSelection());
        SwingSelectionProviderTest.assertEquals((String)"1;", (String)listener.callSeq);
        selection = new DefaultSelection((Object[])new String[]{"Zwiebeln", "\u00c4pfel"});
        selectionContext.setSelection((Selection)selection);
        SwingSelectionProviderTest.assertNotSame((Object)selection, (Object)selectionContext.getSelection());
        SwingSelectionProviderTest.assertEquals((Object)selection, (Object)selectionContext.getSelection());
        SwingSelectionProviderTest.assertEquals((String)"1;2;", (String)listener.callSeq);
        selection = DefaultSelection.EMPTY;
        selectionContext.setSelection((Selection)selection);
        SwingSelectionProviderTest.assertSame((Object)selection, (Object)selectionContext.getSelection());
        SwingSelectionProviderTest.assertEquals((Object)selection, (Object)selectionContext.getSelection());
        SwingSelectionProviderTest.assertEquals((String)"1;2;0;", (String)listener.callSeq);
        selection = new DefaultSelection(LIST_DATA);
        selectionContext.setSelection((Selection)selection);
        SwingSelectionProviderTest.assertNotSame((Object)selection, (Object)selectionContext.getSelection());
        SwingSelectionProviderTest.assertEquals((Object)selection, (Object)selectionContext.getSelection());
        SwingSelectionProviderTest.assertEquals((String)"1;2;0;4;", (String)listener.callSeq);
    }

    private static void testTreeSelectionProvider(TreeSelectionContext selectionContext) {
        SelectionChangeHandler listener = new SelectionChangeHandler();
        selectionContext.addSelectionChangeListener((SelectionChangeListener)listener);
        DefaultSelection selection = new DefaultSelection((Object[])new TreePath[]{new TreePath(new Object[]{TREE_GEMUESE, LEAF_ZWIEBELN})});
        selectionContext.setSelection((Selection)selection);
        SwingSelectionProviderTest.assertNotSame((Object)selection, (Object)selectionContext.getSelection());
        SwingSelectionProviderTest.assertEquals((String)"1;", (String)listener.callSeq);
        selection = new DefaultSelection((Object[])new TreePath[]{new TreePath(new Object[]{TREE_OBST, LEAF_AEPFEL}), new TreePath(new Object[]{TREE_GEMUESE, LEAF_ZWIEBELN})});
        selectionContext.setSelection((Selection)selection);
        SwingSelectionProviderTest.assertNotSame((Object)selection, (Object)selectionContext.getSelection());
        SwingSelectionProviderTest.assertEquals((String)"1;2;", (String)listener.callSeq);
        selection = DefaultSelection.EMPTY;
        selectionContext.setSelection((Selection)selection);
        SwingSelectionProviderTest.assertSame((Object)selection, (Object)selectionContext.getSelection());
        SwingSelectionProviderTest.assertEquals((Object)selection, (Object)selectionContext.getSelection());
        SwingSelectionProviderTest.assertEquals((String)"1;2;0;", (String)listener.callSeq);
        selection = new DefaultSelection((Object[])new TreePath[]{new TreePath(new Object[]{TREE_OBST, LEAF_AEPFEL}), new TreePath(new Object[]{TREE_OBST, LEAF_BEEREN}), new TreePath(new Object[]{TREE_GEMUESE, LEAF_SAUERKRAUT}), new TreePath(new Object[]{TREE_GEMUESE, LEAF_ZWIEBELN})});
        selectionContext.setSelection((Selection)selection);
        SwingSelectionProviderTest.assertNotSame((Object)selection, (Object)selectionContext.getSelection());
        SwingSelectionProviderTest.assertEquals((String)"1;2;0;4;", (String)listener.callSeq);
    }

    private static void testTableSelectionProvider(TableSelectionContext selectionContext) {
        SelectionChangeHandler listener = new SelectionChangeHandler();
        selectionContext.addSelectionChangeListener((SelectionChangeListener)listener);
        DefaultSelection selection = new DefaultSelection((Object[])new Integer[]{1});
        selectionContext.setSelection((Selection)selection);
        SwingSelectionProviderTest.assertNotSame((Object)selection, (Object)selectionContext.getSelection());
        SwingSelectionProviderTest.assertEquals((Object)selection, (Object)selectionContext.getSelection());
        SwingSelectionProviderTest.assertEquals((String)"1;", (String)listener.callSeq);
        selection = new DefaultSelection((Object[])new Integer[]{1, 2});
        selectionContext.setSelection((Selection)selection);
        SwingSelectionProviderTest.assertNotSame((Object)selection, (Object)selectionContext.getSelection());
        SwingSelectionProviderTest.assertEquals((Object)selection, (Object)selectionContext.getSelection());
        SwingSelectionProviderTest.assertEquals((String)"1;2;", (String)listener.callSeq);
        selection = DefaultSelection.EMPTY;
        selectionContext.setSelection((Selection)selection);
        SwingSelectionProviderTest.assertSame((Object)selection, (Object)selectionContext.getSelection());
        SwingSelectionProviderTest.assertEquals((Object)selection, (Object)selectionContext.getSelection());
        SwingSelectionProviderTest.assertEquals((String)"1;2;0;", (String)listener.callSeq);
        selection = new DefaultSelection((Object[])new Integer[]{0, 1, 2, 3});
        selectionContext.setSelection((Selection)selection);
        SwingSelectionProviderTest.assertNotSame((Object)selection, (Object)selectionContext.getSelection());
        SwingSelectionProviderTest.assertEquals((Object)selection, (Object)selectionContext.getSelection());
        SwingSelectionProviderTest.assertEquals((String)"1;2;0;4;", (String)listener.callSeq);
    }

    static {
        TABLE_DATA = new Object[][]{{4, Character.valueOf('A'), "Sauerkraut"}, {1, Character.valueOf('B'), "Zwiebeln"}, {6, Character.valueOf('C'), "\u00c4pfel"}, {2, Character.valueOf('D'), "Wacholderbeeren"}};
        TABLE_CNAMES = new Object[][]{{"C1", "C2", "C3"}};
        TREE_GEMUESE = new DefaultMutableTreeNode("Gem\u00fcse");
        TREE_OBST = new DefaultMutableTreeNode("Obst");
        LEAF_SAUERKRAUT = new DefaultMutableTreeNode("Sauerkraut");
        LEAF_ZWIEBELN = new DefaultMutableTreeNode("Zwiebeln");
        LEAF_AEPFEL = new DefaultMutableTreeNode("\u00c4pfel");
        LEAF_BEEREN = new DefaultMutableTreeNode("Wacholderbeeren");
        TREE_GEMUESE.add(LEAF_SAUERKRAUT);
        TREE_GEMUESE.add(LEAF_ZWIEBELN);
        TREE_OBST.add(LEAF_AEPFEL);
        TREE_OBST.add(LEAF_BEEREN);
        TREE_DATA = new TreeNode[]{TREE_GEMUESE, TREE_OBST};
    }

    private static class SelectionChangeHandler
    implements SelectionChangeListener {
        private String callSeq = "";

        private SelectionChangeHandler() {
        }

        public void selectionChanged(SelectionChangeEvent event) {
            this.callSeq = this.callSeq + event.getSelection().getSelectedValues().length + ";";
        }

        public void selectionContextChanged(SelectionChangeEvent event) {
        }
    }
}

