/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.selection.support;

import com.bc.ceres.swing.selection.Selection;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import com.bc.ceres.swing.selection.SelectionContext;
import com.bc.ceres.swing.selection.TracingSelectionChangeListener;
import com.bc.ceres.swing.selection.support.DefaultSelection;
import com.bc.ceres.swing.selection.support.DefaultSelectionContext;
import com.bc.ceres.swing.selection.support.DefaultSelectionManager;
import junit.framework.TestCase;

public class DefaultSelectionManagerTest
extends TestCase {
    public void testDefaults() {
        DefaultSelectionManager sm = new DefaultSelectionManager((Object)this);
        DefaultSelectionManagerTest.assertNull((Object)sm.getSelectionContext());
        DefaultSelectionManagerTest.assertNotNull((Object)sm.getSelection());
        DefaultSelectionManagerTest.assertEquals((boolean)true, (boolean)sm.getSelection().isEmpty());
    }

    public void testSelectionManagement() {
        DefaultSelection selectionA = new DefaultSelection(new Object[]{"A"});
        DefaultSelection selectionB = new DefaultSelection(new Object[]{"B"});
        DefaultSelectionContext context1 = new DefaultSelectionContext();
        DefaultSelectionContext context2 = new DefaultSelectionContext();
        context1.setSelection((Selection)selectionA);
        context2.setSelection((Selection)selectionB);
        DefaultSelectionManager manager = new DefaultSelectionManager((Object)this);
        TracingSelectionChangeListener listener = new TracingSelectionChangeListener();
        manager.addSelectionChangeListener((SelectionChangeListener)listener);
        DefaultSelectionManagerTest.assertEquals((String)"", (String)listener.trace);
        manager.setSelectionContext((SelectionContext)context1);
        DefaultSelectionManagerTest.assertSame((Object)context1, (Object)manager.getSelectionContext());
        DefaultSelectionManagerTest.assertEquals((Object)selectionA, (Object)manager.getSelection());
        DefaultSelectionManagerTest.assertEquals((String)"scc;sc(A);", (String)listener.trace);
        listener.trace = "";
        manager.setSelectionContext((SelectionContext)context2);
        DefaultSelectionManagerTest.assertSame((Object)context2, (Object)manager.getSelectionContext());
        DefaultSelectionManagerTest.assertEquals((String)"scc;sc(B);", (String)listener.trace);
        listener.trace = "";
        manager.setSelectionContext((SelectionContext)context2);
        DefaultSelectionManagerTest.assertSame((Object)context2, (Object)manager.getSelectionContext());
        DefaultSelectionManagerTest.assertEquals((String)"", (String)listener.trace);
        context2.setSelection((Selection)selectionA);
        DefaultSelectionManagerTest.assertSame((Object)selectionA, (Object)manager.getSelection());
        context2.setSelection((Selection)selectionB);
        DefaultSelectionManagerTest.assertSame((Object)selectionB, (Object)manager.getSelection());
        DefaultSelectionManagerTest.assertEquals((String)"sc(A);sc(B);", (String)listener.trace);
        listener.trace = "";
        context1.setSelection((Selection)selectionA);
        DefaultSelectionManagerTest.assertSame((Object)selectionB, (Object)manager.getSelection());
        context1.setSelection((Selection)selectionB);
        DefaultSelectionManagerTest.assertSame((Object)selectionB, (Object)manager.getSelection());
        DefaultSelectionManagerTest.assertEquals((String)"", (String)listener.trace);
        manager.setSelectionContext((SelectionContext)context1);
        DefaultSelectionManagerTest.assertSame((Object)selectionB, (Object)manager.getSelection());
        DefaultSelectionManagerTest.assertEquals((String)"scc;", (String)listener.trace);
        listener.trace = "";
        context1.setSelection((Selection)selectionA);
        context1.setSelection((Selection)selectionB);
        context1.setSelection((Selection)selectionB);
        context1.setSelection((Selection)selectionB);
        context1.setSelection((Selection)selectionA);
        context1.setSelection((Selection)selectionA);
        context1.setSelection((Selection)selectionB);
        DefaultSelectionManagerTest.assertEquals((String)"sc(A);sc(B);sc(A);sc(B);", (String)listener.trace);
    }

    public void testListeners() {
        DefaultSelectionManager sm = new DefaultSelectionManager((Object)this);
        SelectionChangeListener[] changeListeners = sm.getSelectionChangeListeners();
        DefaultSelectionManagerTest.assertNotNull((Object)changeListeners);
        DefaultSelectionManagerTest.assertEquals((int)0, (int)changeListeners.length);
        TracingSelectionChangeListener listener1 = new TracingSelectionChangeListener();
        TracingSelectionChangeListener listener2 = new TracingSelectionChangeListener();
        TracingSelectionChangeListener listener3 = new TracingSelectionChangeListener();
        sm.addSelectionChangeListener((SelectionChangeListener)listener1);
        sm.addSelectionChangeListener((SelectionChangeListener)listener2);
        sm.addSelectionChangeListener((SelectionChangeListener)listener3);
        changeListeners = sm.getSelectionChangeListeners();
        DefaultSelectionManagerTest.assertNotNull((Object)changeListeners);
        DefaultSelectionManagerTest.assertEquals((int)3, (int)changeListeners.length);
        DefaultSelectionManagerTest.assertSame((Object)listener1, (Object)changeListeners[0]);
        DefaultSelectionManagerTest.assertSame((Object)listener2, (Object)changeListeners[1]);
        DefaultSelectionManagerTest.assertSame((Object)listener3, (Object)changeListeners[2]);
        sm.removeSelectionChangeListener((SelectionChangeListener)listener2);
        changeListeners = sm.getSelectionChangeListeners();
        DefaultSelectionManagerTest.assertNotNull((Object)changeListeners);
        DefaultSelectionManagerTest.assertEquals((int)2, (int)changeListeners.length);
        DefaultSelectionManagerTest.assertSame((Object)listener1, (Object)changeListeners[0]);
        DefaultSelectionManagerTest.assertSame((Object)listener3, (Object)changeListeners[1]);
        sm.removeSelectionChangeListener((SelectionChangeListener)listener1);
        sm.removeSelectionChangeListener((SelectionChangeListener)listener3);
        changeListeners = sm.getSelectionChangeListeners();
        DefaultSelectionManagerTest.assertNotNull((Object)changeListeners);
        DefaultSelectionManagerTest.assertEquals((int)0, (int)changeListeners.length);
    }
}

