/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.binding;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.Validator;
import com.bc.ceres.binding.ValueRange;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.BindingProblem;
import com.bc.ceres.swing.binding.BindingProblemListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;

public class BindingContextUI {
    String name = "Urte";
    int age = 20;
    double height = 1.5;
    String eyeColor = "brown";
    Gender gender = Gender.female;
    String country = "Germany";
    boolean healthy = true;
    JPanel controlPanel;
    BindingContext bindingContext;

    public BindingContextUI() {
        PropertyContainer vc = PropertyContainer.createObjectBacked((Object)this);
        vc.getProperty("name").getDescriptor().setNotEmpty(true);
        vc.getProperty("age").getDescriptor().setValueRange(new ValueRange(1.0, 150.0));
        vc.getProperty("height").getDescriptor().setValueRange(new ValueRange(0.5, 2.5));
        vc.getProperty("gender").getDescriptor().setValueSet(new ValueSet(new Object[]{Gender.female, Gender.male}));
        vc.getProperty("eyeColor").getDescriptor().setNotEmpty(true);
        vc.getProperty("eyeColor").getDescriptor().setValidator((Validator)new LettersOnlyValidator());
        vc.getProperty("country").getDescriptor().setValueSet(new ValueSet(new Object[]{"France", "Italy", "Spain", "Germany", "United Kingdom", "United States"}));
        this.bindingContext = new BindingContext((PropertySet)vc);
        this.bindingContext.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                System.out.println(this + ": '" + evt.getPropertyName() + "' changed from '" + evt.getOldValue() + "' to '" + evt.getNewValue() + "'");
            }
        });
        this.bindingContext.addProblemListener(new BindingProblemListener(){

            public void problemReported(BindingProblem newProblem, BindingProblem oldProblem) {
                System.out.println("problemReported: newProblem = " + newProblem);
                System.out.println("                 oldProblem = " + oldProblem);
            }

            public void problemCleared(BindingProblem oldProblem) {
                System.out.println("problemCleared: oldProblem = " + oldProblem);
            }
        });
        this.bindingContext.bind("name", new JTextField(16));
        this.bindingContext.bind("age", new JTextField(4));
        this.bindingContext.bind("height", (JTextComponent)new JTextArea(1, 7));
        JComboBox<String> comboBox = new JComboBox<String>(new DefaultComboBoxModel<String>(new String[]{"brown", "blue", "green"}));
        comboBox.setEditable(true);
        this.bindingContext.bind("eyeColor", comboBox);
        JRadioButton r1 = new JRadioButton("Female");
        JRadioButton r2 = new JRadioButton("Male");
        ButtonGroup bg = new ButtonGroup();
        bg.add(r1);
        bg.add(r2);
        this.bindingContext.bind("gender", bg);
        this.bindingContext.bind("country", new JComboBox());
        this.bindingContext.bind("healthy", new JCheckBox("Yes, I am not ill"));
        GridBagConstraints gbc = new GridBagConstraints();
        this.controlPanel = new JPanel(new GridBagLayout());
        gbc.anchor = 256;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.gridx = 0;
        this.controlPanel.add((Component)new JLabel("Name: "), gbc);
        gbc.gridx = 1;
        this.controlPanel.add((Component)BindingContextUI.getPrimaryComponent(this.bindingContext, "name"), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.controlPanel.add((Component)r1, gbc);
        gbc.gridx = 1;
        this.controlPanel.add((Component)r2, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.controlPanel.add((Component)new JLabel("Age: "), gbc);
        gbc.gridx = 1;
        this.controlPanel.add((Component)BindingContextUI.getPrimaryComponent(this.bindingContext, "age"), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.controlPanel.add((Component)new JLabel("Height: "), gbc);
        gbc.gridx = 1;
        this.controlPanel.add((Component)BindingContextUI.getPrimaryComponent(this.bindingContext, "height"), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.controlPanel.add((Component)new JLabel("Eye colour: "), gbc);
        gbc.gridx = 1;
        this.controlPanel.add((Component)BindingContextUI.getPrimaryComponent(this.bindingContext, "eyeColor"), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.controlPanel.add((Component)new JLabel("Country: "), gbc);
        gbc.gridx = 1;
        this.controlPanel.add((Component)BindingContextUI.getPrimaryComponent(this.bindingContext, "country"), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        this.controlPanel.add((Component)BindingContextUI.getPrimaryComponent(this.bindingContext, "healthy"), gbc);
    }

    private static JComponent getPrimaryComponent(BindingContext ctx, String s) {
        return ctx.getBinding(s).getComponents()[0];
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        final JFrame frame = new JFrame(BindingContextUI.class.getSimpleName() + " - Main");
        JButton modalButton = new JButton("Modal");
        modalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BindingContextUI.createDlg(frame, true);
            }
        });
        JButton modelessButton = new JButton("Modeless");
        modelessButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BindingContextUI.createDlg(frame, false);
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 2, 2));
        buttonPanel.add(modalButton);
        buttonPanel.add(modelessButton);
        frame.setDefaultCloseOperation(3);
        frame.add(buttonPanel);
        frame.pack();
        frame.setVisible(true);
    }

    private static void createDlg(JFrame frame, final boolean modal) {
        JButton applyButton = new JButton(modal ? "OK" : "Apply");
        JButton closeButton = new JButton(modal ? "Cancel" : "Close");
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 2, 2));
        buttonPanel.add(applyButton);
        buttonPanel.add(closeButton);
        final BindingContextUI ui = new BindingContextUI();
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        panel.setBorder(new EmptyBorder(4, 4, 4, 4));
        panel.add((Component)ui.controlPanel, "Center");
        panel.add((Component)buttonPanel, "South");
        final JDialog dlg = new JDialog(frame, BindingContextUI.class.getSimpleName() + " - " + (modal ? "Modal" : "Modeless"), modal);
        dlg.setDefaultCloseOperation(2);
        dlg.setContentPane(panel);
        dlg.pack();
        dlg.setLocation(frame.getX() + frame.getWidth(), frame.getY());
        dlg.getRootPane().setDefaultButton(applyButton);
        applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BindingProblem[] bindingProblems = ui.bindingContext.getProblems();
                if (bindingProblems.length > 0) {
                    for (int i = 0; i < bindingProblems.length; ++i) {
                        BindingProblem bindingProblem = bindingProblems[i];
                        System.out.println("bindingProblem[" + i + "] = " + bindingProblem.getCause().getMessage());
                    }
                    JOptionPane.showMessageDialog(dlg, "Problems!");
                } else {
                    System.out.println("Apply!");
                    if (modal) {
                        dlg.dispose();
                    }
                }
            }
        });
        ui.bindingContext.preventPropertyChanges((JComponent)closeButton);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Close!");
                dlg.dispose();
            }
        });
        dlg.setVisible(true);
    }

    private static class LettersOnlyValidator
    implements Validator {
        private LettersOnlyValidator() {
        }

        public void validateValue(Property property, Object value) throws ValidationException {
            for (char c : ((String)value).toCharArray()) {
                if (Character.isLetter(c)) continue;
                throw new ValidationException("Only letters!");
            }
        }
    }

    static enum Gender {
        male,
        female;

    }
}

