/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing;

import com.bc.ceres.swing.GridGuiTest;
import com.bc.ceres.swing.ListControlBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;

public class ListControlBarTest {
    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JSplitPane splitPane = new JSplitPane(0, true, GridGuiTest.createGridPanel(), ListControlBarTest.createListPanel());
        JFrame frame = new JFrame(ListControlBarTest.class.getSimpleName());
        frame.getContentPane().add((Component)splitPane, "West");
        frame.getContentPane().add((Component)ListControlBarTest.createTablePanel(), "Center");
        frame.setDefaultCloseOperation(3);
        frame.setSize(340, 340);
        frame.setVisible(true);
    }

    private static JPanel createListPanel() {
        final DefaultListModel listModel = new DefaultListModel();
        final JList list = new JList(listModel);
        ListControlBar listControlBar = ListControlBar.create((int)1, list, (ListControlBar.ListController)new ListControlBar.AbstractListController(){

            public boolean addRow(int index) {
                listModel.addElement(ListControlBarTest.genName());
                list.setSelectedIndex(listModel.getSize() - 1);
                return true;
            }

            public boolean removeRows(int[] indices) {
                int[] clone = (int[])indices.clone();
                Arrays.sort(clone);
                list.clearSelection();
                for (int i = clone.length - 1; i >= 0; --i) {
                    listModel.remove(indices[i]);
                }
                return true;
            }

            public boolean moveRowUp(int index) {
                String element = (String)listModel.remove(index);
                listModel.insertElementAt(element, index - 1);
                list.setSelectedIndex(index - 1);
                return true;
            }

            public boolean moveRowDown(int index) {
                String element = (String)listModel.remove(index);
                listModel.insertElementAt(element, index + 1);
                list.setSelectedIndex(index + 1);
                return false;
            }
        }, (String[])new String[0]);
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        panel.setBorder(new EmptyBorder(4, 4, 4, 4));
        panel.add((Component)new JLabel("List of stuff:"), "North");
        panel.add((Component)new JScrollPane(list), "Center");
        panel.add((Component)listControlBar, "East");
        return panel;
    }

    private static JPanel createTablePanel() {
        final DefaultTableModel tableModel = new DefaultTableModel(new String[]{"Target name", "Source", "Aggregator", "Parameters"}, 0);
        final JTable table = new JTable(tableModel);
        ListControlBar listControlBar = ListControlBar.create((int)1, (JTable)table, (ListControlBar.ListController)new ListControlBar.AbstractListController(){

            public boolean addRow(int index) {
                tableModel.addRow(new Object[]{ListControlBarTest.genName(), ListControlBarTest.genName(), ListControlBarTest.genName(), ListControlBarTest.genName()});
                table.getSelectionModel().clearSelection();
                table.getSelectionModel().addSelectionInterval(tableModel.getRowCount() - 1, tableModel.getRowCount() - 1);
                return true;
            }

            public boolean removeRows(int[] indices) {
                int[] clone = (int[])indices.clone();
                Arrays.sort(clone);
                table.getSelectionModel().clearSelection();
                for (int i = clone.length - 1; i >= 0; --i) {
                    tableModel.removeRow(indices[i]);
                }
                return true;
            }

            public boolean moveRowUp(int index) {
                tableModel.moveRow(index, index, index - 1);
                table.getSelectionModel().clearSelection();
                table.getSelectionModel().addSelectionInterval(index - 1, index - 1);
                return true;
            }

            public boolean moveRowDown(int index) {
                tableModel.moveRow(index, index, index + 1);
                table.getSelectionModel().clearSelection();
                table.getSelectionModel().addSelectionInterval(index + 1, index + 1);
                return true;
            }
        }, (String[])new String[0]);
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        panel.setBorder(new EmptyBorder(4, 4, 4, 4));
        panel.add((Component)new JLabel("Table of things:"), "North");
        panel.add((Component)new JScrollPane(table), "Center");
        panel.add((Component)listControlBar, "East");
        return panel;
    }

    public static String genName() {
        int n = 3 + (int)(Math.random() * 8.0);
        char[] str = new char[n];
        char[] voc = new char[]{'a', 'a', 'a', 'e', 'e', 'e', 'e', 'e', 'i', 'i', 'o', 'o', 'u', 'u', 'y'};
        for (int i = 0; i < str.length; ++i) {
            str[i] = i % 2 == 0 ? voc[(int)(Math.random() * (double)voc.length)] : (char)(97 + (int)(25.0 * Math.random()));
        }
        str[0] = Character.toUpperCase(str[0]);
        return new String(str);
    }
}

