/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing;

import com.bc.ceres.swing.ActionLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import junit.framework.TestCase;

public class ActionLabelTest
extends TestCase {
    public void testConstructors() {
        ActionLabel label = new ActionLabel();
        ActionLabelTest.assertEquals(null, (String)label.getText());
        ActionLabelTest.assertNotNull((Object)label.getActionListeners());
        ActionLabelTest.assertEquals((int)0, (int)label.getActionListeners().length);
        label = new ActionLabel("X");
        ActionLabelTest.assertEquals((String)"X", (String)label.getText());
        ActionLabelTest.assertNotNull((Object)label.getActionListeners());
        ActionLabelTest.assertEquals((int)0, (int)label.getActionListeners().length);
        ActionListener testAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        label = new ActionLabel("Y", testAction);
        ActionLabelTest.assertEquals((String)"Y", (String)label.getText());
        ActionLabelTest.assertNotNull((Object)label.getActionListeners());
        ActionLabelTest.assertEquals((int)1, (int)label.getActionListeners().length);
        ActionLabelTest.assertSame((Object)testAction, (Object)label.getActionListeners()[0]);
    }

    public static void main(String[] args) {
        JComponent panel = new JComponent(){

            @Override
            protected void paintComponent(Graphics g) {
                g.setColor(this.getBackground());
                Rectangle bounds = this.getBounds();
                g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            }
        };
        ActionLabelTest.assertEquals((boolean)false, (boolean)panel.isOpaque());
        panel.setBackground(new Color(0, 255, 0, 127));
        panel.add(new JButton("Button 1"));
        panel.add(new JLabel("Normal label 1"));
        panel.add((Component)new ActionLabel("Action label 1", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("e = " + e);
            }
        }));
        panel.add(new JLabel("Normal label 2"));
        panel.add((Component)new ActionLabel("Action label 2", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("e = " + e);
            }
        }));
        panel.add(new JButton("Button 2"));
        JPanel containerPanel = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                int w = this.getWidth();
                int h = this.getHeight();
                for (int y = 8; y < h; y += 16) {
                    g.drawLine(0, y, w, y);
                }
                for (int x = 8; x < w; x += 16) {
                    g.drawLine(x, 0, x, h);
                }
            }
        };
        containerPanel.setBackground(new Color(255, 255, 255, 127));
        containerPanel.add((Component)panel, "Center");
        JFrame frame = new JFrame(ActionLabel.class.getSimpleName());
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)containerPanel, "Center");
        frame.pack();
        frame.setVisible(true);
    }
}

