/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.reader;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Variable;

class VariableReader {
    private final Variable binVariable;
    private final int[] origin;
    private final int[] shape;
    private final int binDimIndex;

    VariableReader(Variable binVariable) {
        this.binVariable = binVariable;
        this.origin = null;
        this.shape = null;
        this.binDimIndex = 0;
    }

    VariableReader(Variable binVariable, int[] origin, int[] shape, int binDimIndex) {
        this.binVariable = binVariable;
        this.origin = origin;
        this.shape = shape;
        this.binDimIndex = binDimIndex;
    }

    Variable getBinVariable() {
        return this.binVariable;
    }

    Array readFully() throws IOException {
        if (this.origin == null) {
            return this.binVariable.read();
        }
        try {
            return this.binVariable.read(this.origin, this.shape).reduce();
        }
        catch (InvalidRangeException e) {
            throw new IOException(e.getMessage());
        }
    }

    Array read(int firstIndex, int length) throws IOException {
        try {
            if (this.origin == null) {
                return this.binVariable.read(new int[]{firstIndex}, new int[]{length});
            }
            int[] originFull = (int[])this.origin.clone();
            int[] shapeFull = (int[])this.shape.clone();
            originFull[this.binDimIndex] = firstIndex;
            shapeFull[this.binDimIndex] = length;
            return this.binVariable.read(originFull, shapeFull).reduce();
        }
        catch (InvalidRangeException e) {
            throw new IOException(e.getMessage());
        }
    }
}

