/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.reader;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.esa.snap.binning.reader.BinnedFileFilter;
import org.esa.snap.binning.reader.BinnedProductReader;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.dataio.netcdf.util.NetcdfFileOpener;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class BinnedProductReaderPlugin
implements ProductReaderPlugIn {
    static final String FORMAT_NAME = "Binned_data_product";
    static final String FORMAT_DESCRIPTION = "SeaDAS-Level-3-alike NetCDF files containing binned Level-3 data";
    static final String FILE_EXTENSION = ".nc";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DecodeQualification getDecodeQualification(Object input) {
        if (input == null) {
            return DecodeQualification.UNABLE;
        }
        String path = input.toString();
        if (!FILE_EXTENSION.equalsIgnoreCase(FileUtils.getExtension((String)path))) return DecodeQualification.UNABLE;
        try (NetcdfFile netcdfFile = null;){
            netcdfFile = NetcdfFileOpener.open((Object)path);
            if (netcdfFile == null) {
                DecodeQualification decodeQualification = DecodeQualification.UNABLE;
                return decodeQualification;
            }
            for (Variable variable : netcdfFile.getVariables()) {
                Attribute gridMappingName = variable.findAttribute("grid_mapping_name");
                if (gridMappingName != null && "1D binned sinusoidal".equalsIgnoreCase(gridMappingName.getStringValue())) {
                    DecodeQualification decodeQualification = DecodeQualification.INTENDED;
                    return decodeQualification;
                }
                Attribute gridMapping = variable.findAttribute("grid_mapping");
                if (gridMapping == null || !"sinusoidal".equalsIgnoreCase(gridMapping.getStringValue())) continue;
                DecodeQualification decodeQualification = DecodeQualification.INTENDED;
                return decodeQualification;
            }
            if (netcdfFile.findDimension("bin_index") == null) return DecodeQualification.UNABLE;
            if (netcdfFile.findDimension("sin_grid") == null) {
                if (netcdfFile.findDimension("bin_list") == null) return DecodeQualification.UNABLE;
            }
            DecodeQualification decodeQualification = DecodeQualification.INTENDED;
            return decodeQualification;
        }
        catch (IOException e) {
            return DecodeQualification.UNABLE;
        }
    }

    public Class[] getInputTypes() {
        return new Class[]{String.class, File.class};
    }

    public ProductReader createReaderInstance() {
        return new BinnedProductReader(this);
    }

    public SnapFileFilter getProductFileFilter() {
        return new BinnedFileFilter();
    }

    public String[] getFormatNames() {
        return new String[]{FORMAT_NAME};
    }

    public String[] getDefaultFileExtensions() {
        return new String[]{FILE_EXTENSION};
    }

    public String getDescription(Locale locale) {
        return "Reader for SeaDAS-Level-3-alike NetCDF files containing binned Level-3 data";
    }
}

