/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.support;

import org.esa.snap.binning.PlanetaryGrid;

public final class SEAGrid
implements PlanetaryGrid {
    public static final int DEFAULT_NUM_ROWS = 2160;
    public static double RE = 6378.145;
    private final int numRows;
    private final double[] latBin;
    private final long[] baseBin;
    private final int[] numBin;
    private final long numBins;

    public SEAGrid() {
        this(2160);
    }

    public SEAGrid(int numRows) {
        if (numRows < 2) {
            throw new IllegalArgumentException("numRows < 2");
        }
        if (numRows % 2 != 0) {
            throw new IllegalArgumentException("numRows % 2 != 0");
        }
        this.numRows = numRows;
        this.latBin = new double[numRows];
        this.baseBin = new long[numRows];
        this.numBin = new int[numRows];
        this.baseBin[0] = 0L;
        for (int row = 0; row < numRows; ++row) {
            this.latBin[row] = 90.0 - ((double)row + 0.5) * 180.0 / (double)numRows;
            this.numBin[row] = (int)(0.5 + (double)(2 * numRows) * Math.cos(Math.toRadians(this.latBin[row])));
            if (row <= 0) continue;
            this.baseBin[row] = this.baseBin[row - 1] + (long)this.numBin[row - 1];
        }
        this.numBins = this.baseBin[numRows - 1] + (long)this.numBin[numRows - 1];
    }

    public static int computeRowCount(double res) {
        int numRows = 1 + (int)Math.floor(0.5 * (Math.PI * 2 * RE) / res);
        if (numRows % 2 == 0) {
            return numRows;
        }
        return numRows + 1;
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public int getNumCols(int row) {
        return this.numBin[row];
    }

    @Override
    public long getNumBins() {
        return this.numBins;
    }

    @Override
    public long getFirstBinIndex(int row) {
        return this.baseBin[row];
    }

    @Override
    public double getCenterLat(int row) {
        return this.latBin[row];
    }

    @Override
    public long getBinIndex(double lat, double lon) {
        int row = this.getRowIndex(lat);
        int col = this.getColIndex(lon, row);
        return this.baseBin[row] + (long)col;
    }

    @Override
    public int getRowIndex(long binIndex) {
        int max = this.baseBin.length - 1;
        long[] rowBinIds = this.baseBin;
        int low = 0;
        int high = max;
        while (true) {
            int mid;
            if (binIndex < rowBinIds[mid = low + high >>> 1]) {
                high = mid - 1;
                continue;
            }
            if (mid == max) {
                return mid;
            }
            if (binIndex < rowBinIds[mid + 1]) {
                return mid;
            }
            low = mid + 1;
        }
    }

    @Override
    public double[] getCenterLatLon(long binIndex) {
        int row = this.getRowIndex(binIndex);
        return new double[]{this.latBin[row], this.getCenterLon(row, (int)(binIndex - this.baseBin[row]))};
    }

    public double getCenterLon(int row, int col) {
        return 360.0 * ((double)col + 0.5) / (double)this.numBin[row] - 180.0;
    }

    public int getColIndex(double lon, int row) {
        if (lon <= -180.0) {
            return 0;
        }
        if (lon >= 180.0) {
            return this.numBin[row] - 1;
        }
        return (int)((180.0 + lon) * (double)this.numBin[row] / 360.0);
    }

    public int getRowIndex(double lat) {
        if (lat <= -90.0) {
            return this.numRows - 1;
        }
        if (lat >= 90.0) {
            return 0;
        }
        return this.numRows - 1 - (int)((90.0 + lat) * ((double)this.numRows / 180.0));
    }
}

