/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.support;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.esa.snap.binning.Bin;
import org.esa.snap.binning.BinManager;
import org.esa.snap.binning.Observation;
import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.binning.SpatialBin;
import org.esa.snap.binning.TemporalBin;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.binning.Vector;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.runtime.Config;

public class BinTracer {
    private static final String SYSPROP_TRACE_LAT_LON = "snap.binning.traceLatLon";
    private final long binIndex;
    private final String[] obsNames;
    private final String[] spatialFeatureNames;
    private final String[] temporalFeatureNames;
    private final String[] outputFeatureNames;
    private final String[] postFeatureNames;
    private final String outputFile;
    private String productName;
    private boolean spatialHeaderWritten;
    private boolean temporalHeaderWritten;
    private PrintStream out;

    public static boolean traceThis(BinTracer binTracer, long binIndex) {
        return binTracer != null && binTracer.binIndex == binIndex;
    }

    public static boolean isActive() {
        return Config.instance().preferences().get(SYSPROP_TRACE_LAT_LON, null) != null;
    }

    public static BinTracer create(BinManager binManager, PlanetaryGrid planetaryGridInst, String productOutputFile) {
        long binIndex = BinTracer.getBinIndexToTrace(planetaryGridInst);
        if (binIndex == -1L) {
            return null;
        }
        VariableContext variableContext = binManager.getVariableContext();
        String[] obsNames = new String[variableContext.getVariableCount()];
        for (int i = 0; i < obsNames.length; ++i) {
            obsNames[i] = variableContext.getVariableName(i);
        }
        String filename = "";
        if (productOutputFile != null) {
            filename = productOutputFile.substring(0, productOutputFile.lastIndexOf(".")) + "_";
        }
        filename = filename + "bintrace_" + binIndex + ".csv";
        return new BinTracer(binIndex, obsNames, binManager.getSpatialFeatureNames(), binManager.getTemporalFeatureNames(), binManager.getOutputFeatureNames(), binManager.getPostProcessFeatureNames(), filename);
    }

    private static long getBinIndexToTrace(PlanetaryGrid planetaryGrid) {
        String[] latLon;
        String latLonString = Config.instance().preferences().get(SYSPROP_TRACE_LAT_LON, null);
        if (latLonString != null && latLonString.contains(",") && (latLon = latLonString.split(",")).length == 2) {
            double lat = Double.parseDouble(latLon[0]);
            double lon = Double.parseDouble(latLon[1]);
            long binIndex = planetaryGrid.getBinIndex(lat, lon);
            String msg = String.format("Bin tracing enabled for lat=%s lon=%s binIndex=%d", lat, lon, binIndex);
            SystemUtils.LOG.info(msg);
            return binIndex;
        }
        return -1L;
    }

    private BinTracer(long binIndex, String[] obsNames, String[] spatialFeatureNames, String[] temporalFeatureNames, String[] outputFeatureNames, String[] postFeatureNames, String outputFile) {
        this.binIndex = binIndex;
        this.obsNames = obsNames;
        this.spatialFeatureNames = spatialFeatureNames;
        this.temporalFeatureNames = temporalFeatureNames;
        this.outputFeatureNames = outputFeatureNames;
        this.postFeatureNames = postFeatureNames;
        this.outputFile = outputFile;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    private void ensureOutputOpen() {
        if (this.out == null) {
            try {
                this.out = new PrintStream(new FileOutputStream(this.outputFile), true);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                this.out = System.out;
            }
        }
    }

    private void printHeaderSpatial() {
        this.out.println();
        this.out.println("spatial aggregation");
        this.out.println();
        this.out.print(",obs");
        this.printCategory("obs", this.obsNames.length);
        this.printCategory("spatial", this.spatialFeatureNames.length);
        this.out.println();
        this.out.print("action,productName");
        this.printHeads(this.obsNames);
        this.printHeads(this.spatialFeatureNames);
        this.out.println();
    }

    private void printHeaderTemporal() {
        this.out.println();
        this.out.println("temporal aggregation");
        this.out.println();
        this.printCategory("spatial", this.spatialFeatureNames.length);
        this.printCategory("temporal", this.temporalFeatureNames.length);
        this.out.println();
        this.out.print("action");
        this.printHeads(this.spatialFeatureNames);
        this.printHeads(this.temporalFeatureNames);
        this.out.println();
    }

    public void traceSpatial(String action, Observation observation, SpatialBin spatialBin) {
        this.ensureOutputOpen();
        if (!this.spatialHeaderWritten) {
            this.printHeaderSpatial();
            this.spatialHeaderWritten = true;
        }
        this.out.print(action + "," + this.productName);
        if (observation != null) {
            this.printVector(observation);
        } else {
            this.printEmtpy(this.obsNames.length);
        }
        this.printBin(spatialBin, this.spatialFeatureNames);
        this.out.println();
    }

    public void traceTemporal(String action, SpatialBin spatialBin, TemporalBin temporalBin) {
        this.ensureOutputOpen();
        if (!this.temporalHeaderWritten) {
            this.printHeaderTemporal();
            this.temporalHeaderWritten = true;
        }
        this.out.print(action);
        this.printBin(spatialBin, this.spatialFeatureNames);
        this.printBin(temporalBin, this.temporalFeatureNames);
        this.out.println();
    }

    public void traceOutput(TemporalBin temporalBin, Vector outputVector) {
        this.ensureOutputOpen();
        this.out.println();
        this.out.println("output computation");
        this.out.println();
        this.printHeads(this.temporalFeatureNames);
        this.out.println();
        this.out.print("temporal");
        this.printBin(temporalBin, this.temporalFeatureNames);
        this.out.println();
        this.printHeads(this.outputFeatureNames);
        this.out.println();
        this.out.print("output");
        this.printVector(outputVector);
        this.out.println();
    }

    public void tracePost(TemporalBin temporalBin, TemporalBin processBin) {
        this.ensureOutputOpen();
        this.out.println();
        this.out.println("post processing");
        this.out.println();
        this.printHeads(this.outputFeatureNames);
        this.out.println();
        this.out.print("output");
        this.printBin(temporalBin, this.outputFeatureNames);
        this.out.println();
        this.printHeads(this.postFeatureNames);
        this.out.println();
        this.out.print("processed");
        this.printBin(processBin, this.postFeatureNames);
        this.out.println();
    }

    private void printCategory(String cat, int length) {
        for (int i = 0; i < length; ++i) {
            this.out.print("," + cat);
        }
    }

    private void printHeads(String[] names) {
        for (String name : names) {
            this.out.print("," + name);
        }
    }

    private void printBin(Bin bin, String[] featureNames) {
        if (bin != null) {
            float[] featureValues;
            for (float value : featureValues = bin.getFeatureValues()) {
                this.out.print("," + value);
            }
        } else {
            this.printEmtpy(featureNames.length);
        }
    }

    private void printEmtpy(int length) {
        for (int i = 0; i < length; ++i) {
            this.out.print(",");
        }
    }

    private void printVector(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.out.print("," + vector.get(i));
        }
    }
}

