/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning;

import java.util.HashMap;
import org.esa.snap.binning.BinContext;
import org.esa.snap.binning.WritableVector;
import org.esa.snap.binning.support.VectorImpl;

public abstract class Bin
implements BinContext {
    long index;
    int numObs;
    float[] featureValues;
    private transient HashMap<String, Object> contextMap;

    public Bin() {
        this.index = -1L;
    }

    public Bin(long index, int numFeatures) {
        this.index = index;
        this.setNumFeatures(numFeatures);
    }

    @Override
    public long getIndex() {
        return this.index;
    }

    public void setIndex(long index) {
        this.index = index;
    }

    public int getNumObs() {
        return this.numObs;
    }

    public void setNumObs(int numObs) {
        this.numObs = numObs;
    }

    public float[] getFeatureValues() {
        return this.featureValues;
    }

    public void setNumFeatures(int numFeatures) {
        if (numFeatures < 0) {
            throw new IllegalArgumentException("numFeatures < 0");
        }
        this.featureValues = new float[numFeatures];
    }

    public WritableVector toVector() {
        return new VectorImpl(this.getFeatureValues());
    }

    @Override
    public <T> T get(String name) {
        return (T)(this.contextMap != null ? this.contextMap.get(name) : null);
    }

    @Override
    public void put(String name, Object value) {
        if (this.contextMap == null) {
            this.contextMap = new HashMap();
        }
        this.contextMap.put(name, value);
    }
}

