/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.support;

import org.esa.snap.binning.DataPeriod;

public class SpatialDataPeriod
implements DataPeriod {
    private static final double SLOPE = -0.06666666666666667;
    private static final double EPS = 2.7777777777777776E-7;
    private final double startTime;
    private final double duration;
    private final double minDataHour;

    public SpatialDataPeriod(double startTime, double duration, double minDataHour) {
        this.startTime = startTime;
        this.duration = duration;
        this.minDataHour = minDataHour;
    }

    @Override
    public DataPeriod.Membership getObservationMembership(double lon, double time) {
        double h = 24.0 * (time - this.startTime);
        double h0 = this.minDataHour + (lon + 180.0) * -0.06666666666666667;
        if (h - 2.7777777777777776E-7 < h0) {
            return DataPeriod.Membership.PREVIOUS_PERIODS;
        }
        if (h + 2.7777777777777776E-7 > h0 + 24.0 * this.duration) {
            return DataPeriod.Membership.SUBSEQUENT_PERIODS;
        }
        return DataPeriod.Membership.CURRENT_PERIOD;
    }
}

