/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.snap.binning.BinningContext;
import org.esa.snap.binning.CompositingType;
import org.esa.snap.binning.ObservationSlice;
import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.binning.SpatialBinner;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.binning.support.BinTracer;
import org.esa.snap.binning.support.PlateCarreeGrid;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.util.StopWatch;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.runtime.Config;

public class SpatialProductBinner {
    private static final String PROPERTY_KEY_SLICE_HEIGHT = "snap.binning.sliceHeight";
    private static final String BINNING_MASK_NAME = "_binning_mask";

    public static long processProduct(Product product, SpatialBinner spatialBinner, Map<Product, List<Band>> addedVariableBands, ProgressMonitor progressMonitor) throws IOException {
        Rectangle[] sliceRectangles;
        MultiLevelImage maskImage;
        if (product.getSceneGeoCoding() == null) {
            throw new IllegalArgumentException("product.getGeoCoding() == null");
        }
        BinningContext binningContext = spatialBinner.getBinningContext();
        VariableContext variableContext = binningContext.getVariableContext();
        SpatialProductBinner.addVariablesToProduct(variableContext, product, addedVariableBands);
        PlanetaryGrid planetaryGrid = binningContext.getPlanetaryGrid();
        CompositingType compositingType = binningContext.getCompositingType();
        Geometry sourceProductGeometry = null;
        if (CompositingType.MOSAICKING.equals((Object)compositingType)) {
            SpatialProductBinner.addMaskToProduct(variableContext.getValidMaskExpression(), product, addedVariableBands);
            PlateCarreeGrid plateCarreeGrid = (PlateCarreeGrid)planetaryGrid;
            sourceProductGeometry = plateCarreeGrid.computeProductGeometry(product);
            product = plateCarreeGrid.reprojectToPlateCareeGrid(product);
            maskImage = product.getBand(BINNING_MASK_NAME).getGeophysicalImage();
        } else {
            maskImage = SpatialProductBinner.getMaskImage(product, variableContext.getValidMaskExpression());
        }
        MultiLevelImage[] varImages = SpatialProductBinner.getVariableImages(product, variableContext);
        if (CompositingType.MOSAICKING.equals((Object)compositingType)) {
            PlateCarreeGrid plateCarreeGrid = (PlateCarreeGrid)planetaryGrid;
            Dimension tileSize = product.getPreferredTileSize();
            sliceRectangles = plateCarreeGrid.getDataSliceRectangles(sourceProductGeometry, tileSize);
        } else {
            Dimension defaultSliceDimension = SpatialProductBinner.computeDefaultSliceDimension(product);
            sliceRectangles = SpatialProductBinner.computeDataSliceRectangles(maskImage, varImages, defaultSliceDimension);
        }
        float[] superSamplingSteps = SpatialProductBinner.getSuperSamplingSteps(binningContext.getSuperSampling());
        long numObsTotal = 0L;
        String productName = product.getName();
        BinTracer binTracer = spatialBinner.getBinningContext().getBinManager().getBinTracer();
        if (binTracer != null) {
            binTracer.setProductName(productName);
        }
        progressMonitor.beginTask("Spatially binning of " + productName, sliceRectangles.length);
        Logger logger = SystemUtils.LOG;
        for (int idx = 0; idx < sliceRectangles.length; ++idx) {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            numObsTotal += SpatialProductBinner.processSlice(spatialBinner, progressMonitor, superSamplingSteps, maskImage, varImages, product, sliceRectangles[idx]);
            String label = String.format("Processed slice %d of %d : ", idx + 1, sliceRectangles.length);
            stopWatch.stop();
            logger.info(label + stopWatch.getTimeDiffString());
        }
        spatialBinner.complete();
        return numObsTotal;
    }

    private static MultiLevelImage[] getVariableImages(Product product, VariableContext variableContext) throws OperatorException {
        MultiLevelImage[] varImages = new MultiLevelImage[variableContext.getVariableCount()];
        for (int i = 0; i < variableContext.getVariableCount(); ++i) {
            String nodeName = variableContext.getVariableName(i);
            RasterDataNode rasterDataNode = SpatialProductBinner.getRasterDataNode(product, nodeName);
            varImages[i] = ImageManager.createMaskedGeophysicalImage((RasterDataNode)rasterDataNode, (Number)Float.valueOf(Float.NaN));
        }
        if (varImages.length > 1) {
            MultiLevelImage varImage0 = varImages[0];
            for (MultiLevelImage image : varImages) {
                if (varImage0.getWidth() == image.getWidth() || varImage0.getHeight() == image.getHeight()) continue;
                throw new OperatorException("Some source rasters have different size.\nConsider resampling source products to same size first.");
            }
        }
        return varImages;
    }

    private static MultiLevelImage getMaskImage(Product product, String maskExpr) {
        MultiLevelImage maskImage = null;
        if (StringUtils.isNotNullAndNotEmpty((String)maskExpr)) {
            maskImage = product.getMaskImage(maskExpr, null);
        }
        return maskImage;
    }

    private static Rectangle[] computeDataSliceRectangles(MultiLevelImage maskImage, MultiLevelImage[] varImages, Dimension defaultSliceSize) {
        Rectangle[] rectangles;
        MultiLevelImage referenceImage = varImages[0];
        if (SpatialProductBinner.areTilesDirectlyUsable(maskImage, varImages, defaultSliceSize)) {
            Point[] tileIndices = referenceImage.getTileIndices(null);
            rectangles = new Rectangle[tileIndices.length];
            for (int i = 0; i < tileIndices.length; ++i) {
                Point tileIndex = tileIndices[i];
                rectangles[i] = referenceImage.getTileRect(tileIndex.x, tileIndex.y);
            }
        } else {
            int sceneHeight = referenceImage.getHeight();
            int numSlices = MathUtils.ceilInt((double)((double)sceneHeight / (double)defaultSliceSize.height));
            rectangles = new Rectangle[numSlices];
            for (int i = 0; i < numSlices; ++i) {
                rectangles[i] = SpatialProductBinner.computeCurrentSliceRectangle(defaultSliceSize, i, sceneHeight);
            }
        }
        return rectangles;
    }

    private static boolean areTilesDirectlyUsable(MultiLevelImage maskImage, MultiLevelImage[] varImages, Dimension defaultSliceSize) {
        boolean areTilesUsable = false;
        if (maskImage != null) {
            areTilesUsable = SpatialProductBinner.isTileSizeCompatible(maskImage, defaultSliceSize);
        }
        for (MultiLevelImage varImage : varImages) {
            areTilesUsable = areTilesUsable && SpatialProductBinner.isTileSizeCompatible(varImage, defaultSliceSize);
        }
        return areTilesUsable;
    }

    private static boolean isTileSizeCompatible(MultiLevelImage image, Dimension defaultSliceSize) {
        return image.getTileWidth() == defaultSliceSize.width && image.getTileHeight() == defaultSliceSize.height;
    }

    private static Rectangle computeCurrentSliceRectangle(Dimension defaultSlice, int sliceIndex, int sceneHeight) {
        int sliceY = sliceIndex * defaultSlice.height;
        int currentSliceHeight = defaultSlice.height;
        if (sliceY + defaultSlice.height > sceneHeight) {
            currentSliceHeight = sceneHeight - sliceY;
        }
        return new Rectangle(0, sliceIndex * defaultSlice.height, defaultSlice.width, currentSliceHeight);
    }

    private static long processSlice(SpatialBinner spatialBinner, ProgressMonitor progressMonitor, float[] superSamplingSteps, MultiLevelImage maskImage, MultiLevelImage[] varImages, Product product, Rectangle sliceRect) {
        ObservationSlice observationSlice = new ObservationSlice(varImages, maskImage, product, superSamplingSteps, sliceRect, spatialBinner.getBinningContext());
        long numObservations = spatialBinner.processObservationSlice(observationSlice);
        progressMonitor.worked(1);
        return numObservations;
    }

    private static Dimension computeDefaultSliceDimension(Product product) {
        int sliceWidth = product.getSceneRasterWidth();
        Dimension preferredTileSize = product.getPreferredTileSize();
        int sliceHeight = preferredTileSize != null ? preferredTileSize.height : ImageManager.getPreferredTileSize((Product)product).height;
        sliceHeight = Config.instance().preferences().getInt(PROPERTY_KEY_SLICE_HEIGHT, sliceHeight);
        Dimension dimension = new Dimension(sliceWidth, sliceHeight);
        String logMsg = String.format("Using slice dimension [width=%d, height=%d] in binning", dimension.width, dimension.height);
        SystemUtils.LOG.log(Level.INFO, logMsg);
        return dimension;
    }

    private static void addVariablesToProduct(VariableContext variableContext, Product product, Map<Product, List<Band>> addedVariableBands) {
        for (int i = 0; i < variableContext.getVariableCount(); ++i) {
            String variableName = variableContext.getVariableName(i);
            String variableExpr = variableContext.getVariableExpression(i);
            String validMaskExpression = variableContext.getValidMaskExpression();
            if (variableExpr == null) continue;
            VirtualBand band = new VirtualBand(variableName, 30, product.getSceneRasterWidth(), product.getSceneRasterHeight(), variableExpr);
            try {
                validMaskExpression = BandArithmetic.getValidMaskExpression((String)variableExpr, (Product)product, (String)validMaskExpression);
            }
            catch (ParseException e) {
                throw new OperatorException("Failed to parse valid-mask expression: " + e.getMessage(), (Throwable)e);
            }
            if (StringUtils.isNotNullAndNotEmpty((String)validMaskExpression)) {
                band.setValidPixelExpression(validMaskExpression);
            }
            product.addBand((Band)band);
            if (!addedVariableBands.containsKey(product)) {
                addedVariableBands.put(product, new ArrayList());
            }
            addedVariableBands.get(product).add((Band)band);
        }
    }

    private static void addMaskToProduct(String maskExpr, Product product, Map<Product, List<Band>> addedBands) {
        VirtualBand band = new VirtualBand(BINNING_MASK_NAME, 20, product.getSceneRasterWidth(), product.getSceneRasterHeight(), StringUtils.isNotNullAndNotEmpty((String)maskExpr) ? maskExpr : "true");
        product.addBand((Band)band);
        if (!addedBands.containsKey(product)) {
            addedBands.put(product, new ArrayList());
        }
        addedBands.get(product).add((Band)band);
    }

    static float[] getSuperSamplingSteps(Integer superSampling) {
        if (superSampling == null || superSampling <= 1) {
            return new float[]{0.5f};
        }
        float[] samplingStep = new float[superSampling.intValue()];
        for (int i = 0; i < samplingStep.length; ++i) {
            samplingStep[i] = ((float)i * 2.0f + 1.0f) / (2.0f * (float)superSampling.intValue());
        }
        return samplingStep;
    }

    private static RasterDataNode getRasterDataNode(Product product, String nodeName) {
        RasterDataNode node = product.getRasterDataNode(nodeName);
        if (node == null) {
            throw new IllegalStateException(String.format("Can't find raster data node '%s' in product '%s'", nodeName, product.getName()));
        }
        return node;
    }
}

