/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.reader;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.binning.reader.AbstractGridAccessor;
import org.esa.snap.binning.reader.VariableReader;
import org.esa.snap.core.datamodel.Band;
import ucar.ma2.Array;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

class SparseGridAccessor
extends AbstractGridAccessor {
    private final NetcdfFile netcdfFile;
    private final int[] binIndexes;
    private final int[] binOffsets;
    private final int[] binExtents;
    private final Map<Integer, Integer> indexMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SparseGridAccessor(NetcdfFile netcdfFile) throws IOException {
        this.netcdfFile = netcdfFile;
        Variable bl_bin_num = netcdfFile.findVariable("bl_bin_num");
        Variable bi_begin = netcdfFile.findVariable("bi_begin");
        Variable bi_extent = netcdfFile.findVariable("bi_extent");
        NetcdfFile netcdfFile2 = this.netcdfFile;
        synchronized (netcdfFile2) {
            Object storage = bl_bin_num.read().getStorage();
            this.binIndexes = (int[])storage;
            this.indexMap = new HashMap<Integer, Integer>(this.binIndexes.length);
            for (int i = 0; i < this.binIndexes.length; ++i) {
                this.indexMap.put(this.binIndexes[i], i);
            }
            this.binOffsets = (int[])bi_begin.read().getStorage();
            this.binExtents = (int[])bi_extent.read().getStorage();
        }
    }

    @Override
    void dispose() {
        this.indexMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Array getLineValues(Band destBand, VariableReader variableReader, int lineIndex) throws IOException {
        Array lineValues = null;
        int binOffset = this.binOffsets[lineIndex];
        if (binOffset > 0) {
            int firstIndex = this.indexMap.get(binOffset);
            int length = this.binExtents[lineIndex];
            NetcdfFile netcdfFile = this.netcdfFile;
            synchronized (netcdfFile) {
                lineValues = variableReader.read(firstIndex, length);
            }
        }
        return lineValues;
    }

    @Override
    int getStartBinIndex(int sourceOffsetX, int lineIndex) {
        return 0;
    }

    @Override
    int getEndBinIndex(int sourceOffsetX, int sourceWidth, int lineIndex) {
        return this.binExtents[lineIndex];
    }

    @Override
    int getBinIndexInGrid(int binIndex, int lineIndex) {
        int binOffset = this.binOffsets[lineIndex];
        return this.binIndexes[this.indexMap.get(binOffset) + binIndex];
    }
}

