/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator.metadata;

import org.esa.snap.binning.operator.metadata.AbstractMetadataAggregator;
import org.esa.snap.binning.operator.metadata.Utilities;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.StringUtils;

class AllHistoriesMetaAggregator
extends AbstractMetadataAggregator {
    AllHistoriesMetaAggregator() {
    }

    @Override
    public void aggregateMetadata(Product product) {
        String productName = Utilities.extractProductName(product);
        MetadataElement processingGraphElement = Utilities.getProcessingGraphElement(product);
        this.aggregate(productName, processingGraphElement);
    }

    @Override
    public void aggregateMetadata(MetadataElement processingGraphElement) {
        String productName = Utilities.extractProductName(processingGraphElement);
        if (StringUtils.isNullOrEmpty((String)productName)) {
            productName = "unknown";
        }
        this.aggregate(productName, processingGraphElement);
    }

    @Override
    public MetadataElement getMetadata() {
        return this.inputsMetaElement;
    }

    private void aggregate(String productName, MetadataElement processingGraphElement) {
        MetadataElement productElement = Utilities.createSourceMetaElement(productName, this.aggregatedCount);
        if (processingGraphElement != null) {
            productElement.addElement(processingGraphElement.createDeepClone());
        }
        this.inputsMetaElement.addElementAt(productElement, this.aggregatedCount);
        ++this.aggregatedCount;
    }
}

