/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.esa.snap.binning.BinManager;
import org.esa.snap.binning.BinningContext;
import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.binning.TemporalBin;
import org.esa.snap.binning.operator.AbstractBinWriter;
import org.esa.snap.core.datamodel.ProductData;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;

class FullyPopulatedBinWriter
extends AbstractBinWriter {
    private static final int BUFFER_SIZE = 4096;
    private BinningContext binningContext;
    private PlanetaryGrid planetaryGrid;

    public FullyPopulatedBinWriter(Geometry region, ProductData.UTC startTime, ProductData.UTC stopTime) {
        super(region, startTime, stopTime);
    }

    @Override
    public void setBinningContext(BinningContext binningContext) {
        this.binningContext = binningContext;
        this.planetaryGrid = binningContext.getPlanetaryGrid();
    }

    @Override
    public void write(Map<String, String> metadataProperties, List<TemporalBin> temporalBins) throws IOException {
        NetcdfFileWriteable netcdfFile = NetcdfFileWriteable.createNew((String)this.getTargetFilePath());
        netcdfFile.setLargeFile(true);
        netcdfFile.addGlobalAttribute("title", "Level-3 Binned Data");
        netcdfFile.addGlobalAttribute("super_sampling", (Number)this.binningContext.getSuperSampling());
        if (this.getRegion() != null) {
            netcdfFile.addGlobalAttribute("region", this.getRegion().toText());
        }
        this.writeGlobalTimeCoverageMetadata(netcdfFile);
        this.writeGlobalCommonMetadata(metadataProperties, netcdfFile);
        this.writeGlobalSEAGridMetadata(netcdfFile, this.planetaryGrid.getNumRows());
        Dimension binIndexDim = netcdfFile.addDimension("bin_index", this.planetaryGrid.getNumRows());
        long numBinsLong = this.planetaryGrid.getNumBins();
        if (numBinsLong > Integer.MAX_VALUE) {
            throw new IOException("Num_bins exceeds MAX_INT. Can not be written as fully populated grid.");
        }
        Dimension binListDim = netcdfFile.addDimension("bin_list", (int)numBinsLong);
        Variable numObsVar = netcdfFile.addVariable("bl_nobs", DataType.INT, new Dimension[]{binListDim});
        Variable numScenesVar = netcdfFile.addVariable("bl_nscenes", DataType.INT, new Dimension[]{binListDim});
        Variable longitude = netcdfFile.addVariable("longitude", DataType.FLOAT, new Dimension[]{binListDim});
        longitude.addAttribute(new Attribute("units", "degrees_east"));
        Variable latitude = netcdfFile.addVariable("latitude", DataType.FLOAT, new Dimension[]{binListDim});
        latitude.addAttribute(new Attribute("units", "degrees_north"));
        BinManager binManager = this.binningContext.getBinManager();
        String[] resultFeatureNames = binManager.getResultFeatureNames();
        ArrayList<Variable> featureVars = new ArrayList<Variable>(resultFeatureNames.length);
        for (String featureName : resultFeatureNames) {
            Variable featureVar = netcdfFile.addVariable(featureName, DataType.FLOAT, new Dimension[]{binListDim});
            featureVar.addAttribute(new Attribute("_FillValue", (Number)Float.valueOf(Float.NaN)));
            featureVars.add(featureVar);
        }
        netcdfFile.create();
        try {
            this.writeBinListVariables(netcdfFile, numObsVar, numScenesVar, latitude, longitude, featureVars, temporalBins);
        }
        catch (InvalidRangeException e) {
            throw new IOException(e);
        }
        finally {
            netcdfFile.close();
        }
    }

    private void writeBinListVariables(NetcdfFileWriteable netcdfFile, Variable numObsVar, Variable numScenesVar, Variable latitude, Variable longitude, List<Variable> featureVars, List<TemporalBin> temporalBins) throws IOException, InvalidRangeException {
        ArrayList<AbstractBinWriter.BinListVar> binListVars = new ArrayList<AbstractBinWriter.BinListVar>();
        binListVars.add(new AbstractBinWriter.BinListVar(numObsVar, new AbstractBinWriter.BinListElementSetter(){

            @Override
            public void setArray(Array array, int binIndex, TemporalBin bin) {
                array.setInt(binIndex, bin.getNumObs());
            }
        }));
        binListVars.add(new AbstractBinWriter.BinListVar(numScenesVar, new AbstractBinWriter.BinListElementSetter(){

            @Override
            public void setArray(Array array, int binIndex, TemporalBin bin) {
                array.setInt(binIndex, bin.getNumPasses());
            }
        }));
        binListVars.add(new AbstractBinWriter.BinListVar(latitude, new AbstractBinWriter.BinListElementSetter(){

            @Override
            public void setArray(Array array, int binIndex, TemporalBin bin) {
                float centerLat = (float)FullyPopulatedBinWriter.this.planetaryGrid.getCenterLat(FullyPopulatedBinWriter.this.planetaryGrid.getRowIndex(bin.getIndex()));
                array.setFloat(binIndex, centerLat);
            }
        }));
        binListVars.add(new AbstractBinWriter.BinListVar(longitude, new AbstractBinWriter.BinListElementSetter(){

            @Override
            public void setArray(Array array, int binIndex, TemporalBin bin) {
                double[] centerLatLon = FullyPopulatedBinWriter.this.planetaryGrid.getCenterLatLon(bin.getIndex());
                array.setFloat(binIndex, (float)centerLatLon[1]);
            }
        }));
        int featureIndex = 0;
        while (featureIndex < featureVars.size()) {
            final int k = featureIndex++;
            binListVars.add(new AbstractBinWriter.BinListVar(featureVars.get(k), new AbstractBinWriter.BinListElementSetter(){

                @Override
                public void setArray(Array array, int binIndex, TemporalBin bin) {
                    if (bin.getFeatureValues().length == 0) {
                        array.setFloat(binIndex, Float.NaN);
                    } else {
                        array.setFloat(binIndex, bin.getFeatureValues()[k]);
                    }
                }
            }));
        }
        this.writeBinListVariable(netcdfFile, temporalBins, binListVars);
    }

    private void writeBinListVariable(NetcdfFileWriteable netcdfFile, List<TemporalBin> temporalBins, List<AbstractBinWriter.BinListVar> vars) throws IOException, InvalidRangeException {
        this.getLogger().info("Writing bin list variables");
        int[] origin = new int[1];
        int bufferIndex = 0;
        int lastRowIndex = -1;
        int rowIndex = -1;
        ArrayList<TemporalBin> rowBins = new ArrayList<TemporalBin>(2 * this.planetaryGrid.getNumRows());
        int binListIndex = temporalBins.size() - 1;
        TemporalBin temporalBin = null;
        TemporalBin emptyBin = new TemporalBin(0L, 0);
        int id = -1;
        boolean numFeatures = false;
        for (int globalIndex = (int)(this.planetaryGrid.getNumBins() - 1L); globalIndex >= 0; --globalIndex) {
            if (temporalBin == null && binListIndex >= 0) {
                temporalBin = temporalBins.get(binListIndex--);
                id = (int)temporalBin.getIndex();
            }
            if ((rowIndex = this.planetaryGrid.getRowIndex(globalIndex)) == lastRowIndex) {
                if (id == globalIndex) {
                    rowBins.add(temporalBin);
                    temporalBin = null;
                    id = -1;
                    continue;
                }
                rowBins.add(emptyBin);
                continue;
            }
            bufferIndex = this.writeRowBins(netcdfFile, rowBins, vars, origin, bufferIndex);
            rowBins.clear();
            if (id == globalIndex) {
                rowBins.add(temporalBin);
                temporalBin = null;
                id = -1;
            } else {
                rowBins.add(emptyBin);
            }
            lastRowIndex = rowIndex;
        }
        if ((bufferIndex = this.writeRowBins(netcdfFile, rowBins, vars, origin, bufferIndex)) > 0) {
            FullyPopulatedBinWriter.writeBinListVars(netcdfFile, vars, origin, bufferIndex);
        }
    }

    private int writeRowBins(NetcdfFileWriteable netcdfFile, ArrayList<TemporalBin> rowBins, List<AbstractBinWriter.BinListVar> vars, int[] origin, int bufferIndex) throws IOException, InvalidRangeException {
        Collections.reverse(rowBins);
        for (TemporalBin rowBin : rowBins) {
            if (bufferIndex == 4096) {
                FullyPopulatedBinWriter.writeBinListVars(netcdfFile, vars, origin);
                bufferIndex = 0;
                origin[0] = origin[0] + 4096;
            }
            FullyPopulatedBinWriter.setBinListVarsArrayElement(vars, rowBin, bufferIndex);
            ++bufferIndex;
        }
        return bufferIndex;
    }
}

