/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.support;

import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.binning.support.SEAGrid;
import org.esa.snap.binning.support.SeadasGrid;
import org.junit.Assert;
import org.junit.Test;

public class SeadasGridTest {
    @Test
    public void testConstructorRejectsTooLargeBaseGrids() {
        new SeadasGrid((PlanetaryGrid)new SEAGrid(41068));
        try {
            new SeadasGrid((PlanetaryGrid)new SEAGrid(41070));
            Assert.fail((String)"IAE expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Base grid has more than 2147483646 bins", (Object)e.getMessage());
        }
    }

    @Test
    public void testConvertCalvalusToSeadasBinIndex() {
        SEAGrid baseGrid = new SEAGrid(6);
        Assert.assertEquals((long)0L, (long)baseGrid.getFirstBinIndex(0));
        Assert.assertEquals((long)3L, (long)baseGrid.getFirstBinIndex(1));
        Assert.assertEquals((long)11L, (long)baseGrid.getFirstBinIndex(2));
        Assert.assertEquals((long)23L, (long)baseGrid.getFirstBinIndex(3));
        Assert.assertEquals((long)35L, (long)baseGrid.getFirstBinIndex(4));
        Assert.assertEquals((long)43L, (long)baseGrid.getFirstBinIndex(5));
        Assert.assertEquals((long)46L, (long)baseGrid.getNumBins());
        SeadasGrid seadasGrid = new SeadasGrid((PlanetaryGrid)baseGrid);
        Assert.assertEquals((long)44L, (long)seadasGrid.convertBinIndex(0L));
        Assert.assertEquals((long)46L, (long)seadasGrid.convertBinIndex(2L));
        Assert.assertEquals((long)36L, (long)seadasGrid.convertBinIndex(3L));
        Assert.assertEquals((long)43L, (long)seadasGrid.convertBinIndex(10L));
        Assert.assertEquals((long)24L, (long)seadasGrid.convertBinIndex(11L));
        Assert.assertEquals((long)35L, (long)seadasGrid.convertBinIndex(22L));
        Assert.assertEquals((long)12L, (long)seadasGrid.convertBinIndex(23L));
        Assert.assertEquals((long)23L, (long)seadasGrid.convertBinIndex(34L));
        Assert.assertEquals((long)4L, (long)seadasGrid.convertBinIndex(35L));
        Assert.assertEquals((long)11L, (long)seadasGrid.convertBinIndex(42L));
        Assert.assertEquals((long)1L, (long)seadasGrid.convertBinIndex(43L));
        Assert.assertEquals((long)3L, (long)seadasGrid.convertBinIndex(45L));
        Assert.assertEquals((long)0L, (long)seadasGrid.reverseBinIndex(44L));
        Assert.assertEquals((long)2L, (long)seadasGrid.reverseBinIndex(46L));
        Assert.assertEquals((long)3L, (long)seadasGrid.reverseBinIndex(36L));
        Assert.assertEquals((long)10L, (long)seadasGrid.reverseBinIndex(43L));
        Assert.assertEquals((long)11L, (long)seadasGrid.reverseBinIndex(24L));
        Assert.assertEquals((long)22L, (long)seadasGrid.reverseBinIndex(35L));
        Assert.assertEquals((long)23L, (long)seadasGrid.reverseBinIndex(12L));
        Assert.assertEquals((long)34L, (long)seadasGrid.reverseBinIndex(23L));
        Assert.assertEquals((long)35L, (long)seadasGrid.reverseBinIndex(4L));
        Assert.assertEquals((long)42L, (long)seadasGrid.reverseBinIndex(11L));
        Assert.assertEquals((long)43L, (long)seadasGrid.reverseBinIndex(1L));
        Assert.assertEquals((long)45L, (long)seadasGrid.reverseBinIndex(3L));
        Assert.assertEquals((long)5L, (long)seadasGrid.convertRowIndex(0));
        Assert.assertEquals((long)4L, (long)seadasGrid.convertRowIndex(1));
        Assert.assertEquals((long)3L, (long)seadasGrid.convertRowIndex(2));
        Assert.assertEquals((long)2L, (long)seadasGrid.convertRowIndex(3));
        Assert.assertEquals((long)1L, (long)seadasGrid.convertRowIndex(4));
        Assert.assertEquals((long)0L, (long)seadasGrid.convertRowIndex(5));
    }
}

