/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.support;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;

public class RegionPerformanceTest {
    public static void main(String[] args) throws IOException, ParseException {
        Point point;
        int x;
        int y;
        Geometry envelope;
        String productFile = args[0];
        String wktFile = args[1];
        Product product = ProductIO.readProduct((String)productFile);
        GeometryFactory geometryFactory = new GeometryFactory();
        WKTReader wktReader = new WKTReader(geometryFactory);
        Geometry geometry = wktReader.read((Reader)new FileReader(wktFile));
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            int length = polygon.getCoordinates().length;
            System.out.println("geometry.coordinates.length = " + length);
        }
        if ((envelope = geometry.getEnvelope()) instanceof Polygon) {
            Polygon polygon = (Polygon)envelope;
            int length = polygon.getCoordinates().length;
            System.out.println("envelope.coordinates.length = " + length);
        }
        System.out.println("envelope.wkt = " + envelope);
        System.out.println();
        int width = product.getSceneRasterWidth();
        int height = product.getSceneRasterHeight();
        System.out.println("num product pixels = " + height * width);
        GeoCoding geoCoding = product.getSceneGeoCoding();
        GeoPos geoPos = new GeoPos();
        PixelPos pixelPos = new PixelPos();
        PreparedGeometry preparedGeometry = PreparedGeometryFactory.prepare((Geometry)geometry);
        System.out.println();
        int matches = 0;
        long t1 = System.currentTimeMillis();
        for (y = 0; y < height; ++y) {
            pixelPos.y = (float)y + 0.5f;
            for (x = 0; x < width; ++x) {
                pixelPos.x = (float)x + 0.5f;
                geoCoding.getGeoPos(pixelPos, geoPos);
                point = geometryFactory.createPoint(new Coordinate(geoPos.lon, geoPos.lat));
                if (!envelope.contains((Geometry)point)) continue;
                ++matches;
            }
        }
        long t2 = System.currentTimeMillis();
        System.out.println("envelope matches = " + matches);
        System.out.println("envelope times   = " + (t2 - t1));
        System.out.println();
        matches = 0;
        t1 = System.currentTimeMillis();
        for (y = 0; y < height; ++y) {
            pixelPos.y = (float)y + 0.5f;
            for (x = 0; x < width; ++x) {
                pixelPos.x = (float)x + 0.5f;
                geoCoding.getGeoPos(pixelPos, geoPos);
                point = geometryFactory.createPoint(new Coordinate(geoPos.lon, geoPos.lat));
                if (!preparedGeometry.contains((Geometry)point)) continue;
                ++matches;
            }
        }
        t2 = System.currentTimeMillis();
        System.out.println("prepared geometry matches = " + matches);
        System.out.println("prepared geometry times   = " + (t2 - t1));
        System.out.println();
        matches = 0;
        t1 = System.currentTimeMillis();
        for (y = 0; y < height; ++y) {
            pixelPos.y = (float)y + 0.5f;
            for (x = 0; x < width; ++x) {
                pixelPos.x = (float)x + 0.5f;
                geoCoding.getGeoPos(pixelPos, geoPos);
                point = geometryFactory.createPoint(new Coordinate(geoPos.lon, geoPos.lat));
                if (!preparedGeometry.containsProperly((Geometry)point)) continue;
                ++matches;
            }
        }
        t2 = System.currentTimeMillis();
        System.out.println("prepared geometry properly matches = " + matches);
        System.out.println("prepared geometry properly times   = " + (t2 - t1));
        System.out.println();
        matches = 0;
        t1 = System.currentTimeMillis();
        for (y = 0; y < height; ++y) {
            pixelPos.y = (float)y + 0.5f;
            for (x = 0; x < width; ++x) {
                pixelPos.x = (float)x + 0.5f;
                geoCoding.getGeoPos(pixelPos, geoPos);
                point = geometryFactory.createPoint(new Coordinate(geoPos.lon, geoPos.lat));
                if (point == null) continue;
                ++matches;
            }
        }
        t2 = System.currentTimeMillis();
        System.out.println("NOOP matches = " + matches);
        System.out.println("NOOP times   = " + (t2 - t1));
        System.out.println();
        matches = 0;
        t1 = System.currentTimeMillis();
        for (y = 0; y < height; y += 10) {
            pixelPos.y = (float)y + 0.5f;
            for (x = 0; x < width; x += 10) {
                pixelPos.x = (float)x + 0.5f;
                geoCoding.getGeoPos(pixelPos, geoPos);
                point = geometryFactory.createPoint(new Coordinate(geoPos.lon, geoPos.lat));
                if (!geometry.contains((Geometry)point)) continue;
                ++matches;
            }
        }
        t2 = System.currentTimeMillis();
        System.out.println("geometry matches = " + matches);
        System.out.println("geometry times   = " + (t2 - t1));
    }
}

