/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.support;

import org.esa.snap.binning.support.GrowableVector;
import org.junit.Assert;
import org.junit.Test;

public class GrowableVectorTest {
    @Test
    public void testGrowth() {
        GrowableVector v = new GrowableVector(2);
        Assert.assertEquals((long)0L, (long)v.size());
        v.add(2.1f);
        v.add(1.9f);
        v.add(3.4f);
        Assert.assertEquals((long)3L, (long)v.size());
        Assert.assertEquals((float)2.1f, (float)v.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)1.9f, (float)v.get(1), (float)1.0E-5f);
        Assert.assertEquals((float)3.4f, (float)v.get(2), (float)1.0E-5f);
        float[] elements = v.getElements();
        Assert.assertNotNull((Object)elements);
        Assert.assertEquals((long)3L, (long)elements.length);
        Assert.assertEquals((float)2.1f, (float)elements[0], (float)1.0E-5f);
        Assert.assertEquals((float)1.9f, (float)elements[1], (float)1.0E-5f);
        Assert.assertEquals((float)3.4f, (float)elements[2], (float)1.0E-5f);
        for (int i = 0; i < 1000; ++i) {
            v.add((float)i * 0.1f);
        }
        Assert.assertEquals((long)1003L, (long)v.size());
        Assert.assertEquals((float)0.0f, (float)v.get(3), (float)1.0E-5f);
        Assert.assertEquals((float)0.1f, (float)v.get(4), (float)1.0E-5f);
        Assert.assertEquals((float)0.2f, (float)v.get(5), (float)1.0E-5f);
        elements = v.getElements();
        Assert.assertNotNull((Object)elements);
        Assert.assertEquals((long)1003L, (long)elements.length);
        Assert.assertEquals((float)0.0f, (float)elements[3], (float)1.0E-5f);
        Assert.assertEquals((float)0.1f, (float)elements[4], (float)1.0E-5f);
        Assert.assertEquals((float)0.2f, (float)elements[5], (float)1.0E-5f);
    }

    @Test
    public void testToString() {
        GrowableVector v = new GrowableVector(2);
        Assert.assertEquals((Object)"[]", (Object)v.toString());
        v.add(2.1f);
        v.add(1.9f);
        v.add(3.4f);
        Assert.assertEquals((Object)"[2.1, 1.9, 3.4]", (Object)v.toString());
    }
}

