/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator.metadata;

import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.junit.Assert;

class TestHelper {
    TestHelper() {
    }

    static void assertCorrectNameAndNoAttributes(MetadataElement metadataElement) {
        Assert.assertNotNull((Object)metadataElement);
        Assert.assertEquals((Object)"sources", (Object)metadataElement.getName());
        Assert.assertEquals((long)0L, (long)metadataElement.getNumAttributes());
    }

    static Product createProduct(int number) {
        return new Product("product_" + Integer.toString(number), "test_type", 2, 2);
    }

    static Product createProductWithProcessingGraph(int number, String ... inputNames) {
        Product product = TestHelper.createProduct(number);
        MetadataElement metadataRoot = product.getMetadataRoot();
        MetadataElement processingGraphElement = new MetadataElement("Processing_Graph");
        if (inputNames != null && inputNames.length > 0) {
            int index = 0;
            for (String inputName : inputNames) {
                MetadataElement nodeElement = new MetadataElement("node." + Integer.toString(index));
                MetadataElement sourcesElement = new MetadataElement("sources");
                sourcesElement.addAttribute(new MetadataAttribute("sourceProduct", ProductData.createInstance((String)inputName), true));
                nodeElement.addElement(sourcesElement);
                processingGraphElement.addElement(nodeElement);
                ++index;
            }
        }
        metadataRoot.addElement(processingGraphElement);
        return product;
    }

    static void assertInputElementAt(int index, MetadataElement metadataElement) {
        TestHelper.assertInputElementAt(index, "product_" + Integer.toString(index + 1), metadataElement);
    }

    static void assertInputElementAt(int index, String inputName, MetadataElement metadataElement) {
        MetadataElement productElement = metadataElement.getElementAt(index);
        Assert.assertEquals((Object)("source." + Integer.toString(index)), (Object)productElement.getName());
        MetadataAttribute nameAttribute = productElement.getAttribute("name");
        Assert.assertNotNull((Object)nameAttribute);
        Assert.assertEquals((Object)inputName, (Object)nameAttribute.getData().getElemString());
    }

    static void assertProductElementWithGraphAt(int index, String inputName, MetadataElement metadataElement) {
        TestHelper.assertInputElementAt(index, inputName, metadataElement);
        Assert.assertNotNull((Object)TestHelper.getProcessingGraphElement(index, metadataElement));
    }

    static void assertProductElementWithoutGraphtAt(int index, String inputName, MetadataElement metadataElement) {
        TestHelper.assertInputElementAt(index, inputName, metadataElement);
        Assert.assertNull((Object)TestHelper.getProcessingGraphElement(index, metadataElement));
    }

    private static MetadataElement getProcessingGraphElement(int index, MetadataElement metadataElement) {
        MetadataElement productElement = metadataElement.getElementAt(index);
        return productElement.getElement("Processing_Graph");
    }
}

