/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import java.text.ParseException;
import org.esa.snap.binning.DataPeriod;
import org.esa.snap.binning.support.SpatialDataPeriod;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.AbstractGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.Scene;
import org.esa.snap.core.dataop.maptransf.Datum;
import org.junit.Assert;

public class TestUtils {
    public static final float EASTERN_LON = 10.0f;
    public static final float WESTERN_LON = 0.0f;
    public static final int SCENE_RASTER_HEIGHT = 347;
    public static double T0;
    public static double H;

    static Product createProduct(DataPeriod dataPeriod, DataPeriod.Membership firstPeriod, DataPeriod.Membership lastPeriod) {
        Product product = new Product("name", "type", 100, 347);
        product.setSceneGeoCoding((GeoCoding)new MockGeoCoding());
        switch (firstPeriod) {
            case PREVIOUS_PERIODS: {
                double productStartTime = T0 - 12.0 * H;
                product.setStartTime(new ProductData.UTC(productStartTime));
                Assert.assertEquals((Object)DataPeriod.Membership.PREVIOUS_PERIODS, (Object)dataPeriod.getObservationMembership(10.0, productStartTime));
                break;
            }
            case CURRENT_PERIOD: {
                double productStartTime = T0 + 15.0 * H;
                product.setStartTime(new ProductData.UTC(productStartTime));
                Assert.assertEquals((Object)DataPeriod.Membership.CURRENT_PERIOD, (Object)dataPeriod.getObservationMembership(10.0, productStartTime));
                break;
            }
            case SUBSEQUENT_PERIODS: {
                double productStartTime = T0 + 35.0 * H;
                product.setStartTime(new ProductData.UTC(productStartTime));
                Assert.assertEquals((Object)DataPeriod.Membership.SUBSEQUENT_PERIODS, (Object)dataPeriod.getObservationMembership(10.0, productStartTime));
                break;
            }
        }
        switch (lastPeriod) {
            case PREVIOUS_PERIODS: {
                double productEndTime = T0 - 12.0 * H;
                product.setEndTime(new ProductData.UTC(productEndTime));
                Assert.assertEquals((Object)DataPeriod.Membership.PREVIOUS_PERIODS, (Object)dataPeriod.getObservationMembership(0.0, productEndTime));
                break;
            }
            case CURRENT_PERIOD: {
                double productEndTime = T0 + 15.0 * H;
                product.setEndTime(new ProductData.UTC(productEndTime));
                Assert.assertEquals((Object)DataPeriod.Membership.CURRENT_PERIOD, (Object)dataPeriod.getObservationMembership(0.0, productEndTime));
                break;
            }
            case SUBSEQUENT_PERIODS: {
                double productEndTime = T0 + 35.0 * H;
                product.setEndTime(new ProductData.UTC(productEndTime));
                Assert.assertEquals((Object)DataPeriod.Membership.SUBSEQUENT_PERIODS, (Object)dataPeriod.getObservationMembership(0.0, productEndTime));
                break;
            }
        }
        return product;
    }

    public static DataPeriod createSpatialDataPeriod() {
        return new SpatialDataPeriod(T0, 1.0, 10.0);
    }

    static {
        H = 0.041666666666666664;
        try {
            T0 = ProductData.UTC.parse((String)"10-Jan-2010 12:00:00").getMJD();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private static class MockGeoCoding
    extends AbstractGeoCoding {
        private MockGeoCoding() {
        }

        public GeoPos getGeoPos(PixelPos pixelPos, GeoPos geoPos) {
            if (pixelPos.y == 0.0) {
                return new GeoPos(10.0, 0.0);
            }
            if (pixelPos.y == 346.0) {
                return new GeoPos(0.0, 0.0);
            }
            throw new IllegalStateException("Unneeded pixel position");
        }

        public boolean transferGeoCoding(Scene srcScene, Scene destScene, ProductSubsetDef subsetDef) {
            throw new IllegalStateException("Not implemented on purpose");
        }

        public boolean isCrossingMeridianAt180() {
            throw new IllegalStateException("Not implemented on purpose");
        }

        public boolean canGetPixelPos() {
            throw new IllegalStateException("Not implemented on purpose");
        }

        public boolean canGetGeoPos() {
            return true;
        }

        public PixelPos getPixelPos(GeoPos geoPos, PixelPos pixelPos) {
            throw new IllegalStateException("Not implemented on purpose");
        }

        public Datum getDatum() {
            throw new IllegalStateException("Not implemented on purpose");
        }

        public void dispose() {
        }
    }
}

