/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import com.bc.ceres.core.ProgressMonitor;
import java.util.HashMap;
import java.util.List;
import org.esa.snap.binning.Aggregator;
import org.esa.snap.binning.BinManager;
import org.esa.snap.binning.BinningContext;
import org.esa.snap.binning.CompositingType;
import org.esa.snap.binning.DataPeriod;
import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.binning.SpatialBin;
import org.esa.snap.binning.SpatialBinConsumer;
import org.esa.snap.binning.SpatialBinner;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.binning.aggregators.AggregatorAverage;
import org.esa.snap.binning.operator.SpatialProductBinner;
import org.esa.snap.binning.support.BinningContextImpl;
import org.esa.snap.binning.support.SEAGrid;
import org.esa.snap.binning.support.VariableContextImpl;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.junit.Assert;
import org.junit.Test;

public class SpatialProductBinnerTest {
    @Test
    public void testThatProductMustHaveAGeoCoding() throws Exception {
        BinningContext ctx = SpatialProductBinnerTest.createValidCtx(1, null);
        try {
            MySpatialBinConsumer mySpatialBinProcessor = new MySpatialBinConsumer();
            SpatialProductBinner.processProduct((Product)new Product("p", "t", 32, 256), (SpatialBinner)new SpatialBinner(ctx, (SpatialBinConsumer)mySpatialBinProcessor), new HashMap(), null);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testProcessProduct() throws Exception {
        BinningContext ctx = SpatialProductBinnerTest.createValidCtx(1, null);
        Product product = SpatialProductBinnerTest.createProduct();
        MySpatialBinConsumer mySpatialBinProcessor = new MySpatialBinConsumer();
        SpatialProductBinner.processProduct((Product)product, (SpatialBinner)new SpatialBinner(ctx, (SpatialBinConsumer)mySpatialBinProcessor), new HashMap(), (ProgressMonitor)ProgressMonitor.NULL);
        Assert.assertEquals((long)8192L, (long)mySpatialBinProcessor.numObs);
    }

    @Test
    public void testProcessProductWithDataPeriod() throws Exception {
        DataPeriod testDataPeriod = new DataPeriod(){

            public DataPeriod.Membership getObservationMembership(double lon, double time) {
                return DataPeriod.Membership.SUBSEQUENT_PERIODS;
            }
        };
        BinningContext ctx = SpatialProductBinnerTest.createValidCtx(1, testDataPeriod);
        Product product = SpatialProductBinnerTest.createProduct();
        MySpatialBinConsumer mySpatialBinProcessor = new MySpatialBinConsumer();
        SpatialProductBinner.processProduct((Product)product, (SpatialBinner)new SpatialBinner(ctx, (SpatialBinConsumer)mySpatialBinProcessor), new HashMap(), (ProgressMonitor)ProgressMonitor.NULL);
        Assert.assertEquals((long)0L, (long)mySpatialBinProcessor.numObs);
    }

    @Test
    public void testProcessProductWithSuperSampling() throws Exception {
        int superSampling = 3;
        BinningContext ctx = SpatialProductBinnerTest.createValidCtx(superSampling, null);
        Product product = SpatialProductBinnerTest.createProduct();
        MySpatialBinConsumer mySpatialBinConsumer = new MySpatialBinConsumer();
        SpatialProductBinner.processProduct((Product)product, (SpatialBinner)new SpatialBinner(ctx, (SpatialBinConsumer)mySpatialBinConsumer), new HashMap(), (ProgressMonitor)ProgressMonitor.NULL);
        Assert.assertEquals((long)(8192 * superSampling * superSampling), (long)mySpatialBinConsumer.numObs);
    }

    @Test
    public void testAddedBands() throws Exception {
        BinningContext ctx = SpatialProductBinnerTest.createValidCtx(1, null);
        Product product = SpatialProductBinnerTest.createProduct();
        HashMap productBandListMap = new HashMap();
        SpatialProductBinner.processProduct((Product)product, (SpatialBinner)new SpatialBinner(ctx, (SpatialBinConsumer)new MySpatialBinConsumer()), productBandListMap, (ProgressMonitor)ProgressMonitor.NULL);
        Assert.assertEquals((long)1L, (long)productBandListMap.size());
        List bandList = (List)productBandListMap.get(product);
        Assert.assertNotNull((Object)bandList);
        VariableContext variableContext = ctx.getVariableContext();
        Assert.assertEquals((long)variableContext.getVariableCount(), (long)bandList.size());
        for (int i = 0; i < bandList.size(); ++i) {
            Assert.assertEquals((Object)variableContext.getVariableName(i), (Object)((Band)bandList.get(i)).getName());
        }
    }

    @Test
    public void testProcessProductWithMask() throws Exception {
        BinningContext ctx = SpatialProductBinnerTest.createValidCtx(1, null);
        VariableContextImpl variableContext = (VariableContextImpl)ctx.getVariableContext();
        variableContext.setMaskExpr("floor(X) % 2");
        Product product = SpatialProductBinnerTest.createProduct();
        MySpatialBinConsumer mySpatialBinConsumer = new MySpatialBinConsumer();
        SpatialBinner spatialBinner = new SpatialBinner(ctx, (SpatialBinConsumer)mySpatialBinConsumer);
        long numObservations = SpatialProductBinner.processProduct((Product)product, (SpatialBinner)spatialBinner, new HashMap(), (ProgressMonitor)ProgressMonitor.NULL);
        Assert.assertEquals((long)4096L, (long)numObservations);
        Assert.assertEquals((long)numObservations, (long)mySpatialBinConsumer.numObs);
    }

    @Test
    public void testProcessProductWithMaskAndSuperSampling() throws Exception {
        int superSampling = 3;
        BinningContext ctx = SpatialProductBinnerTest.createValidCtx(superSampling, null);
        VariableContextImpl variableContext = (VariableContextImpl)ctx.getVariableContext();
        variableContext.setMaskExpr("floor(X) % 2");
        Product product = SpatialProductBinnerTest.createProduct();
        MySpatialBinConsumer mySpatialBinConsumer = new MySpatialBinConsumer();
        SpatialBinner spatialBinner = new SpatialBinner(ctx, (SpatialBinConsumer)mySpatialBinConsumer);
        long numObservations = SpatialProductBinner.processProduct((Product)product, (SpatialBinner)spatialBinner, new HashMap(), (ProgressMonitor)ProgressMonitor.NULL);
        Assert.assertEquals((long)(4096 * superSampling * superSampling), (long)numObservations);
        Assert.assertEquals((long)numObservations, (long)mySpatialBinConsumer.numObs);
    }

    @Test
    public void testGetSuperSamplingSteps() {
        float[] superSamplingSteps = SpatialProductBinner.getSuperSamplingSteps((Integer)1);
        Assert.assertNotNull((Object)superSamplingSteps);
        Assert.assertEquals((long)1L, (long)superSamplingSteps.length);
        Assert.assertEquals((double)0.5, (double)superSamplingSteps[0], (double)1.0E-4);
        superSamplingSteps = SpatialProductBinner.getSuperSamplingSteps((Integer)2);
        Assert.assertNotNull((Object)superSamplingSteps);
        Assert.assertEquals((long)2L, (long)superSamplingSteps.length);
        Assert.assertEquals((double)0.25, (double)superSamplingSteps[0], (double)1.0E-4);
        Assert.assertEquals((double)0.75, (double)superSamplingSteps[1], (double)1.0E-4);
        superSamplingSteps = SpatialProductBinner.getSuperSamplingSteps((Integer)3);
        Assert.assertNotNull((Object)superSamplingSteps);
        Assert.assertEquals((long)3L, (long)superSamplingSteps.length);
        Assert.assertEquals((double)0.1666666716337204, (double)superSamplingSteps[0], (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)superSamplingSteps[1], (double)1.0E-4);
        Assert.assertEquals((double)0.8333333134651184, (double)superSamplingSteps[2], (double)1.0E-4);
    }

    private static Product createProduct() throws Exception {
        Product product = new Product("p", "t", 32, 256);
        TiePointGrid lat = new TiePointGrid("lat", 2, 2, 0.0, 0.0, 32.0, 256.0, new float[]{40.0f, 40.0f, -40.0f, -40.0f});
        TiePointGrid lon = new TiePointGrid("lon", 2, 2, 0.0, 0.0, 32.0, 256.0, new float[]{-80.0f, 80.0f, -80.0f, 80.0f});
        product.addTiePointGrid(lat);
        product.addTiePointGrid(lon);
        product.setSceneGeoCoding((GeoCoding)new TiePointGeoCoding(lat, lon));
        product.setPreferredTileSize(32, 16);
        product.setStartTime(ProductData.UTC.parse((String)"2003-01-01", (String)"yyyy-MM-dd"));
        product.setEndTime(ProductData.UTC.parse((String)"2003-01-02", (String)"yyyy-MM-dd"));
        return product;
    }

    private static BinningContext createValidCtx(int superSampling, DataPeriod dataPeriod) {
        VariableContextImpl variableContext = new VariableContextImpl();
        variableContext.setMaskExpr("!invalid");
        variableContext.defineVariable("invalid", "0");
        variableContext.defineVariable("a", "2.4");
        variableContext.defineVariable("b", "1.8");
        SEAGrid planetaryGrid = new SEAGrid(6);
        BinManager binManager = new BinManager((VariableContext)variableContext, new Aggregator[]{new AggregatorAverage((VariableContext)variableContext, "a", 0.0), new AggregatorAverage((VariableContext)variableContext, "b", 0.0)});
        return new BinningContextImpl((PlanetaryGrid)planetaryGrid, binManager, CompositingType.BINNING, superSampling, dataPeriod, null);
    }

    private static class MySpatialBinConsumer
    implements SpatialBinConsumer {
        int numObs;

        private MySpatialBinConsumer() {
        }

        public void consumeSpatialBins(BinningContext binningContext, List<SpatialBin> spatialBins) {
            for (SpatialBin spatialBin : spatialBins) {
                Assert.assertEquals((float)2.4f, (float)spatialBin.getFeatureValues()[0], (float)0.01f);
                Assert.assertEquals((float)1.8f, (float)spatialBin.getFeatureValues()[2], (float)0.01f);
                this.numObs += spatialBin.getNumObs();
            }
        }
    }
}

