/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.esa.snap.binning.Aggregator;
import org.esa.snap.binning.BinManager;
import org.esa.snap.binning.MyVariableContext;
import org.esa.snap.binning.Observation;
import org.esa.snap.binning.SpatialBin;
import org.esa.snap.binning.TemporalBin;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.binning.Vector;
import org.esa.snap.binning.aggregators.AggregatorAverage;
import org.esa.snap.binning.aggregators.AggregatorAverageML;
import org.esa.snap.binning.aggregators.AggregatorMinMax;
import org.esa.snap.binning.support.ObservationImpl;
import org.junit.Assert;
import org.junit.Test;

public class TemporalBinTest {
    @Test
    public void testIllegalConstructorCalls() {
        try {
            new TemporalBin(0L, -1);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testLegalConstructorCalls() {
        TemporalBin bin = new TemporalBin(42L, 0);
        Assert.assertEquals((long)42L, (long)bin.getIndex());
        bin = new TemporalBin(43L, 3);
        Assert.assertEquals((long)43L, (long)bin.getIndex());
    }

    @Test
    public void testBinAggregationAndIO() throws IOException {
        MyVariableContext variableContext = new MyVariableContext("A", "B", "C");
        BinManager bman = new BinManager((VariableContext)variableContext, new Aggregator[]{new AggregatorMinMax((VariableContext)variableContext, "A", "out"), new AggregatorAverage((VariableContext)variableContext, "B", 0.0), new AggregatorAverageML((VariableContext)variableContext, "C", 0.5)});
        TemporalBin tbin = bman.createTemporalBin(0L);
        SpatialBin sbin = bman.createSpatialBin(0L);
        bman.aggregateSpatialBin((Observation)new ObservationImpl(0.0, 0.0, 0.0, new float[]{0.2f, 4.0f, 4.0f}), sbin);
        bman.completeSpatialBin(sbin);
        bman.aggregateTemporalBin(sbin, tbin);
        sbin = bman.createSpatialBin(0L);
        bman.aggregateSpatialBin((Observation)new ObservationImpl(0.0, 0.0, 0.0, new float[]{0.6f, 2.0f, 2.0f}), sbin);
        bman.completeSpatialBin(sbin);
        bman.aggregateTemporalBin(sbin, tbin);
        sbin = bman.createSpatialBin(0L);
        bman.aggregateSpatialBin((Observation)new ObservationImpl(0.0, 0.0, 0.0, new float[]{0.4f, 6.0f, 6.0f}), sbin);
        bman.completeSpatialBin(sbin);
        bman.aggregateTemporalBin(sbin, tbin);
        Assert.assertEquals((long)3L, (long)tbin.getNumObs());
        Vector agg1 = bman.getTemporalVector(tbin, 0);
        Vector agg2 = bman.getTemporalVector(tbin, 1);
        Vector agg3 = bman.getTemporalVector(tbin, 2);
        Assert.assertEquals((long)2L, (long)agg1.size());
        Assert.assertEquals((float)0.2f, (float)agg1.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)0.6f, (float)agg1.get(1), (float)1.0E-5f);
        Assert.assertEquals((long)3L, (long)agg2.size());
        Assert.assertEquals((float)12.0f, (float)agg2.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)56.0f, (float)agg2.get(1), (float)1.0E-5f);
        Assert.assertEquals((float)3.0f, (float)agg2.get(2), (float)1.0E-5f);
        Assert.assertEquals((long)3L, (long)agg3.size());
        Assert.assertEquals((float)3.871201f, (float)agg3.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)5.612667f, (float)agg3.get(1), (float)1.0E-5f);
        Assert.assertEquals((float)3.0f, (float)agg3.get(2), (float)1.0E-5f);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        tbin.write((DataOutput)new DataOutputStream(baos));
        byte[] bytes = baos.toByteArray();
        TemporalBin tbinCopy = TemporalBin.read((DataInput)new DataInputStream(new ByteArrayInputStream(bytes)));
        Assert.assertEquals((long)-1L, (long)tbinCopy.getIndex());
        Assert.assertEquals((long)3L, (long)tbinCopy.getNumObs());
        Vector agg1Copy = bman.getTemporalVector(tbinCopy, 0);
        Vector agg2Copy = bman.getTemporalVector(tbinCopy, 1);
        Vector agg3Copy = bman.getTemporalVector(tbinCopy, 2);
        Assert.assertEquals((long)2L, (long)agg1.size());
        Assert.assertEquals((float)0.2f, (float)agg1Copy.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)0.6f, (float)agg1Copy.get(1), (float)1.0E-5f);
        Assert.assertEquals((long)3L, (long)agg2.size());
        Assert.assertEquals((float)12.0f, (float)agg2Copy.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)56.0f, (float)agg2Copy.get(1), (float)1.0E-5f);
        Assert.assertEquals((float)3.0f, (float)agg2Copy.get(2), (float)1.0E-5f);
        Assert.assertEquals((long)3L, (long)agg3.size());
        Assert.assertEquals((float)3.871201f, (float)agg3Copy.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)5.612667f, (float)agg3Copy.get(1), (float)1.0E-5f);
        Assert.assertEquals((float)3.0f, (float)agg3Copy.get(2), (float)1.0E-5f);
    }

    @Test
    public void testToString() {
        TemporalBin bin = new TemporalBin(42L, 0);
        Assert.assertEquals((Object)"TemporalBin{index=42, numObs=0, numPasses=0, featureValues=[]}", (Object)bin.toString());
        bin = new TemporalBin(43L, 3);
        Assert.assertEquals((Object)"TemporalBin{index=43, numObs=0, numPasses=0, featureValues=[0.0, 0.0, 0.0]}", (Object)bin.toString());
        bin.setNumPasses(7);
        bin.setNumObs(3);
        Assert.assertEquals((Object)"TemporalBin{index=43, numObs=3, numPasses=7, featureValues=[0.0, 0.0, 0.0]}", (Object)bin.toString());
        bin.featureValues[0] = 1.2f;
        bin.featureValues[2] = 2.4f;
        Assert.assertEquals((Object)"TemporalBin{index=43, numObs=3, numPasses=7, featureValues=[1.2, 0.0, 2.4]}", (Object)bin.toString());
    }

    @Test
    public void testBinCreationWithIndex() throws Exception {
        TemporalBin bin = TemporalBin.read((long)10L, (DataInput)new DataInputStream(new InputStream(){

            @Override
            public int read() throws IOException {
                return 0;
            }
        }));
        Assert.assertEquals((long)10L, (long)bin.getIndex());
    }
}

