/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.PlanarImage;
import org.esa.snap.binning.SamplePointer;
import org.junit.Assert;
import org.junit.Test;

public class SamplePointerTest {
    @Test
    public void testCreationOfSamplingPoints() throws Exception {
        Point2D.Float[] points = SamplePointer.createSamplingPoints((float[])new float[]{0.16666667f, 0.5f, 0.8333333f});
        Assert.assertEquals((long)9L, (long)points.length);
        Assert.assertEquals((Object)new Point2D.Float(0.16666667f, 0.16666667f), (Object)points[0]);
        Assert.assertEquals((Object)new Point2D.Float(0.5f, 0.16666667f), (Object)points[1]);
        Assert.assertEquals((Object)new Point2D.Float(0.8333333f, 0.16666667f), (Object)points[2]);
        Assert.assertEquals((Object)new Point2D.Float(0.16666667f, 0.5f), (Object)points[3]);
        Assert.assertEquals((Object)new Point2D.Float(0.5f, 0.5f), (Object)points[4]);
        Assert.assertEquals((Object)new Point2D.Float(0.8333333f, 0.5f), (Object)points[5]);
        Assert.assertEquals((Object)new Point2D.Float(0.16666667f, 0.8333333f), (Object)points[6]);
        Assert.assertEquals((Object)new Point2D.Float(0.5f, 0.8333333f), (Object)points[7]);
        Assert.assertEquals((Object)new Point2D.Float(0.8333333f, 0.8333333f), (Object)points[8]);
    }

    @Test
    public void testSamplePointerAllValid() throws Exception {
        int width = 2;
        int height = 3;
        PlanarImage[] sourceImages = this.createSourceImages(width, height);
        Rectangle[] bounds = new Rectangle[]{new Rectangle(0, 0, width, height)};
        SamplePointer pointer = SamplePointer.create((PlanarImage[])sourceImages, (Rectangle[])bounds);
        Point2D.Float center = new Point2D.Float(0.5f, 0.5f);
        Assert.assertTrue((boolean)pointer.canMove());
        pointer.move();
        Assert.assertEquals((long)0L, (long)pointer.getX());
        Assert.assertEquals((long)0L, (long)pointer.getY());
        Assert.assertEquals((Object)center, (Object)pointer.getSuperSamplingPoint());
        Assert.assertTrue((boolean)pointer.canMove());
        pointer.move();
        Assert.assertEquals((long)1L, (long)pointer.getX());
        Assert.assertEquals((long)0L, (long)pointer.getY());
        Assert.assertEquals((Object)center, (Object)pointer.getSuperSamplingPoint());
        this.movePointer(pointer, 3);
        Assert.assertEquals((long)0L, (long)pointer.getX());
        Assert.assertEquals((long)2L, (long)pointer.getY());
        pointer.move();
        Assert.assertEquals((long)1L, (long)pointer.getX());
        Assert.assertEquals((long)2L, (long)pointer.getY());
        Assert.assertFalse((boolean)pointer.canMove());
        try {
            pointer.move();
            Assert.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testSamplePointerAllValidWithSuperSampling() throws Exception {
        int width = 2;
        int height = 3;
        Rectangle[] bounds = new Rectangle[]{new Rectangle(0, 0, width, height)};
        PlanarImage[] sourceImages = this.createSourceImages(width, height);
        Point2D.Float[] superSamplingPoints = new Point2D.Float[]{new Point2D.Float(0.33f, 0.33f), new Point2D.Float(0.66f, 0.66f), new Point2D.Float(0.99f, 0.99f)};
        SamplePointer pointer = SamplePointer.create((PlanarImage[])sourceImages, (Rectangle[])bounds, (Point2D.Float[])superSamplingPoints);
        Assert.assertTrue((boolean)pointer.canMove());
        pointer.move();
        Assert.assertEquals((long)0L, (long)pointer.getX());
        Assert.assertEquals((long)0L, (long)pointer.getY());
        Assert.assertEquals((Object)superSamplingPoints[0], (Object)pointer.getSuperSamplingPoint());
        Assert.assertTrue((boolean)pointer.canMove());
        pointer.move();
        Assert.assertEquals((long)0L, (long)pointer.getX());
        Assert.assertEquals((long)0L, (long)pointer.getY());
        Assert.assertEquals((Object)superSamplingPoints[1], (Object)pointer.getSuperSamplingPoint());
        Assert.assertTrue((boolean)pointer.canMove());
        pointer.move();
        Assert.assertEquals((long)0L, (long)pointer.getX());
        Assert.assertEquals((long)0L, (long)pointer.getY());
        Assert.assertEquals((Object)superSamplingPoints[2], (Object)pointer.getSuperSamplingPoint());
        Assert.assertTrue((boolean)pointer.canMove());
        pointer.move();
        Assert.assertEquals((long)1L, (long)pointer.getX());
        Assert.assertEquals((long)0L, (long)pointer.getY());
        Assert.assertEquals((Object)superSamplingPoints[0], (Object)pointer.getSuperSamplingPoint());
        this.movePointer(pointer, 13);
        Assert.assertTrue((boolean)pointer.canMove());
        Assert.assertEquals((long)1L, (long)pointer.getX());
        Assert.assertEquals((long)2L, (long)pointer.getY());
        Assert.assertEquals((Object)superSamplingPoints[1], (Object)pointer.getSuperSamplingPoint());
    }

    private PlanarImage[] createSourceImages(int width, int height) {
        WritableRaster sourceTile = Raster.createBandedRaster(3, width, height, 1, new Point(0, 0));
        ColorModel cm = PlanarImage.getDefaultColorModel((int)sourceTile.getDataBuffer().getDataType(), (int)1);
        BufferedImage bufferedImage = new BufferedImage(cm, sourceTile, false, null);
        return new PlanarImage[]{PlanarImage.wrapRenderedImage((RenderedImage)bufferedImage)};
    }

    private void movePointer(SamplePointer pointer, int steps) {
        for (int i = 0; i < steps; ++i) {
            pointer.move();
        }
    }
}

