/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.esa.snap.binning.BinManager;
import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.binning.Reprojector;
import org.esa.snap.binning.TemporalBin;
import org.esa.snap.binning.TemporalBinRenderer;
import org.esa.snap.binning.Vector;
import org.esa.snap.binning.support.SEAGrid;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReprojectorTest {
    static final int NAN = -1;
    private BinManager binManager = new BinManager();
    private PlanetaryGrid planetaryGrid;
    private NobsRaster raster;
    private int width;
    private Reprojector reprojector;

    @Before
    public void setUp() throws Exception {
        this.planetaryGrid = new SEAGrid(6);
        Assert.assertEquals((long)46L, (long)this.planetaryGrid.getNumBins());
        Assert.assertEquals((long)3L, (long)this.planetaryGrid.getNumCols(0));
        Assert.assertEquals((long)8L, (long)this.planetaryGrid.getNumCols(1));
        Assert.assertEquals((long)12L, (long)this.planetaryGrid.getNumCols(2));
        Assert.assertEquals((long)12L, (long)this.planetaryGrid.getNumCols(3));
        Assert.assertEquals((long)8L, (long)this.planetaryGrid.getNumCols(4));
        Assert.assertEquals((long)3L, (long)this.planetaryGrid.getNumCols(5));
        this.width = 2 * this.planetaryGrid.getNumRows();
        int height = this.planetaryGrid.getNumRows();
        Assert.assertEquals((long)12L, (long)this.width);
        Assert.assertEquals((long)6L, (long)height);
        this.raster = new NobsRaster(new Rectangle(this.width, height));
        Assert.assertEquals((Object)"------------\n------------\n------------\n------------\n------------\n------------\n", (Object)this.raster.toString());
        this.reprojector = new Reprojector(this.planetaryGrid, (TemporalBinRenderer)this.raster);
        this.reprojector.begin();
    }

    @Test
    public void testSubPixelRegion() throws Exception {
        NobsRaster raster = new NobsRaster(new Rectangle(2, 2, 6, 3));
        Assert.assertEquals((Object)"------\n------\n------\n", (Object)((Object)raster).toString());
        Reprojector reprojector = new Reprojector(this.planetaryGrid, (TemporalBinRenderer)raster);
        reprojector.begin();
        ArrayList<TemporalBin> bins = new ArrayList<TemporalBin>();
        int i = 0;
        while ((long)i < this.planetaryGrid.getNumBins()) {
            bins.add(this.createTBin(i));
            ++i;
        }
        reprojector.processPart(bins.iterator());
        reprojector.end();
        Assert.assertEquals((Object)"******\n******\n******\n", (Object)((Object)raster).toString());
    }

    @Test
    public void testProcessBins_Full() throws Exception {
        ArrayList<TemporalBin> bins = new ArrayList<TemporalBin>();
        int i = 0;
        while ((long)i < this.planetaryGrid.getNumBins()) {
            bins.add(this.createTBin(i));
            ++i;
        }
        this.reprojector.processPart(bins.iterator());
        this.reprojector.end();
        Assert.assertEquals((Object)"************\n************\n************\n************\n************\n************\n", (Object)this.raster.toString());
    }

    @Test
    public void testProcessBins_Full_multipleParts() throws Exception {
        ArrayList<TemporalBin> bins = new ArrayList<TemporalBin>();
        int numRows = this.planetaryGrid.getNumRows();
        int startBinIndex = 0;
        for (int row = 0; row < numRows; ++row) {
            int numCols = this.planetaryGrid.getNumCols(row);
            for (int i = startBinIndex; i < startBinIndex + numCols; ++i) {
                bins.add(this.createTBin(i));
            }
            startBinIndex += numCols;
            this.reprojector.processPart(bins.iterator());
            bins.clear();
        }
        this.reprojector.end();
        Assert.assertEquals((Object)"************\n************\n************\n************\n************\n************\n", (Object)this.raster.toString());
    }

    @Test
    public void testProcessBins_Empty() throws Exception {
        ArrayList bins = new ArrayList();
        this.reprojector.processPart(bins.iterator());
        this.reprojector.end();
        Assert.assertEquals((Object)"++++++++++++\n++++++++++++\n++++++++++++\n++++++++++++\n++++++++++++\n++++++++++++\n", (Object)this.raster.toString());
    }

    @Test
    public void testProcessBins_Empty_multipleParts() throws Exception {
        ArrayList bins = new ArrayList();
        this.reprojector.processPart(bins.iterator());
        this.reprojector.processPart(bins.iterator());
        this.reprojector.processPart(bins.iterator());
        this.reprojector.end();
        Assert.assertEquals((Object)"++++++++++++\n++++++++++++\n++++++++++++\n++++++++++++\n++++++++++++\n++++++++++++\n", (Object)this.raster.toString());
    }

    @Test
    public void testProcessBins_SomeLinesMissing() throws Exception {
        ArrayList<TemporalBin> bins = new ArrayList<TemporalBin>();
        int i = 0;
        while ((long)i < this.planetaryGrid.getNumBins()) {
            if (this.planetaryGrid.getRowIndex((long)i) != 2 && this.planetaryGrid.getRowIndex((long)i) != 4) {
                bins.add(this.createTBin(i));
            }
            ++i;
        }
        this.reprojector.processPart(bins.iterator());
        this.reprojector.end();
        Assert.assertEquals((Object)"************\n************\n++++++++++++\n************\n++++++++++++\n************\n", (Object)this.raster.toString());
    }

    @Test
    public void testProcessBins_SomeLinesMissing_multipleParts() throws Exception {
        ArrayList<TemporalBin> bins = new ArrayList<TemporalBin>();
        int numRows = this.planetaryGrid.getNumRows();
        int startBinIndex = 0;
        for (int row = 0; row < numRows; ++row) {
            int numCols = this.planetaryGrid.getNumCols(row);
            for (int i = startBinIndex; i < startBinIndex + numCols; ++i) {
                if (this.planetaryGrid.getRowIndex((long)i) == 2 || this.planetaryGrid.getRowIndex((long)i) == 4) continue;
                bins.add(this.createTBin(i));
            }
            startBinIndex += numCols;
            this.reprojector.processPart(bins.iterator());
            bins.clear();
        }
        this.reprojector.end();
        Assert.assertEquals((Object)"************\n************\n++++++++++++\n************\n++++++++++++\n************\n", (Object)this.raster.toString());
    }

    @Test
    public void testProcessBins_Alternating() throws Exception {
        ArrayList<TemporalBin> bins = new ArrayList<TemporalBin>();
        int i = 0;
        while ((long)i < this.planetaryGrid.getNumBins()) {
            bins.add(this.createTBin(i));
            ++i;
            ++i;
        }
        this.reprojector.processPart(bins.iterator());
        this.reprojector.end();
        Assert.assertEquals((Object)"****++++****\n+**+**+**+**\n+*+*+*+*+*+*\n+*+*+*+*+*+*\n+**+**+**+**\n++++****++++\n", (Object)this.raster.toString());
    }

    @Test
    public void testProcessBins_TopMissing() throws Exception {
        ArrayList<TemporalBin> bins = new ArrayList<TemporalBin>();
        int i = 15;
        while ((long)i < this.planetaryGrid.getNumBins()) {
            bins.add(this.createTBin(i));
            ++i;
        }
        this.reprojector.processPart(bins.iterator());
        this.reprojector.end();
        Assert.assertEquals((Object)"++++++++++++\n++++++++++++\n++++********\n************\n************\n************\n", (Object)this.raster.toString());
    }

    @Test
    public void testProcessBins_BottomMissing() throws Exception {
        ArrayList<TemporalBin> bins = new ArrayList<TemporalBin>();
        for (int i = 0; i < 25; ++i) {
            bins.add(this.createTBin(i));
        }
        this.reprojector.processPart(bins.iterator());
        this.reprojector.end();
        Assert.assertEquals((Object)"************\n************\n************\n**++++++++++\n++++++++++++\n++++++++++++\n", (Object)this.raster.toString());
    }

    @Test
    public void testProcessRowWithBins_CompleteEquator() throws Exception {
        List<TemporalBin> binRow = Arrays.asList(this.createTBin(11), this.createTBin(12), this.createTBin(13), this.createTBin(14), this.createTBin(15), this.createTBin(16), this.createTBin(17), this.createTBin(18), this.createTBin(19), this.createTBin(20), this.createTBin(21), this.createTBin(22));
        int y = 2;
        this.reprojector.processPart(binRow.iterator());
        int[] nobsData = this.raster.nobsData;
        Assert.assertEquals((long)11L, (long)nobsData[y * this.width + 0]);
        Assert.assertEquals((long)12L, (long)nobsData[y * this.width + 1]);
        Assert.assertEquals((long)13L, (long)nobsData[y * this.width + 2]);
        Assert.assertEquals((long)14L, (long)nobsData[y * this.width + 3]);
        Assert.assertEquals((long)15L, (long)nobsData[y * this.width + 4]);
        Assert.assertEquals((long)16L, (long)nobsData[y * this.width + 5]);
        Assert.assertEquals((long)17L, (long)nobsData[y * this.width + 6]);
        Assert.assertEquals((long)18L, (long)nobsData[y * this.width + 7]);
        Assert.assertEquals((long)19L, (long)nobsData[y * this.width + 8]);
        Assert.assertEquals((long)20L, (long)nobsData[y * this.width + 9]);
        Assert.assertEquals((long)21L, (long)nobsData[y * this.width + 10]);
        Assert.assertEquals((long)22L, (long)nobsData[y * this.width + 11]);
    }

    @Test
    public void testProcessRowWithBins_IncompleteEquator() throws Exception {
        List<TemporalBin> binRow = Arrays.asList(this.createTBin(12), this.createTBin(13), this.createTBin(16), this.createTBin(18), this.createTBin(19), this.createTBin(20), this.createTBin(21));
        int y = 2;
        this.reprojector.processPart(binRow.iterator());
        int[] nobsData = this.raster.nobsData;
        Assert.assertEquals((long)-1L, (long)nobsData[y * this.width + 0]);
        Assert.assertEquals((long)12L, (long)nobsData[y * this.width + 1]);
        Assert.assertEquals((long)13L, (long)nobsData[y * this.width + 2]);
        Assert.assertEquals((long)-1L, (long)nobsData[y * this.width + 3]);
        Assert.assertEquals((long)-1L, (long)nobsData[y * this.width + 4]);
        Assert.assertEquals((long)16L, (long)nobsData[y * this.width + 5]);
        Assert.assertEquals((long)-1L, (long)nobsData[y * this.width + 6]);
        Assert.assertEquals((long)18L, (long)nobsData[y * this.width + 7]);
        Assert.assertEquals((long)19L, (long)nobsData[y * this.width + 8]);
        Assert.assertEquals((long)20L, (long)nobsData[y * this.width + 9]);
        Assert.assertEquals((long)21L, (long)nobsData[y * this.width + 10]);
        Assert.assertEquals((long)-1L, (long)nobsData[y * this.width + 11]);
    }

    @Test
    public void testProcessRowWithBins_CompletePolar() throws Exception {
        List<TemporalBin> binRow = Arrays.asList(this.createTBin(0), this.createTBin(1), this.createTBin(2));
        int y = 0;
        this.reprojector.processPart(binRow.iterator());
        int[] nobsData = this.raster.nobsData;
        Assert.assertEquals((long)0L, (long)nobsData[y * this.width + 0]);
        Assert.assertEquals((long)0L, (long)nobsData[y * this.width + 1]);
        Assert.assertEquals((long)0L, (long)nobsData[y * this.width + 2]);
        Assert.assertEquals((long)0L, (long)nobsData[y * this.width + 3]);
        Assert.assertEquals((long)1L, (long)nobsData[y * this.width + 4]);
        Assert.assertEquals((long)1L, (long)nobsData[y * this.width + 5]);
        Assert.assertEquals((long)1L, (long)nobsData[y * this.width + 6]);
        Assert.assertEquals((long)1L, (long)nobsData[y * this.width + 7]);
        Assert.assertEquals((long)2L, (long)nobsData[y * this.width + 8]);
        Assert.assertEquals((long)2L, (long)nobsData[y * this.width + 9]);
        Assert.assertEquals((long)2L, (long)nobsData[y * this.width + 10]);
        Assert.assertEquals((long)2L, (long)nobsData[y * this.width + 11]);
    }

    @Test
    public void testProcessRowWithBins_IncompletePolar() throws Exception {
        List<TemporalBin> binRow = Arrays.asList(this.createTBin(0), this.createTBin(2));
        int y = 0;
        this.reprojector.processPart(binRow.iterator());
        int[] nobsData = this.raster.nobsData;
        Assert.assertEquals((long)0L, (long)nobsData[y * this.width + 0]);
        Assert.assertEquals((long)0L, (long)nobsData[y * this.width + 1]);
        Assert.assertEquals((long)0L, (long)nobsData[y * this.width + 2]);
        Assert.assertEquals((long)0L, (long)nobsData[y * this.width + 3]);
        Assert.assertEquals((long)-1L, (long)nobsData[y * this.width + 4]);
        Assert.assertEquals((long)-1L, (long)nobsData[y * this.width + 5]);
        Assert.assertEquals((long)-1L, (long)nobsData[y * this.width + 6]);
        Assert.assertEquals((long)-1L, (long)nobsData[y * this.width + 7]);
        Assert.assertEquals((long)2L, (long)nobsData[y * this.width + 8]);
        Assert.assertEquals((long)2L, (long)nobsData[y * this.width + 9]);
        Assert.assertEquals((long)2L, (long)nobsData[y * this.width + 10]);
        Assert.assertEquals((long)2L, (long)nobsData[y * this.width + 11]);
    }

    private TemporalBin createTBin(int idx) {
        TemporalBin temporalBin = this.binManager.createTemporalBin((long)idx);
        temporalBin.setNumObs(idx);
        return temporalBin;
    }

    private static class NobsRaster
    implements TemporalBinRenderer {
        private final int w;
        private final int h;
        private final int[] nobsData;
        private final Rectangle rasterRegion;

        private NobsRaster(Rectangle rasterRegion) {
            this.rasterRegion = rasterRegion;
            this.w = rasterRegion.width;
            this.h = rasterRegion.height;
            this.nobsData = new int[this.w * this.h];
            Arrays.fill(this.nobsData, -2);
        }

        public Rectangle getRasterRegion() {
            return this.rasterRegion;
        }

        public void begin() throws IOException {
        }

        public void end() throws IOException {
        }

        public void renderBin(int x, int y, TemporalBin temporalBin, Vector outputVector) throws IOException {
            this.nobsData[y * this.w + x] = temporalBin.getNumObs();
        }

        public void renderMissingBin(int x, int y) throws IOException {
            this.nobsData[y * this.w + x] = -1;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.nobsData.length; ++i) {
                int d = this.nobsData[i];
                if (d == -2) {
                    sb.append('-');
                } else if (d == -1) {
                    sb.append("+");
                } else {
                    sb.append("*");
                }
                if ((i + 1) % this.w != 0) continue;
                sb.append('\n');
            }
            return sb.toString();
        }
    }
}

