/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.support;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.esa.snap.binning.DataPeriod;
import org.esa.snap.binning.support.SpatialDataPeriod;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.ProductUtils;

public class SpatialDataDayComputer {
    public static final String DATE_INPUT_PATTERN = "yyyy-MM-dd";

    public static void main(String[] args) throws IOException, ParseException {
        DataPeriod.Membership[] memberships;
        String startDate = args[0];
        Double minDataHour = Double.valueOf(args[1]);
        File directory = new File(args[2]);
        String extension = args[3];
        File[] subdirs = SpatialDataDayComputer.getDirectories(directory);
        ArrayList filesList = new ArrayList();
        for (File dir : subdirs) {
            Collections.addAll(filesList, SpatialDataDayComputer.getProductFiles(dir, extension));
        }
        Collections.sort(filesList, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return f1.getName().compareTo(f2.getName());
            }
        });
        int mode = 3;
        Double periodDuration = 1.0;
        ProductData.UTC startUtc = ProductData.UTC.parse((String)startDate, (String)DATE_INPUT_PATTERN);
        SpatialDataPeriod dataPeriod = new SpatialDataPeriod(startUtc.getMJD(), periodDuration.doubleValue(), minDataHour.doubleValue());
        System.out.println("startUtc       = " + startUtc);
        System.out.println("minDataHour    = " + minDataHour);
        System.out.println("periodDuration = " + periodDuration);
        System.out.println("num files      = " + filesList.size());
        System.out.println();
        if (mode == 1) {
            memberships = DataPeriod.Membership.values();
            System.out.format("%s\t%s\t%s\t%s\t%s\n", "Product_Name", "num_pixels", memberships[0], memberships[1], memberships[2]);
        } else if (mode == 2) {
            System.out.format("%s\t%s\t%s\t%s\t%s\n", "Product_Name", "top_left", "top_right", "bottom_left", "bottom_right");
        } else if (mode == 3) {
            memberships = DataPeriod.Membership.values();
            System.out.format("%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\n", "Product_Name", "num_pixels", memberships[0], memberships[1], memberships[2], "top_left", "top_right", "bottom_left", "bottom_right");
        }
        for (File file : filesList) {
            int height;
            int width;
            Product product = ProductIO.readProduct((File)file);
            if (mode == 1) {
                width = product.getSceneRasterWidth();
                height = product.getSceneRasterHeight();
                int[] distribution = SpatialDataDayComputer.analysePrecise((DataPeriod)dataPeriod, product);
                SpatialDataDayComputer.printPrecise(file.getName(), width, height, distribution);
            } else if (mode == 2) {
                DataPeriod.Membership[] basic = SpatialDataDayComputer.analyseBasic((DataPeriod)dataPeriod, product);
                SpatialDataDayComputer.printBasic(file.getName(), basic);
            } else if (mode == 3) {
                width = product.getSceneRasterWidth();
                height = product.getSceneRasterHeight();
                DataPeriod.Membership[] basic = SpatialDataDayComputer.analyseBasic((DataPeriod)dataPeriod, product);
                int[] distribution = SpatialDataDayComputer.analysePrecise((DataPeriod)dataPeriod, product);
                SpatialDataDayComputer.printBooth(file.getName(), width, height, distribution, basic);
            }
            product.dispose();
        }
    }

    private static void printBooth(String productName, int width, int height, int[] distribution, DataPeriod.Membership[] basic) {
        System.out.format("%s\t%d\t%d\t%d\t%d", productName, width * height, distribution[0], distribution[1], distribution[2]);
        System.out.format("\t%s\t%s\t%s\t%s\n", basic[0], basic[1], basic[2], basic[3]);
    }

    private static void printBasic(String productName, DataPeriod.Membership[] basic) {
        System.out.format("%s\t%s\t%s\t%s\t%s\n", productName, basic[0], basic[1], basic[2], basic[3]);
    }

    private static void printPrecise(String productName, int width, int height, int[] distribution) {
        System.out.format("%s\t%d\t%d\t%d\t%d\n", productName, width * height, distribution[0], distribution[1], distribution[2]);
    }

    static DataPeriod.Membership[] analyseBasic(DataPeriod dataPeriod, Product product) {
        GeoCoding geoCoding = product.getSceneGeoCoding();
        ProductData.UTC firstScanLineTime = ProductUtils.getScanLineTime((Product)product, (double)0.0);
        double firstLon = geoCoding.getGeoPos((PixelPos)new PixelPos((double)0.0, (double)0.0), null).lon;
        DataPeriod.Membership fl = dataPeriod.getObservationMembership(firstLon, firstScanLineTime.getMJD());
        double lastLon = geoCoding.getGeoPos((PixelPos)new PixelPos((double)((double)(product.getSceneRasterWidth() - 1)), (double)0.0), null).lon;
        DataPeriod.Membership fr = dataPeriod.getObservationMembership(lastLon, firstScanLineTime.getMJD());
        ProductData.UTC lastScanLineTime = ProductUtils.getScanLineTime((Product)product, (double)(product.getSceneRasterHeight() - 1));
        firstLon = geoCoding.getGeoPos((PixelPos)new PixelPos((double)0.0, (double)((double)(product.getSceneRasterHeight() - 1))), null).lon;
        DataPeriod.Membership ll = dataPeriod.getObservationMembership(firstLon, lastScanLineTime.getMJD());
        lastLon = geoCoding.getGeoPos((PixelPos)new PixelPos((double)((double)(product.getSceneRasterWidth() - 1)), (double)((double)(product.getSceneRasterHeight() - 1))), null).lon;
        DataPeriod.Membership lr = dataPeriod.getObservationMembership(lastLon, lastScanLineTime.getMJD());
        return new DataPeriod.Membership[]{fl, fr, ll, lr};
    }

    static int[] analysePrecise(DataPeriod dataPeriod, Product product) {
        int width = product.getSceneRasterWidth();
        int height = product.getSceneRasterHeight();
        GeoCoding geoCoding = product.getSceneGeoCoding();
        PixelPos pixelPos = new PixelPos();
        GeoPos geoPos = new GeoPos();
        int[] distribution = new int[DataPeriod.Membership.values().length];
        for (int y = 0; y < height; ++y) {
            ProductData.UTC scanLineTime = ProductUtils.getScanLineTime((Product)product, (double)y);
            double mjd = scanLineTime.getMJD();
            for (int x = 0; x < width; ++x) {
                pixelPos.setLocation((double)x, (double)y);
                geoCoding.getGeoPos(pixelPos, geoPos);
                DataPeriod.Membership membership = dataPeriod.getObservationMembership(geoPos.lon, mjd);
                int n = membership.ordinal();
                distribution[n] = distribution[n] + 1;
            }
        }
        return distribution;
    }

    private static File[] getProductFiles(File directory, final String extension) {
        return directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(extension);
            }
        });
    }

    private static File[] getDirectories(File directory) {
        return directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
    }
}

